/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFieldBasedPartitioner<K2, V2>
implements Partitioner<K2, V2> {
    private int numOfPartitionFields;
    private String keyFieldSeparator;

    @Override
    public void configure(JobConf job) {
        this.keyFieldSeparator = job.get("map.output.key.field.separator", "\t");
        this.numOfPartitionFields = job.getInt("num.key.fields.for.partition", 0);
    }

    @Override
    public int getPartition(K2 key, V2 value, int numReduceTasks) {
        String partitionKeyStr = key.toString();
        String[] fields = partitionKeyStr.split(this.keyFieldSeparator);
        if (this.numOfPartitionFields > 0 && this.numOfPartitionFields < fields.length) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.numOfPartitionFields; ++i) {
                sb.append(fields[i]).append(this.keyFieldSeparator);
            }
            partitionKeyStr = sb.toString();
            if (partitionKeyStr.length() > 0) {
                partitionKeyStr = partitionKeyStr.substring(0, partitionKeyStr.length() - 1);
            }
        }
        return (partitionKeyStr.hashCode() & Integer.MAX_VALUE) % numReduceTasks;
    }
}

