/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;

public class ValueHistogram
implements ValueAggregator {
    TreeMap<Object, Object> items = new TreeMap();

    public void addNextValue(Object val) {
        String valCountStr = val.toString();
        int pos = valCountStr.lastIndexOf("\t");
        String valStr = valCountStr;
        String countStr = "1";
        if (pos >= 0) {
            valStr = valCountStr.substring(0, pos);
            countStr = valCountStr.substring(pos + 1);
        }
        Long count = (Long)this.items.get(valStr);
        long inc = Long.parseLong(countStr);
        count = count == null ? Long.valueOf(inc) : Long.valueOf(count + inc);
        this.items.put(valStr, count);
    }

    public String getReport() {
        long[] counts = new long[this.items.size()];
        StringBuffer sb = new StringBuffer();
        Iterator<Object> iter = this.items.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Long count = (Long)iter.next();
            counts[i] = count;
            ++i;
        }
        Arrays.sort(counts);
        sb.append(counts.length);
        i = 0;
        long acc = 0L;
        while (i < counts.length) {
            int j;
            long nextVal = counts[i];
            for (j = i + 1; j < counts.length && counts[j] == nextVal; ++j) {
            }
            acc += nextVal * (long)(j - i);
            i = j;
        }
        double average = 0.0;
        double sd = 0.0;
        if (counts.length > 0) {
            sb.append("\t").append(counts[0]);
            sb.append("\t").append(counts[counts.length / 2]);
            sb.append("\t").append(counts[counts.length - 1]);
            average = (double)acc * 1.0 / (double)counts.length;
            sb.append("\t").append(average);
            for (i = 0; i < counts.length; ++i) {
                double nextDiff = (double)counts[i] - average;
                sd += nextDiff * nextDiff;
            }
            sd = Math.sqrt(sd / (double)counts.length);
            sb.append("\t").append(sd);
        }
        return sb.toString();
    }

    public String getReportDetails() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Object, Object> en : this.items.entrySet()) {
            Object val = en.getKey();
            Long count = (Long)en.getValue();
            sb.append("\t").append(val.toString()).append("\t").append(count).append("\n");
        }
        return sb.toString();
    }

    public ArrayList getCombinerOutput() {
        ArrayList<String> retv = new ArrayList<String>();
        for (Map.Entry<Object, Object> en : this.items.entrySet()) {
            Object val = en.getKey();
            Long count = (Long)en.getValue();
            retv.add(val.toString() + "\t" + count);
        }
        return retv;
    }

    public TreeMap getReportItems() {
        return this.items;
    }

    public void reset() {
        this.items = new TreeMap();
    }
}

