/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.util.StringUtils;

public class MetricsIntValue {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.metrics.util");
    private String name;
    private int value;
    private boolean changed;

    public MetricsIntValue(String nam) {
        this.name = nam;
        this.value = 0;
        this.changed = false;
    }

    public synchronized void set(int newValue) {
        this.value = newValue;
        this.changed = true;
    }

    public synchronized int get() {
        return this.value;
    }

    public synchronized void inc(int incr) {
        this.value += incr;
        this.changed = true;
    }

    public synchronized void inc() {
        ++this.value;
        this.changed = true;
    }

    public synchronized void dec(int decr) {
        this.value -= decr;
        if (this.value < 0) {
            this.value = 0;
        }
        this.changed = true;
    }

    public synchronized void dec() {
        --this.value;
        if (this.value < 0) {
            this.value = 0;
        }
        this.changed = true;
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        if (this.changed) {
            try {
                mr.setMetric(this.name, this.value);
            }
            catch (Exception e) {
                LOG.info((Object)("pushMetric failed for " + this.name + "\n" + StringUtils.stringifyException(e)));
            }
        }
        this.changed = false;
    }
}

