/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.hadoop.metrics.MetricsRecord;

public class MetricsLongValue {
    private String name;
    private long value;
    private boolean changed;

    public MetricsLongValue(String nam) {
        this.name = nam;
        this.value = 0L;
        this.changed = false;
    }

    public synchronized void set(long newValue) {
        this.value = newValue;
        this.changed = true;
    }

    public synchronized long get() {
        return this.value;
    }

    public synchronized void inc(long incr) {
        this.value += incr;
        this.changed = true;
    }

    public synchronized void inc() {
        ++this.value;
        this.changed = true;
    }

    public synchronized void dec(long decr) {
        this.value -= decr;
        if (this.value < 0L) {
            this.value = 0L;
        }
        this.changed = true;
    }

    public synchronized void dec() {
        --this.value;
        if (this.value < 0L) {
            this.value = 0L;
        }
        this.changed = true;
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        if (this.changed) {
            mr.setMetric(this.name, this.value);
        }
        this.changed = false;
    }
}

