/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.util.StringUtils;

public class MetricsTimeVaryingInt {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.metrics.util");
    private String name;
    private int currentValue;
    private int previousIntervalValue;

    public MetricsTimeVaryingInt(String nam) {
        this.name = nam;
        this.currentValue = 0;
        this.previousIntervalValue = 0;
    }

    public synchronized void inc(int incr) {
        this.currentValue += incr;
    }

    public synchronized void inc() {
        ++this.currentValue;
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalValue = this.currentValue;
        this.currentValue = 0;
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.name, this.getPreviousIntervalValue());
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.name + "\n" + StringUtils.stringifyException(e)));
        }
    }

    public synchronized int getPreviousIntervalValue() {
        return this.previousIntervalValue;
    }
}

