/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.util.StringUtils;

public class MetricsTimeVaryingRate {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.metrics.util");
    private String name;
    private Metrics currentData;
    private Metrics previousIntervalData;
    private MinMax minMax;

    public MetricsTimeVaryingRate(String n) {
        this.name = n;
        this.currentData = new Metrics();
        this.previousIntervalData = new Metrics();
        this.minMax = new MinMax();
    }

    public synchronized void inc(int numOps, long time) {
        this.currentData.numOperations += numOps;
        this.currentData.time += time;
        long timePerOps = time / (long)numOps;
        this.minMax.update(timePerOps);
    }

    public synchronized void inc(long time) {
        ++this.currentData.numOperations;
        this.currentData.time += time;
        this.minMax.update(time);
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalData.numOperations = this.currentData.numOperations;
        this.previousIntervalData.time = this.currentData.numOperations == 0 ? 0L : this.currentData.time / (long)this.currentData.numOperations;
        this.currentData.reset();
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.name + "_num_ops", this.getPreviousIntervalNumOps());
            mr.incrMetric(this.name + "_avg_time", this.getPreviousIntervalNumOps());
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.name + "\n" + StringUtils.stringifyException(e)));
        }
    }

    public synchronized int getPreviousIntervalNumOps() {
        return this.previousIntervalData.numOperations;
    }

    public synchronized long getPreviousIntervalAverageTime() {
        return this.previousIntervalData.time;
    }

    public synchronized long getMinTime() {
        return this.minMax.minTime;
    }

    public synchronized long getMaxTime() {
        return this.minMax.maxTime;
    }

    public synchronized void resetMinMax() {
        this.minMax.reset();
    }

    static class MinMax {
        long minTime = -1L;
        long maxTime = 0L;

        MinMax() {
        }

        void set(MinMax newVal) {
            this.minTime = newVal.minTime;
            this.maxTime = newVal.maxTime;
        }

        void reset() {
            this.minTime = -1L;
            this.maxTime = 0L;
        }

        void update(long time) {
            this.minTime = this.minTime == -1L ? time : Math.min(this.minTime, time);
            this.minTime = Math.min(this.minTime, time);
            this.maxTime = Math.max(this.maxTime, time);
        }
    }

    static class Metrics {
        int numOperations = 0;
        long time = 0L;

        Metrics() {
        }

        void set(Metrics resetTo) {
            this.numOperations = resetTo.numOperations;
            this.time = resetTo.time;
        }

        void reset() {
            this.numOperations = 0;
            this.time = 0L;
        }
    }
}

