/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetUtils {
    private static final Log LOG = LogFactory.getLog(NetUtils.class);
    private static Map<String, String> hostToResolved = new HashMap<String, String>();

    public static SocketFactory getSocketFactory(Configuration conf, Class<?> clazz) {
        SocketFactory factory = null;
        String propValue = conf.get("hadoop.rpc.socket.factory.class." + clazz.getSimpleName());
        if (propValue != null && propValue.length() > 0) {
            factory = NetUtils.getSocketFactoryFromProperty(conf, propValue);
        }
        if (factory == null) {
            factory = NetUtils.getDefaultSocketFactory(conf);
        }
        return factory;
    }

    public static SocketFactory getDefaultSocketFactory(Configuration conf) {
        String propValue = conf.get("hadoop.rpc.socket.factory.class.default");
        if (propValue == null || propValue.length() == 0) {
            return SocketFactory.getDefault();
        }
        return NetUtils.getSocketFactoryFromProperty(conf, propValue);
    }

    public static SocketFactory getSocketFactoryFromProperty(Configuration conf, String propValue) {
        try {
            Class<?> theClass = conf.getClassByName(propValue);
            return (SocketFactory)ReflectionUtils.newInstance(theClass, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Socket Factory class not found: " + cnfe);
        }
    }

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        String hostname;
        int colonIndex = target.indexOf(58);
        if (colonIndex < 0 && defaultPort == -1) {
            throw new RuntimeException("Not a host:port pair: " + target);
        }
        int port = -1;
        if (!target.contains("/")) {
            if (colonIndex == -1) {
                hostname = target;
            } else {
                hostname = target.substring(0, colonIndex);
                port = Integer.parseInt(target.substring(colonIndex + 1));
            }
        } else {
            URI addr = new Path(target).toUri();
            hostname = addr.getHost();
            port = addr.getPort();
        }
        if (port == -1) {
            port = defaultPort;
        }
        if (NetUtils.getStaticResolution(hostname) != null) {
            hostname = NetUtils.getStaticResolution(hostname);
        }
        return new InetSocketAddress(hostname, port);
    }

    @Deprecated
    public static String getServerAddress(Configuration conf, String oldBindAddressName, String oldPortName, String newBindAddressName) {
        String oldAddr = conf.get(oldBindAddressName);
        String oldPort = conf.get(oldPortName);
        String newAddrPort = conf.get(newBindAddressName);
        if (oldAddr == null && oldPort == null) {
            return newAddrPort;
        }
        String[] newAddrPortParts = newAddrPort.split(":", 2);
        if (newAddrPortParts.length != 2) {
            throw new IllegalArgumentException("Invalid address/port: " + newAddrPort);
        }
        if (oldAddr == null) {
            oldAddr = newAddrPortParts[0];
        } else {
            LOG.warn((Object)("Configuration parameter " + oldBindAddressName + " is deprecated. Use " + newBindAddressName + " instead."));
        }
        if (oldPort == null) {
            oldPort = newAddrPortParts[1];
        } else {
            LOG.warn((Object)("Configuration parameter " + oldPortName + " is deprecated. Use " + newBindAddressName + " instead."));
        }
        return oldAddr + ":" + oldPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticResolution(String host, String resolvedName) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            hostToResolved.put(host, resolvedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResolution(String host) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            return hostToResolved.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllStaticResolutions() {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            Set<Map.Entry<String, String>> entries = hostToResolved.entrySet();
            if (entries.size() == 0) {
                return null;
            }
            ArrayList<String[]> l = new ArrayList<String[]>(entries.size());
            for (Map.Entry<String, String> e : entries) {
                l.add(new String[]{e.getKey(), e.getValue()});
            }
            return l;
        }
    }

    public static InetSocketAddress getConnectAddress(Server server) {
        InetSocketAddress addr = server.getListenerAddress();
        if (addr.getAddress().getHostAddress().equals("0.0.0.0")) {
            addr = new InetSocketAddress("127.0.0.1", addr.getPort());
        }
        return addr;
    }

    public static InputStream getInputStream(Socket socket) throws IOException {
        return NetUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static InputStream getInputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getInputStream() : new SocketInputStream(socket, timeout);
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return NetUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getOutputStream() : new SocketOutputStream(socket, timeout);
    }
}

