/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptBasedMapping
implements Configurable,
DNSToSwitchMapping {
    private String scriptName;
    private Configuration conf;
    private int maxArgs;
    private Map<String, String> cache = new TreeMap<String, String>();
    private static Log LOG = LogFactory.getLog((String)"org.apache.hadoop.net.ScriptBasedMapping");

    @Override
    public void setConf(Configuration conf) {
        this.scriptName = conf.get("topology.script.file.name");
        this.maxArgs = conf.getInt("topology.script.number.args", 20);
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> resolve(List<String> names) {
        ArrayList<String> m = new ArrayList<String>(names.size());
        if (this.scriptName == null) {
            for (int i = 0; i < names.size(); ++i) {
                m.add("/default-rack");
            }
            return m;
        }
        ArrayList<String> hosts = new ArrayList<String>(names.size());
        for (String name : names) {
            if (this.cache.get(name = this.getHostName(name)) != null) continue;
            hosts.add(name);
        }
        int i = 0;
        String output = this.runResolveCommand(hosts);
        if (output != null) {
            StringTokenizer allSwitchInfo = new StringTokenizer(output);
            while (allSwitchInfo.hasMoreTokens()) {
                String switchInfo = allSwitchInfo.nextToken();
                this.cache.put((String)hosts.get(i++), switchInfo);
            }
        }
        for (String name : names) {
            if (this.cache.get(name = this.getHostName(name)) != null) {
                m.add(this.cache.get(name));
                continue;
            }
            return null;
        }
        return m;
    }

    private String runResolveCommand(List<String> args) {
        InetAddress ipaddr = null;
        int loopCount = 0;
        if (args.size() == 0) {
            return null;
        }
        StringBuffer allOutput = new StringBuffer();
        int numProcessed = 0;
        while (numProcessed != args.size()) {
            int start = this.maxArgs * loopCount;
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(this.scriptName);
            for (numProcessed = start; numProcessed < start + this.maxArgs && numProcessed < args.size(); ++numProcessed) {
                try {
                    ipaddr = InetAddress.getByName(args.get(numProcessed));
                }
                catch (UnknownHostException uh) {
                    return null;
                }
                cmdList.add(ipaddr.getHostAddress());
            }
            File dir = null;
            String userDir = System.getProperty("user.dir");
            if (userDir != null) {
                dir = new File(userDir);
            }
            Shell.ShellCommandExecutor s = new Shell.ShellCommandExecutor(cmdList.toArray(new String[0]), dir);
            try {
                s.execute();
                allOutput.append(s.getOutput() + " ");
            }
            catch (Exception e) {
                LOG.warn((Object)StringUtils.stringifyException(e));
                return null;
            }
            ++loopCount;
        }
        return allOutput.toString();
    }

    private String getHostName(String hostWithPort) {
        int j = hostWithPort.indexOf(58);
        if (j != -1) {
            hostWithPort = hostWithPort.substring(0, j);
        }
        return hostWithPort;
    }
}

