/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

abstract class SocketIOWithTimeout {
    static final Log LOG = LogFactory.getLog(SocketIOWithTimeout.class);
    private SelectableChannel channel;
    private long timeout;
    private boolean closed = false;
    private static SelectorPool selector = new SelectorPool();

    SocketIOWithTimeout(SelectableChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.channel = channel;
        this.timeout = timeout;
        channel.configureBlocking(false);
    }

    void close() {
        this.closed = true;
    }

    boolean isOpen() {
        return !this.closed && this.channel.isOpen();
    }

    SelectableChannel getChannel() {
        return this.channel;
    }

    static void checkChannelValidity(Object channel) throws IOException {
        if (channel == null) {
            throw new IOException("Channel is null. Check how the channel or socket is created.");
        }
        if (!(channel instanceof SelectableChannel)) {
            throw new IOException("Channel should be a SelectableChannel");
        }
    }

    abstract int performIO(ByteBuffer var1) throws IOException;

    int doIO(ByteBuffer buf, int ops) throws IOException {
        if (!buf.hasRemaining()) {
            throw new IllegalArgumentException("Buffer has no data left.");
        }
        while (buf.hasRemaining()) {
            if (this.closed) {
                return -1;
            }
            try {
                int n = this.performIO(buf);
                if (n != 0) {
                    return n;
                }
            }
            catch (IOException e) {
                if (!this.channel.isOpen()) {
                    this.closed = true;
                }
                throw e;
            }
            int count = 0;
            try {
                count = selector.select(this.channel, ops, this.timeout);
            }
            catch (IOException e) {
                this.closed = true;
                throw e;
            }
            if (count != 0) continue;
            throw new SocketTimeoutException(this.timeoutExceptionString(ops));
        }
        return 0;
    }

    void waitForIO(int ops) throws IOException {
        if (selector.select(this.channel, ops, this.timeout) == 0) {
            throw new SocketTimeoutException(this.timeoutExceptionString(ops));
        }
    }

    private String timeoutExceptionString(int ops) {
        String waitingFor = "" + ops;
        if (ops == 1) {
            waitingFor = "read";
        } else if (ops == 4) {
            waitingFor = "write";
        }
        return this.timeout + " millis timeout while " + "waiting for channel to be ready for " + waitingFor + ". ch : " + this.channel;
    }

    private static class SelectorPool {
        private static final long IDLE_TIMEOUT = 10000L;
        private ProviderInfo providerList = null;

        private SelectorPool() {
        }

        int select(SelectableChannel channel, int ops, long timeout) throws IOException {
            SelectorInfo info = this.get(channel);
            SelectionKey key = null;
            int ret = 0;
            try {
                do {
                    long start = timeout == 0L ? 0L : System.currentTimeMillis();
                    key = channel.register(info.selector, ops);
                    ret = info.selector.select(timeout);
                    if (ret != 0) {
                        int n = ret;
                        return n;
                    }
                    if (timeout <= 0L || (timeout -= System.currentTimeMillis() - start) > 0L) continue;
                    int n = 0;
                    return n;
                } while (!Thread.currentThread().isInterrupted());
                throw new InterruptedIOException("Interruped while waiting for IO on channel " + channel + ". " + timeout + " millis timeout left.");
            }
            finally {
                if (key != null) {
                    key.cancel();
                }
                try {
                    info.selector.selectNow();
                }
                catch (IOException e) {
                    LOG.info((Object)("Unexpected Exception while clearing selector : " + StringUtils.stringifyException(e)));
                    info.close();
                    return ret;
                }
                this.release(info);
            }
        }

        private synchronized SelectorInfo get(SelectableChannel channel) throws IOException {
            LinkedList<SelectorInfo> queue;
            SelectorInfo selInfo = null;
            SelectorProvider provider = channel.provider();
            ProviderInfo pList = this.providerList;
            while (pList != null && pList.provider != provider) {
                pList = pList.next;
            }
            if (pList == null) {
                pList = new ProviderInfo();
                pList.provider = provider;
                pList.queue = new LinkedList();
                pList.next = this.providerList;
                this.providerList = pList;
            }
            if ((queue = pList.queue).isEmpty()) {
                AbstractSelector selector = provider.openSelector();
                selInfo = new SelectorInfo();
                selInfo.selector = selector;
                selInfo.queue = queue;
            } else {
                selInfo = queue.removeLast();
            }
            this.trimIdleSelectors(System.currentTimeMillis());
            return selInfo;
        }

        private synchronized void release(SelectorInfo info) {
            long now = System.currentTimeMillis();
            this.trimIdleSelectors(now);
            info.lastActivityTime = now;
            info.queue.addLast(info);
        }

        private void trimIdleSelectors(long now) {
            long cutoff = now - 10000L;
            ProviderInfo pList = this.providerList;
            while (pList != null) {
                if (!pList.queue.isEmpty()) {
                    Iterator it = pList.queue.iterator();
                    while (it.hasNext()) {
                        SelectorInfo info = (SelectorInfo)it.next();
                        if (info.lastActivityTime > cutoff) break;
                        it.remove();
                        info.close();
                    }
                }
                pList = pList.next;
            }
        }

        private static class ProviderInfo {
            SelectorProvider provider;
            LinkedList<SelectorInfo> queue;
            ProviderInfo next;

            private ProviderInfo() {
            }
        }

        private static class SelectorInfo {
            Selector selector;
            long lastActivityTime;
            LinkedList<SelectorInfo> queue;

            private SelectorInfo() {
            }

            void close() {
                if (this.selector != null) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Unexpected exception while closing selector : " + StringUtils.stringifyException(e)));
                    }
                }
            }
        }
    }
}

