/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class GenericOptionsParser {
    private static final Log LOG = LogFactory.getLog(GenericOptionsParser.class);
    private CommandLine commandLine;

    public GenericOptionsParser(Configuration conf, String[] args) {
        this(conf, new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, Options options, String[] args) {
        this.parseGeneralOptions(options, conf, args);
    }

    public String[] getRemainingArgs() {
        return this.commandLine == null ? new String[]{} : this.commandLine.getArgs();
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    private Options buildGeneralOptions(Options opts) {
        OptionBuilder.withArgName((String)"local|namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a namenode");
        Option fs = OptionBuilder.create((String)"fs");
        OptionBuilder.withArgName((String)"local|jobtracker:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a job tracker");
        Option jt = OptionBuilder.create((String)"jt");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify an application configuration file");
        Option oconf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgPattern((String)"=", (int)1);
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((char)'D');
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated jar files to include in the classpath.");
        Option libjars = OptionBuilder.create((String)"libjars");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated files to be copied to the map reduce cluster");
        Option files = OptionBuilder.create((String)"files");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated archives to be unarchived on the compute machines.");
        Option archives = OptionBuilder.create((String)"archives");
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        opts.addOption(libjars);
        opts.addOption(files);
        opts.addOption(archives);
        return opts;
    }

    private void processGeneralOptions(Configuration conf, CommandLine line) {
        if (line.hasOption("fs")) {
            FileSystem.setDefaultUri(conf, line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            conf.set("mapred.job.tracker", line.getOptionValue("jt"));
        }
        if (line.hasOption("conf")) {
            conf.addResource(new Path(line.getOptionValue("conf")));
        }
        try {
            if (line.hasOption("libjars")) {
                conf.set("tmpjars", this.validateFiles(line.getOptionValue("libjars"), conf));
            }
            if (line.hasOption("files")) {
                conf.set("tmpfiles", this.validateFiles(line.getOptionValue("files"), conf));
            }
            if (line.hasOption("archives")) {
                conf.set("tmparchives", this.validateFiles(line.getOptionValue("archives"), conf));
            }
        }
        catch (IOException ioe) {
            System.err.println(StringUtils.stringifyException(ioe));
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (int i = 0; i < property.length - 1; i += 2) {
                if (property[i] == null) continue;
                conf.set(property[i], property[i + 1]);
            }
        }
    }

    private String validateFiles(String files, Configuration conf) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(",");
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            String tmp = fileArr[i];
            Path path = new Path(tmp);
            URI pathURI = path.toUri();
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            if (pathURI.getScheme() == null) {
                if (!localFs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(localFs).toString();
            } else {
                FileSystem fs = path.getFileSystem(conf);
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs).toString();
                try {
                    fs.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString(finalArr);
    }

    private String[] parseGeneralOptions(Options opts, Configuration conf, String[] args) {
        opts = this.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(opts, args, true);
            this.processGeneralOptions(conf, this.commandLine);
            return this.commandLine.getArgs();
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed: " + e.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return args;
        }
    }

    public static void printGenericCommandUsage(PrintStream out) {
        out.println("Generic options supported are");
        out.println("-conf <configuration file>     specify an application configuration file");
        out.println("-D <property=value>            use value for given property");
        out.println("-fs <local|namenode:port>      specify a namenod");
        out.println("-jt <local|jobtracker:port>    specify a job tracker");
        out.println("-files <comma separated list of fiels>    specify comma separated files to be copied to the map reduce cluster");
        out.println("-libjars <comma seperated list of jars>    specify comma separated jar files to include in the classpath.");
        out.println("-archives <comma separated list of archives>    specify comma separated archives to be unarchived on the compute machines.\n");
        out.println("The general command line syntax is");
        out.println("bin/hadoop command [genericOptions] [commandOptions]\n");
    }
}

