/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progressable;

public final class QuickSort
implements IndexedSorter {
    private void fix(IndexedSortable s, int p, int r) {
        if (s.compare(p, r) > 0) {
            s.swap(p, r);
        }
    }

    public void sort(IndexedSortable s, int p, int r) {
        this.sort(s, p, r, null);
    }

    public void sort(IndexedSortable s, int p, int r, Progressable rep) {
        if (null != rep) {
            rep.progress();
        }
        if (r - p < 13) {
            for (int i = p; i < r; ++i) {
                for (int j = i; j > p; --j) {
                    if (s.compare(j - 1, j) <= 0) continue;
                    s.swap(j, j - 1);
                }
            }
            return;
        }
        this.fix(s, p + r >>> 1, p);
        this.fix(s, p + r >>> 1, r - 1);
        this.fix(s, p, r - 1);
        int i = p;
        int j = r;
        int ll = p;
        int rr = r;
        while (true) {
            int cr;
            if (++i < j && (cr = s.compare(i, p)) <= 0) {
                if (0 != cr || ++ll == i) continue;
                s.swap(ll, i);
                continue;
            }
            while (--j > i && (cr = s.compare(p, j)) <= 0) {
                if (0 != cr || --rr == j) continue;
                s.swap(rr, j);
            }
            if (i >= j) break;
            s.swap(i, j);
        }
        j = i;
        while (ll >= p) {
            s.swap(ll--, --i);
        }
        while (rr < r) {
            s.swap(rr++, j++);
        }
        assert (i != j);
        if (i - p < r - j) {
            this.sort(s, p, i, rep);
            this.sort(s, j, r, rep);
        } else {
            this.sort(s, j, r, rep);
            this.sort(s, p, i, rep);
        }
    }
}

