/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Random;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HftpFileSystem
extends FileSystem {
    protected InetSocketAddress nnAddr;
    protected UserGroupInformation ugi;
    protected final Random ran = new Random();
    protected static final SimpleDateFormat df;

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            this.ugi = UnixUserGroupInformation.login(conf, true);
        }
        catch (LoginException le) {
            throw new IOException(StringUtils.stringifyException(le));
        }
        this.nnAddr = NetUtils.createSocketAddr(name.toString());
    }

    protected String pickOneAddress(String hostname) throws UnknownHostException {
        if ("localhost".equals(hostname)) {
            return hostname;
        }
        InetAddress[] addrs = InetAddress.getAllByName(hostname);
        if (addrs.length > 1) {
            return addrs[this.ran.nextInt(addrs.length)].getHostAddress();
        }
        return addrs[0].getHostAddress();
    }

    @Override
    public URI getUri() {
        try {
            return new URI("hftp", null, this.pickOneAddress(this.nnAddr.getHostName()), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        try {
            URL url = new URI("http", null, this.pickOneAddress(this.nnAddr.getHostName()), this.nnAddr.getPort(), path, query, null).toURL();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("url=" + url));
            }
            return (HttpURLConnection)url.openConnection();
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        HttpURLConnection connection = null;
        connection = this.openConnection("/data" + f.toUri().getPath(), "ugi=" + this.ugi);
        connection.setRequestMethod("GET");
        connection.connect();
        final InputStream in = connection.getInputStream();
        return new FSDataInputStream(new FSInputStream(){

            @Override
            public int read() throws IOException {
                return in.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return in.read(b, off, len);
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            @Override
            public void seek(long pos) throws IOException {
                throw new IOException("Can't seek!");
            }

            @Override
            public long getPos() throws IOException {
                throw new IOException("Position unknown!");
            }

            @Override
            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }
        });
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        return new ChecksumParser().getFileChecksum(f);
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this);
    }

    @Override
    public void setWorkingDirectory(Path f) {
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    @Deprecated
    public boolean delete(Path f) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        df = ListPathsServlet.df;
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf(attrs);
        }

        private FileChecksum getFileChecksum(Path f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + f, "ugi=" + HftpFileSystem.this.ugi);
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                connection.setRequestMethod("GET");
                connection.connect();
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                modif = df.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = df.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")), false, Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")), modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this)) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + path, "ugi=" + HftpFileSystem.this.ugi + (recur ? "&recursive=yes" : ""));
                connection.setRequestMethod("GET");
                connection.connect();
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDir())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }
}

