/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;

public final class QuotaExceededException
extends IOException {
    private static final long serialVersionUID = 1L;
    private String pathName;
    private long nsQuota;
    private long nsCount;
    private long dsQuota;
    private long diskspace;

    public QuotaExceededException(String msg) {
        super(msg);
    }

    public QuotaExceededException(long nsQuota, long nsCount, long dsQuota, long diskspace) {
        this.nsQuota = nsQuota;
        this.nsCount = nsCount;
        this.dsQuota = dsQuota;
        this.diskspace = diskspace;
    }

    public void setPathName(String path) {
        this.pathName = path;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            return "The quota" + (this.pathName == null ? "" : " of " + this.pathName) + " is exceeded: namespace quota=" + this.nsQuota + " file count=" + this.nsCount + ", diskspace quota=" + this.dsQuota + " diskspace=" + this.diskspace;
        }
        return msg;
    }
}

