/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class FSEditLog {
    private static final byte OP_INVALID = -1;
    private static final byte OP_ADD = 0;
    private static final byte OP_RENAME = 1;
    private static final byte OP_DELETE = 2;
    private static final byte OP_MKDIR = 3;
    private static final byte OP_SET_REPLICATION = 4;
    @Deprecated
    private static final byte OP_DATANODE_ADD = 5;
    @Deprecated
    private static final byte OP_DATANODE_REMOVE = 6;
    private static final byte OP_SET_PERMISSIONS = 7;
    private static final byte OP_SET_OWNER = 8;
    private static final byte OP_CLOSE = 9;
    private static final byte OP_SET_GENSTAMP = 10;
    private static final byte OP_SET_NS_QUOTA = 11;
    private static final byte OP_CLEAR_NS_QUOTA = 12;
    private static final byte OP_TIMES = 13;
    private static final byte OP_SET_QUOTA = 14;
    private static int sizeFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private boolean isSyncRunning;
    private long numTransactions;
    private long numTransactionsBatchedInSync;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };
    private static final LongWritable longWritable = new LongWritable();

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = FSNamesystem.now();
    }

    private File getEditFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditFile(sd);
    }

    private File getEditNewFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditNewFile(sd);
    }

    private int getNumStorageDirs() {
        int numStorageDirs = 0;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            ++numStorageDirs;
            it.next();
        }
        return numStorageDirs;
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    boolean isOpen() {
        return this.getNumEditStreams() > 0;
    }

    public synchronized void open() throws IOException {
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        if (this.editStreams == null) {
            this.editStreams = new ArrayList();
        }
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File eFile = this.getEditFile(sd);
            try {
                EditLogFileOutputStream eStream = new EditLogFileOutputStream(eFile);
                this.editStreams.add(eStream);
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Unable to open edit log file " + eFile));
                it.remove();
            }
        }
    }

    public synchronized void createEditLogFile(File name) throws IOException {
        EditLogFileOutputStream eStream = new EditLogFileOutputStream(name);
        ((EditLogOutputStream)eStream).create();
        ((EditLogOutputStream)eStream).close();
    }

    synchronized void createNewIfMissing() throws IOException {
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            File newFile = this.getEditNewFile(it.next());
            if (newFile.exists()) continue;
            this.createEditLogFile(newFile);
        }
    }

    public synchronized void close() throws IOException {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.editStreams == null) {
            return;
        }
        this.printStatistics(true);
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.setReadyToFlush();
                eStream.flush();
                eStream.close();
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
        this.editStreams.clear();
    }

    synchronized void processIOError(int index) {
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal((Object)"Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        assert (index < this.getNumStorageDirs());
        assert (this.getNumStorageDirs() == this.editStreams.size());
        File parentStorageDir = ((EditLogFileOutputStream)this.editStreams.get(index)).getFile().getParentFile().getParentFile();
        this.editStreams.remove(index);
        this.fsimage.processIOError(parentStorageDir);
    }

    synchronized void processIOError(Storage.StorageDirectory sd) {
        if (!sd.getStorageDirType().isOfType(FSImage.NameNodeDirType.EDITS)) {
            return;
        }
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal((Object)"Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            File parentStorageDir = ((EditLogFileOutputStream)this.editStreams.get(idx)).getFile().getParentFile().getParentFile();
            if (!parentStorageDir.getName().equals(sd.getRoot().getName())) continue;
            this.editStreams.remove(idx);
        }
    }

    private void processIOError(ArrayList<EditLogOutputStream> errorStreams) {
        if (errorStreams == null) {
            return;
        }
        for (int idx = 0; idx < errorStreams.size(); ++idx) {
            EditLogOutputStream eStream = errorStreams.get(idx);
            int j = 0;
            int numEditStreams = this.editStreams.size();
            for (j = 0; j < numEditStreams && this.editStreams.get(j) != eStream; ++j) {
            }
            if (j == numEditStreams) {
                FSNamesystem.LOG.error((Object)"Unable to find sync log on which  IO error occured. Fatal Error.");
                Runtime.getRuntime().exit(-1);
            }
            this.processIOError(j);
        }
        this.fsimage.incrementCheckpointTime();
    }

    boolean existsNew() throws IOException {
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            if (!this.getEditNewFile(it.next()).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int loadFSEdits(EditLogInputStream edits) throws IOException {
        long startTime;
        int numOpOther;
        int numOpTimes;
        int numOpSetGenStamp;
        int numOpSetOwner;
        int numOpSetPerm;
        int numOpMkDir;
        int numOpSetRepl;
        int numOpRename;
        int numOpDelete;
        int numOpClose;
        int numOpAdd;
        int logVersion;
        int numEdits;
        block54: {
            FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
            FSDirectory fsDir = fsNamesys.dir;
            numEdits = 0;
            logVersion = 0;
            String clientName = null;
            String clientMachine = null;
            String path = null;
            numOpAdd = 0;
            numOpClose = 0;
            numOpDelete = 0;
            numOpRename = 0;
            numOpSetRepl = 0;
            numOpMkDir = 0;
            numOpSetPerm = 0;
            numOpSetOwner = 0;
            numOpSetGenStamp = 0;
            numOpTimes = 0;
            numOpOther = 0;
            startTime = FSNamesystem.now();
            DataInputStream in = new DataInputStream(new BufferedInputStream(edits));
            try {
                int opcode;
                in.mark(4);
                boolean available = true;
                try {
                    logVersion = in.readByte();
                }
                catch (EOFException e) {
                    available = false;
                }
                if (available) {
                    in.reset();
                    logVersion = in.readInt();
                    if (logVersion < -18) {
                        throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + -18 + ".");
                    }
                }
                assert (logVersion <= -7) : "Unsupported version " + logVersion;
                block23: while (true) {
                    long timestamp = 0L;
                    long mtime = 0L;
                    long atime = 0L;
                    long blockSize = 0L;
                    opcode = -1;
                    try {
                        opcode = in.readByte();
                        if (opcode == -1) {
                            FSNamesystem.LOG.info((Object)("Invalid opcode, reached end of edit log Number of transactions found " + numEdits));
                        }
                    }
                    catch (EOFException e) {}
                    break block54;
                    ++numEdits;
                    switch (opcode) {
                        case 0: 
                        case 9: {
                            int length = in.readInt();
                            if (-7 == logVersion && length != 3 || -17 < logVersion && logVersion < -7 && length != 4 || logVersion <= -17 && length != 5) {
                                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + length + ". ");
                            }
                            path = FSImage.readString(in);
                            short replication = FSEditLog.adjustReplication(FSEditLog.readShort(in));
                            mtime = FSEditLog.readLong(in);
                            if (logVersion <= -17) {
                                atime = FSEditLog.readLong(in);
                            }
                            if (logVersion < -7) {
                                blockSize = FSEditLog.readLong(in);
                            }
                            Block[] blocks = null;
                            if (logVersion <= -14) {
                                blocks = FSEditLog.readBlocks(in);
                            } else {
                                BlockTwo oldblk = new BlockTwo();
                                int num = in.readInt();
                                blocks = new Block[num];
                                for (int i = 0; i < num; ++i) {
                                    oldblk.readFields(in);
                                    blocks[i] = new Block(oldblk.blkid, oldblk.len, 0L);
                                }
                            }
                            if (-8 <= logVersion && blockSize == 0L) {
                                if (blocks.length > 1) {
                                    blockSize = blocks[0].getNumBytes();
                                } else {
                                    long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                    blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                                }
                            }
                            PermissionStatus permissions = fsNamesys.getUpgradePermission();
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read(in);
                            }
                            if (opcode == 0 && logVersion <= -12) {
                                clientName = FSImage.readString(in);
                                clientMachine = FSImage.readString(in);
                                if (-13 <= logVersion) {
                                    FSEditLog.readDatanodeDescriptorArray(in);
                                }
                            } else {
                                clientName = "";
                                clientMachine = "";
                            }
                            if (FSNamesystem.LOG.isDebugEnabled()) {
                                FSNamesystem.LOG.debug((Object)(opcode + ": " + path + " numblocks : " + blocks.length + " clientHolder " + clientName + " clientMachine " + clientMachine));
                            }
                            fsDir.unprotectedDelete(path, mtime);
                            INodeFile node = (INodeFile)fsDir.unprotectedAddFile(path, permissions, blocks, replication, mtime, atime, blockSize);
                            if (opcode != 0) continue block23;
                            ++numOpAdd;
                            INodeFileUnderConstruction cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), clientName, clientMachine, null);
                            fsDir.replaceNode(path, node, cons);
                            fsNamesys.leaseManager.addLease(cons.clientName, path);
                            continue block23;
                        }
                        case 4: {
                            ++numOpSetRepl;
                            path = FSImage.readString(in);
                            short replication = FSEditLog.adjustReplication(FSEditLog.readShort(in));
                            fsDir.unprotectedSetReplication(path, replication, null);
                            continue block23;
                        }
                        case 1: {
                            ++numOpRename;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String s = FSImage.readString(in);
                            String d = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            FileStatus dinfo = fsDir.getFileInfo(d);
                            fsDir.unprotectedRenameTo(s, d, timestamp);
                            fsNamesys.changeLease(s, d, dinfo);
                            continue block23;
                        }
                        case 2: {
                            ++numOpDelete;
                            int length = in.readInt();
                            if (length != 2) {
                                throw new IOException("Incorrect data format. delete operation.");
                            }
                            path = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            fsDir.unprotectedDelete(path, timestamp);
                            continue block23;
                        }
                        case 3: {
                            ++numOpMkDir;
                            PermissionStatus permissions = fsNamesys.getUpgradePermission();
                            int length = in.readInt();
                            if (-17 < logVersion && length != 2 || logVersion <= -17 && length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            path = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            if (logVersion <= -17) {
                                atime = FSEditLog.readLong(in);
                            }
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read(in);
                            }
                            fsDir.unprotectedMkdir(path, permissions, timestamp);
                            continue block23;
                        }
                        case 10: {
                            ++numOpSetGenStamp;
                            long lw = in.readLong();
                            fsDir.namesystem.setGenerationStamp(lw);
                            continue block23;
                        }
                        case 5: {
                            ++numOpOther;
                            FSImage.DatanodeImage nodeimage = new FSImage.DatanodeImage();
                            nodeimage.readFields(in);
                            continue block23;
                        }
                        case 6: {
                            ++numOpOther;
                            DatanodeID nodeID = new DatanodeID();
                            nodeID.readFields(in);
                            continue block23;
                        }
                        case 7: {
                            ++numOpSetPerm;
                            if (logVersion > -11) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetPermission(FSImage.readString(in), FsPermission.read(in));
                            continue block23;
                        }
                        case 8: {
                            ++numOpSetOwner;
                            if (logVersion > -11) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetOwner(FSImage.readString(in), FSImage.readString_EmptyAsNull(in), FSImage.readString_EmptyAsNull(in));
                            continue block23;
                        }
                        case 11: {
                            if (logVersion > -16) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetQuota(FSImage.readString(in), FSEditLog.readLongWritable(in), Long.MAX_VALUE);
                            continue block23;
                        }
                        case 12: {
                            if (logVersion > -16) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetQuota(FSImage.readString(in), -1L, Long.MAX_VALUE);
                            continue block23;
                        }
                        case 14: {
                            fsDir.unprotectedSetQuota(FSImage.readString(in), FSEditLog.readLongWritable(in), FSEditLog.readLongWritable(in));
                            continue block23;
                        }
                        case 13: {
                            ++numOpTimes;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. times operation.");
                            }
                            path = FSImage.readString(in);
                            mtime = FSEditLog.readLong(in);
                            atime = FSEditLog.readLong(in);
                            fsDir.unprotectedSetTimes(path, mtime, atime, true);
                            continue block23;
                        }
                    }
                    break;
                }
                throw new IOException("Never seen opcode " + opcode);
            }
            finally {
                in.close();
            }
        }
        FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        if (FSImage.LOG.isDebugEnabled()) {
            FSImage.LOG.debug((Object)("numOpAdd = " + numOpAdd + " numOpClose = " + numOpClose + " numOpDelete = " + numOpDelete + " numOpRename = " + numOpRename + " numOpSetRepl = " + numOpSetRepl + " numOpMkDir = " + numOpMkDir + " numOpSetPerm = " + numOpSetPerm + " numOpSetOwner = " + numOpSetOwner + " numOpSetGenStamp = " + numOpSetGenStamp + " numOpTimes = " + numOpTimes + " numOpOther = " + numOpOther));
        }
        if (logVersion != -18) {
            ++numEdits;
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readLongWritable(DataInputStream in) throws IOException {
        LongWritable longWritable = FSEditLog.longWritable;
        synchronized (longWritable) {
            FSEditLog.longWritable.readFields(in);
            return FSEditLog.longWritable.get();
        }
    }

    static short adjustReplication(short replication) {
        short maxReplication;
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        short minReplication = fsNamesys.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = fsNamesys.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    synchronized void logEdit(byte op, Writable ... writables) {
        assert (this.getNumEditStreams() > 0) : "no editlog streams";
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.write(op, writables);
                continue;
            }
            catch (IOException ie) {
                this.processIOError(idx);
                --idx;
            }
        }
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = FSNamesystem.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        if (this.metrics != null) {
            this.metrics.transactions.inc(end - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSync() throws IOException {
        int numEditStreams;
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        long mytxid = FSEditLog.myTransactionId.get().txid;
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            numEditStreams = this.editStreams.size();
            assert (numEditStreams > 0) : "no editlog streams";
            this.printStatistics(false);
            while (mytxid > this.synctxid && this.isSyncRunning) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (mytxid <= this.synctxid) {
                ++this.numTransactionsBatchedInSync;
                if (this.metrics != null) {
                    this.metrics.transactionsBatchedInSync.inc();
                }
                return;
            }
            syncStart = this.txid;
            this.isSyncRunning = true;
            for (int idx = 0; idx < numEditStreams; ++idx) {
                this.editStreams.get(idx).setReadyToFlush();
            }
        }
        long start = FSNamesystem.now();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flush();
                continue;
            }
            catch (IOException ie) {
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
                FSNamesystem.LOG.error((Object)"Unable to sync edit log. Fatal Error.");
            }
        }
        long elapsed = FSNamesystem.now() - start;
        FSEditLog fSEditLog2 = this;
        synchronized (fSEditLog2) {
            this.processIOError(errorStreams);
            this.synctxid = syncStart;
            this.isSyncRunning = false;
            this.notifyAll();
        }
        if (this.metrics != null) {
            this.metrics.syncs.inc(elapsed);
        }
    }

    private void printStatistics(boolean force) {
        long now = FSNamesystem.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null) {
            return;
        }
        this.lastPrintTime = now;
        StringBuilder buf = new StringBuilder();
        buf.append("Number of transactions: ");
        buf.append(this.numTransactions);
        buf.append(" Total time for transactions(ms): ");
        buf.append(this.totalTimeTransactions);
        buf.append("Number of transactions batched in Syncs: ");
        buf.append(this.numTransactionsBatchedInSync);
        buf.append(" Number of syncs: ");
        buf.append(this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        int numEditStreams = this.editStreams.size();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        FSNamesystem.LOG.info((Object)buf);
    }

    public void logOpenFile(String path, INodeFileUnderConstruction newNode) throws IOException {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)0, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus(), new UTF8(newNode.getClientName()), new UTF8(newNode.getClientMachine()));
    }

    public void logCloseFile(String path, INodeFile newNode) {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)9, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus());
    }

    public void logMkDir(String path, INode newNode) {
        Writable[] info = new UTF8[]{new UTF8(path), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime())};
        this.logEdit((byte)3, new ArrayWritable(UTF8.class, info), newNode.getPermissionStatus());
    }

    void logRename(String src, String dst, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), new UTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)1, new ArrayWritable(UTF8.class, info));
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new UTF8(src), FSEditLog.toLogReplication(replication));
    }

    void logSetQuota(String src, long nsQuota, long dsQuota) {
        this.logEdit((byte)14, new UTF8(src), new LongWritable(nsQuota), new LongWritable(dsQuota));
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new UTF8(src), permissions);
    }

    void logSetOwner(String src, String username, String groupname) {
        UTF8 u = new UTF8(username == null ? "" : username);
        UTF8 g = new UTF8(groupname == null ? "" : groupname);
        this.logEdit((byte)8, new UTF8(src), u, g);
    }

    void logDelete(String src, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)2, new ArrayWritable(UTF8.class, info));
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new LongWritable(genstamp));
    }

    void logTimes(String src, long mtime, long atime) {
        Writable[] info = new UTF8[]{new UTF8(src), FSEditLog.toLogLong(mtime), FSEditLog.toLogLong(atime)};
        this.logEdit((byte)13, new ArrayWritable(UTF8.class, info));
    }

    private static UTF8 toLogReplication(short replication) {
        return new UTF8(Short.toString(replication));
    }

    private static UTF8 toLogLong(long timestamp) {
        return new UTF8(Long.toString(timestamp));
    }

    synchronized long getEditLogSize() throws IOException {
        assert (this.getNumStorageDirs() == this.editStreams.size());
        long size = 0L;
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            long curSize = this.editStreams.get(idx).length();
            assert (size == 0L || size == curSize) : "All streams must be the same";
            size = curSize;
        }
        return size;
    }

    synchronized void rollEditLog() throws IOException {
        if (this.existsNew()) {
            Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
            while (it.hasNext()) {
                File editsNew = this.getEditNewFile(it.next());
                if (editsNew.exists()) continue;
                throw new IOException("Inconsistent existance of edits.new " + editsNew);
            }
            return;
        }
        this.close();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                EditLogFileOutputStream eStream = new EditLogFileOutputStream(this.getEditNewFile(sd));
                eStream.create();
                this.editStreams.add(eStream);
            }
            catch (IOException e) {
                this.processIOError(sd);
                it.remove();
            }
        }
    }

    synchronized void purgeEditLog() throws IOException {
        if (!this.existsNew()) {
            throw new IOException("Attempt to purge edit log but edits.new does not exist.");
        }
        this.close();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (this.getEditNewFile(sd).renameTo(this.getEditFile(sd))) continue;
            this.getEditFile(sd).delete();
            if (this.getEditNewFile(sd).renameTo(this.getEditFile(sd))) continue;
            it.remove();
        }
        this.open();
    }

    synchronized File getFsEditName() throws IOException {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            sd = it.next();
        }
        return this.getEditFile(sd);
    }

    synchronized long getFsEditTime() {
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (it.hasNext()) {
            return this.getEditFile(it.next()).lastModified();
        }
        return 0L;
    }

    static void setBufferCapacity(int size) {
        sizeFlushBuffer = size;
    }

    private static DatanodeDescriptor[] readDatanodeDescriptorArray(DataInput in) throws IOException {
        DatanodeDescriptor[] locations = new DatanodeDescriptor[in.readInt()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFieldsFromFSEditLog(in);
        }
        return locations;
    }

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImage.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImage.readString(in));
    }

    private static Block[] readBlocks(DataInputStream in) throws IOException {
        int numBlocks = in.readInt();
        Block[] blocks = new Block[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new Block();
            blocks[i].readFields(in);
        }
        return blocks;
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, new WritableFactory(){

                @Override
                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    static class EditLogFileInputStream
    extends EditLogInputStream {
        private File file;
        private FileInputStream fStream;

        EditLogFileInputStream(File name) throws IOException {
            this.file = name;
            this.fStream = new FileInputStream(name);
        }

        @Override
        String getName() {
            return this.file.getPath();
        }

        @Override
        public int available() throws IOException {
            return this.fStream.available();
        }

        @Override
        public int read() throws IOException {
            return this.fStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.fStream.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.fStream.close();
        }

        @Override
        long length() throws IOException {
            return this.file.length();
        }
    }

    private static class EditLogFileOutputStream
    extends EditLogOutputStream {
        private File file;
        private FileOutputStream fp;
        private FileChannel fc;
        private DataOutputBuffer bufCurrent;
        private DataOutputBuffer bufReady;
        static ByteBuffer fill = ByteBuffer.allocateDirect(512);

        EditLogFileOutputStream(File name) throws IOException {
            this.file = name;
            this.bufCurrent = new DataOutputBuffer(sizeFlushBuffer);
            this.bufReady = new DataOutputBuffer(sizeFlushBuffer);
            RandomAccessFile rp = new RandomAccessFile(name, "rw");
            this.fp = new FileOutputStream(rp.getFD());
            this.fc = rp.getChannel();
            this.fc.position(this.fc.size());
        }

        @Override
        String getName() {
            return this.file.getPath();
        }

        @Override
        public void write(int b) throws IOException {
            this.bufCurrent.write(b);
        }

        @Override
        void write(byte op, Writable ... writables) throws IOException {
            this.write(op);
            for (Writable w : writables) {
                w.write(this.bufCurrent);
            }
        }

        @Override
        void create() throws IOException {
            this.fc.truncate(0L);
            this.fc.position(0L);
            this.bufCurrent.writeInt(-18);
            this.setReadyToFlush();
            this.flush();
        }

        @Override
        public void close() throws IOException {
            int bufSize = this.bufCurrent.size();
            if (bufSize != 0) {
                throw new IOException("FSEditStream has " + bufSize + " bytes still to be flushed and cannot " + "be closed.");
            }
            this.bufCurrent.close();
            this.bufReady.close();
            this.fc.truncate(this.fc.position());
            this.fp.close();
            this.bufReady = null;
            this.bufCurrent = null;
        }

        @Override
        void setReadyToFlush() throws IOException {
            assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
            this.write(-1);
            DataOutputBuffer tmp = this.bufReady;
            this.bufReady = this.bufCurrent;
            this.bufCurrent = tmp;
        }

        @Override
        protected void flushAndSync() throws IOException {
            this.preallocate();
            this.bufReady.writeTo(this.fp);
            this.bufReady.reset();
            this.fc.force(false);
            this.fc.position(this.fc.position() - 1L);
        }

        @Override
        long length() throws IOException {
            return this.fc.size() + (long)this.bufReady.size() + (long)this.bufCurrent.size();
        }

        private void preallocate() throws IOException {
            long position = this.fc.position();
            if (position + 4096L >= this.fc.size()) {
                FSNamesystem.LOG.debug((Object)("Preallocating Edit log, current size " + this.fc.size()));
                long newsize = position + 0x100000L;
                fill.position(0);
                int written = this.fc.write(fill, newsize);
                FSNamesystem.LOG.debug((Object)("Edit log size is now " + this.fc.size() + " written " + written + " bytes " + " at offset " + newsize));
            }
        }

        File getFile() {
            return this.file;
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }
}

