/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.znerd.xmlenc.XMLOutputter;

public class ListPathsServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    static void writeInfo(FileStatus i, XMLOutputter doc) throws IOException {
        doc.startTag(i.isDir() ? "directory" : "file");
        doc.attribute("path", i.getPath().toUri().getPath());
        doc.attribute("modified", df.format(new Date(i.getModificationTime())));
        doc.attribute("accesstime", df.format(new Date(i.getAccessTime())));
        if (!i.isDir()) {
            doc.attribute("size", String.valueOf(i.getLen()));
            doc.attribute("replication", String.valueOf(i.getReplication()));
            doc.attribute("blocksize", String.valueOf(i.getBlockSize()));
        }
        doc.attribute("permission", (i.isDir() ? "d" : "-") + i.getPermission());
        doc.attribute("owner", i.getOwner());
        doc.attribute("group", i.getGroup());
        doc.endTag();
    }

    protected Map<String, String> buildRoot(HttpServletRequest request, XMLOutputter doc) {
        String path = request.getPathInfo() != null ? request.getPathInfo() : "/";
        String exclude = request.getParameter("exclude") != null ? request.getParameter("exclude") : "\\..*\\.crc";
        String filter = request.getParameter("filter") != null ? request.getParameter("filter") : ".*";
        boolean recur = request.getParameter("recursive") != null && "yes".equals(request.getParameter("recursive"));
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("path", path);
        root.put("recursive", recur ? "yes" : "no");
        root.put("filter", filter);
        root.put("exclude", exclude);
        root.put("time", df.format(new Date()));
        root.put("version", VersionInfo.getVersion());
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UnixUserGroupInformation ugi = this.getUGI(request);
        PrintWriter out = response.getWriter();
        XMLOutputter doc = new XMLOutputter((Writer)out, "UTF-8");
        try {
            Map<String, String> root = this.buildRoot(request, doc);
            String path = root.get("path");
            boolean recur = "yes".equals(root.get("recursive"));
            Pattern filter = Pattern.compile(root.get("filter"));
            Pattern exclude = Pattern.compile(root.get("exclude"));
            ClientProtocol nnproxy = this.createNameNodeProxy(ugi);
            doc.declaration();
            doc.startTag("listing");
            for (Map.Entry<String, String> m : root.entrySet()) {
                doc.attribute(m.getKey(), m.getValue());
            }
            FileStatus base = nnproxy.getFileInfo(path);
            if (base != null && base.isDir()) {
                ListPathsServlet.writeInfo(base, doc);
            }
            Stack<String> pathstack = new Stack<String>();
            pathstack.push(path);
            while (!pathstack.empty()) {
                String p = (String)pathstack.pop();
                try {
                    for (FileStatus i : nnproxy.getListing(p)) {
                        if (exclude.matcher(i.getPath().getName()).matches() || !filter.matcher(i.getPath().getName()).matches()) continue;
                        if (recur && i.isDir()) {
                            pathstack.push(i.getPath().toUri().getPath());
                        }
                        ListPathsServlet.writeInfo(i, doc);
                    }
                }
                catch (RemoteException re) {
                    re.writeXml(p, doc);
                }
            }
        }
        catch (PatternSyntaxException e) {
            out.println(e.toString());
        }
        finally {
            if (doc != null) {
                doc.endDocument();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

