/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class FSNamesystemMetrics
implements Updater {
    private static Log log = LogFactory.getLog(FSNamesystemMetrics.class);
    private final MetricsRecord metricsRecord;
    public MetricsRegistry registry = new MetricsRegistry();
    public MetricsIntValue filesTotal = new MetricsIntValue("FilesTotal", this.registry);
    public MetricsLongValue blocksTotal = new MetricsLongValue("BlocksTotal", this.registry);
    public MetricsIntValue capacityTotalGB = new MetricsIntValue("CapacityTotalGB", this.registry);
    public MetricsIntValue capacityUsedGB = new MetricsIntValue("CapacityUsedGB", this.registry);
    public MetricsIntValue capacityRemainingGB = new MetricsIntValue("CapacityRemainingGB", this.registry);
    public MetricsIntValue totalLoad = new MetricsIntValue("TotalLoad", this.registry);
    public MetricsIntValue pendingReplicationBlocks = new MetricsIntValue("PendingReplicationBlocks", this.registry);
    public MetricsIntValue underReplicatedBlocks = new MetricsIntValue("UnderReplicatedBlocks", this.registry);
    public MetricsIntValue scheduledReplicationBlocks = new MetricsIntValue("ScheduledReplicationBlocks", this.registry);
    public MetricsIntValue missingBlocks = new MetricsIntValue("MissingBlocks", this.registry);

    public FSNamesystemMetrics(Configuration conf) {
        String sessionId = conf.get("session.id");
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(metricsContext, "FSNamesystem");
        this.metricsRecord.setTag("sessionId", sessionId);
        metricsContext.registerUpdater(this);
        log.info((Object)("Initializing FSNamesystemMetrics using context object:" + metricsContext.getClass().getName()));
    }

    private int roundBytesToGBytes(long bytes) {
        return Math.round((float)bytes / 1.0737418E9f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        FSNamesystemMetrics fSNamesystemMetrics = this;
        synchronized (fSNamesystemMetrics) {
            FSNamesystem fsNameSystem = FSNamesystem.getFSNamesystem();
            this.filesTotal.set((int)fsNameSystem.getFilesTotal());
            this.blocksTotal.set((int)fsNameSystem.getBlocksTotal());
            this.capacityTotalGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityTotal()));
            this.capacityUsedGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityUsed()));
            this.capacityRemainingGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityRemaining()));
            this.totalLoad.set(fsNameSystem.getTotalLoad());
            this.pendingReplicationBlocks.set((int)fsNameSystem.getPendingReplicationBlocks());
            this.underReplicatedBlocks.set((int)fsNameSystem.getUnderReplicatedBlocks());
            this.scheduledReplicationBlocks.set((int)fsNameSystem.getScheduledReplicationBlocks());
            this.missingBlocks.set((int)fsNameSystem.getMissingBlocksCount());
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }
}

