/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeActivtyMBean;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class NameNodeMetrics
implements Updater {
    private static Log log = LogFactory.getLog(NameNodeMetrics.class);
    private final MetricsRecord metricsRecord;
    public MetricsRegistry registry = new MetricsRegistry();
    private NameNodeActivtyMBean namenodeActivityMBean;
    public MetricsTimeVaryingInt numFilesCreated = new MetricsTimeVaryingInt("FilesCreated", this.registry);
    public MetricsTimeVaryingInt numFilesAppended = new MetricsTimeVaryingInt("FilesAppended", this.registry);
    public MetricsTimeVaryingInt numGetBlockLocations = new MetricsTimeVaryingInt("GetBlockLocations", this.registry);
    public MetricsTimeVaryingInt numFilesRenamed = new MetricsTimeVaryingInt("FilesRenamed", this.registry);
    public MetricsTimeVaryingInt numGetListingOps = new MetricsTimeVaryingInt("GetListingOps", this.registry);
    public MetricsTimeVaryingInt numCreateFileOps = new MetricsTimeVaryingInt("CreateFileOps", this.registry);
    public MetricsTimeVaryingInt numDeleteFileOps = new MetricsTimeVaryingInt("DeleteFileOps", this.registry);
    public MetricsTimeVaryingInt numAddBlockOps = new MetricsTimeVaryingInt("AddBlockOps", this.registry);
    public MetricsTimeVaryingRate transactions = new MetricsTimeVaryingRate("Transactions", this.registry, "Journal Transaction");
    public MetricsTimeVaryingRate syncs = new MetricsTimeVaryingRate("Syncs", this.registry, "Journal Sync");
    public MetricsTimeVaryingInt transactionsBatchedInSync = new MetricsTimeVaryingInt("JournalTransactionsBatchedInSync", this.registry, "Journal Transactions Batched In Sync");
    public MetricsTimeVaryingRate blockReport = new MetricsTimeVaryingRate("blockReport", this.registry, "Block Report");
    public MetricsIntValue safeModeTime = new MetricsIntValue("SafemodeTime", this.registry, "Duration in SafeMode at Startup");
    public MetricsIntValue fsImageLoadTime = new MetricsIntValue("fsImageLoadTime", this.registry, "Time loading FS Image at Startup");
    public MetricsIntValue numBlocksCorrupted = new MetricsIntValue("BlocksCorrupted", this.registry);

    public NameNodeMetrics(Configuration conf, NameNode nameNode) {
        String sessionId = conf.get("session.id");
        JvmMetrics.init("NameNode", sessionId);
        this.namenodeActivityMBean = new NameNodeActivtyMBean(this.registry);
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(metricsContext, "namenode");
        this.metricsRecord.setTag("sessionId", sessionId);
        metricsContext.registerUpdater(this);
        log.info((Object)("Initializing NameNodeMeterics using context object:" + metricsContext.getClass().getName()));
    }

    public void shutdown() {
        if (this.namenodeActivityMBean != null) {
            this.namenodeActivityMBean.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        NameNodeMetrics nameNodeMetrics = this;
        synchronized (nameNodeMetrics) {
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
        this.transactions.resetMinMax();
        this.syncs.resetMinMax();
        this.blockReport.resetMinMax();
    }
}

