/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.log4j.LogManager;

class Child {
    public static final Log LOG = LogFactory.getLog(TaskTracker.class);
    static volatile TaskAttemptID taskid = null;
    static volatile boolean isCleanup;

    Child() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        LOG.debug((Object)"Child starting");
        JobConf defaultConf = new JobConf();
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        InetSocketAddress address = new InetSocketAddress(host, port);
        final TaskAttemptID firstTaskid = TaskAttemptID.forName(args[2]);
        int SLEEP_LONGER_COUNT = 5;
        int jvmIdInt = Integer.parseInt(args[3]);
        JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.isMap(), jvmIdInt);
        TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, 15L, address, defaultConf);
        int numTasksToExecute = -1;
        int numTasksExecuted = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (taskid != null) {
                        TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            if (taskid == null) continue;
                            TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                        }
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    catch (IOException iee) {
                        LOG.error((Object)("Error in syncLogs: " + iee));
                        System.exit(-1);
                        continue;
                    }
                    break;
                }
            }
        };
        t.setName("Thread for syncLogs");
        t.setDaemon(true);
        t.start();
        Path srcPidPath = null;
        Path dstPidPath = null;
        int idleLoopCount = 0;
        Task task = null;
        try {
            while (true) {
                taskid = null;
                JvmTask myTask = umbilical.getTask(jvmId);
                if (myTask.shouldDie()) {
                    break;
                }
                if (myTask.getTask() == null) {
                    taskid = null;
                    if (++idleLoopCount >= 5) {
                        Thread.sleep(1500L);
                        continue;
                    }
                    Thread.sleep(500L);
                    continue;
                }
                idleLoopCount = 0;
                task = myTask.getTask();
                taskid = task.getTaskID();
                isCleanup = task.isTaskCleanupTask();
                FileSystem.clearStatistics();
                TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                JobConf job = new JobConf(task.getJobFile());
                if (job.getBoolean("task.memory.mgmt.enabled", false)) {
                    if (srcPidPath == null) {
                        srcPidPath = new Path(task.getPidFile());
                    }
                    if (!taskid.equals(firstTaskid)) {
                        dstPidPath = new Path(task.getPidFile());
                        FileUtil.symLink(srcPidPath.toUri().getPath(), dstPidPath.toUri().getPath());
                    }
                }
                TaskRunner.setupWorkDir(job);
                numTasksToExecute = job.getNumTasksToExecutePerJvm();
                assert (numTasksToExecute != 0);
                TaskLog.cleanup(job.getInt("mapred.userlog.retain.hours", 24));
                task.setConf(job);
                defaultConf.addResource(new Path(task.getJobFile()));
                JvmMetrics.init(task.getPhase().toString(), job.getSessionId());
                FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                try {
                    task.run(job, umbilical);
                }
                finally {
                    TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                    if (!taskid.equals(firstTaskid) && job.getBoolean("task.memory.mgmt.enabled", false)) {
                        new File(dstPidPath.toUri().getPath()).delete();
                    }
                }
                if (numTasksToExecute > 0 && ++numTasksExecuted == numTasksToExecute) break;
            }
        }
        catch (FSError e) {
            LOG.fatal((Object)"FSError from child", (Throwable)e);
            umbilical.fsError(taskid, e.getMessage());
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Error running child", throwable);
            try {
                if (task != null) {
                    task.taskCleanup(umbilical);
                }
            }
            catch (Throwable th) {
                LOG.info((Object)("Error cleaning up" + th));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(baos));
            if (taskid != null) {
                umbilical.reportDiagnosticInfo(taskid, baos.toString());
            }
        }
        finally {
            RPC.stopProxy(umbilical);
            MetricsContext metricsContext = MetricsUtil.getContext("mapred");
            metricsContext.close();
            LogManager.shutdown();
        }
    }
}

