/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.util.StringUtils;

class EagerTaskInitializationListener
extends JobInProgressListener {
    private static final int DEFAULT_NUM_THREADS = 4;
    private static final Log LOG = LogFactory.getLog((String)EagerTaskInitializationListener.class.getName());
    private JobInitManager jobInitManager = new JobInitManager();
    private Thread jobInitManagerThread;
    private List<JobInProgress> jobInitQueue = new ArrayList<JobInProgress>();
    private ExecutorService threadPool;
    private int numThreads;

    public EagerTaskInitializationListener(Configuration conf) {
        this.numThreads = conf.getInt("mapred.jobinit.threads", 4);
        this.threadPool = Executors.newFixedThreadPool(this.numThreads);
    }

    public void start() throws IOException {
        this.jobInitManagerThread = new Thread((Runnable)this.jobInitManager, "jobInitManager");
        this.jobInitManagerThread.setDaemon(true);
        this.jobInitManagerThread.start();
    }

    public void terminate() throws IOException {
        if (this.jobInitManagerThread != null && this.jobInitManagerThread.isAlive()) {
            LOG.info((Object)"Stopping Job Init Manager thread");
            this.jobInitManagerThread.interrupt();
            try {
                this.jobInitManagerThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobAdded(JobInProgress job) {
        List<JobInProgress> list = this.jobInitQueue;
        synchronized (list) {
            this.jobInitQueue.add(job);
            this.resortInitQueue();
            this.jobInitQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resortInitQueue() {
        Comparator<JobInProgress> comp = new Comparator<JobInProgress>(){

            @Override
            public int compare(JobInProgress o1, JobInProgress o2) {
                int res = o1.getPriority().compareTo(o2.getPriority());
                if (res == 0) {
                    res = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() == o2.getStartTime() ? 0 : 1);
                }
                return res;
            }
        };
        List<JobInProgress> list = this.jobInitQueue;
        synchronized (list) {
            Collections.sort(this.jobInitQueue, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobRemoved(JobInProgress job) {
        List<JobInProgress> list = this.jobInitQueue;
        synchronized (list) {
            this.jobInitQueue.remove(job);
        }
    }

    @Override
    public void jobUpdated(JobChangeEvent event) {
        if (event instanceof JobStatusChangeEvent) {
            this.jobStateChanged((JobStatusChangeEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobStateChanged(JobStatusChangeEvent event) {
        if (event.getEventType() == JobStatusChangeEvent.EventType.START_TIME_CHANGED || event.getEventType() == JobStatusChangeEvent.EventType.PRIORITY_CHANGED) {
            List<JobInProgress> list = this.jobInitQueue;
            synchronized (list) {
                this.resortInitQueue();
            }
        }
    }

    static class InitJob
    implements Runnable {
        private JobInProgress job;

        public InitJob(JobInProgress job) {
            this.job = job;
        }

        @Override
        public void run() {
            block2: {
                try {
                    LOG.info((Object)("Initializing " + this.job.getJobID()));
                    this.job.initTasks();
                }
                catch (Throwable t) {
                    LOG.error((Object)("Job initialization failed:\n" + StringUtils.stringifyException(t)));
                    if (this.job == null) break block2;
                    this.job.fail();
                }
            }
        }
    }

    class JobInitManager
    implements Runnable {
        JobInitManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobInProgress job = null;
            try {
                while (true) {
                    List list = EagerTaskInitializationListener.this.jobInitQueue;
                    synchronized (list) {
                        while (EagerTaskInitializationListener.this.jobInitQueue.isEmpty()) {
                            EagerTaskInitializationListener.this.jobInitQueue.wait();
                        }
                        job = (JobInProgress)EagerTaskInitializationListener.this.jobInitQueue.remove(0);
                    }
                    EagerTaskInitializationListener.this.threadPool.execute(new InitJob(job));
                }
            }
            catch (InterruptedException t) {
                LOG.info((Object)"JobInitManagerThread interrupted.");
                LOG.info((Object)"Shutting down thread pool");
                EagerTaskInitializationListener.this.threadPool.shutdownNow();
                return;
            }
        }
    }
}

