/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;

public class IsolationRunner {
    private static final Log LOG = LogFactory.getLog((String)IsolationRunner.class.getName());

    private static ClassLoader makeClassLoader(JobConf conf, File workDir) throws IOException {
        ArrayList<URL> cp = new ArrayList<URL>();
        String jar = conf.getJar();
        if (jar != null) {
            File[] libs = new File(workDir, "lib").listFiles();
            if (libs != null) {
                for (int i = 0; i < libs.length; ++i) {
                    cp.add(new URL("file:" + libs[i].toString()));
                }
            }
            cp.add(new URL("file:" + new File(workDir, "classes/").toString()));
            cp.add(new URL("file:" + workDir.toString() + "/"));
        }
        return new URLClassLoader(cp.toArray(new URL[cp.size()]));
    }

    private static void fillInMissingMapOutputs(FileSystem fs, TaskAttemptID taskId, int numMaps, JobConf conf) throws IOException {
        Class<WritableComparable> keyClass = conf.getMapOutputKeyClass().asSubclass(WritableComparable.class);
        Class<Writable> valueClass = conf.getMapOutputValueClass().asSubclass(Writable.class);
        MapOutputFile namer = new MapOutputFile(taskId.getJobID());
        namer.setConf(conf);
        for (int i = 0; i < numMaps; ++i) {
            Path f = namer.getInputFile(i, taskId);
            if (fs.exists(f)) continue;
            LOG.info((Object)("Create missing input: " + f));
            SequenceFile.Writer out = SequenceFile.createWriter(fs, conf, f, keyClass, valueClass);
            out.close();
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException, InterruptedException {
        Task task;
        File jobFilename;
        if (args.length != 1) {
            System.out.println("Usage: IsolationRunner <path>/job.xml");
            System.exit(1);
        }
        if (!(jobFilename = new File(args[0])).exists() || !jobFilename.isFile()) {
            System.out.println(jobFilename + " is not a valid job file.");
            System.exit(1);
        }
        JobConf conf = new JobConf(new Path(jobFilename.toString()));
        TaskAttemptID taskId = TaskAttemptID.forName(conf.get("mapred.task.id"));
        boolean isMap = conf.getBoolean("mapred.task.is.map", true);
        int partition = conf.getInt("mapred.task.partition", 0);
        LocalFileSystem local = FileSystem.getLocal(conf);
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        File workDirName = new File(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir(taskId.getJobID().toString(), taskId.toString()) + "/" + "work", conf).toString());
        ((FileSystem)local).setWorkingDirectory(new Path(workDirName.toString()));
        FileSystem.get(conf).setWorkingDirectory(conf.getWorkingDirectory());
        ClassLoader classLoader = IsolationRunner.makeClassLoader(conf, workDirName);
        Thread.currentThread().setContextClassLoader(classLoader);
        conf.setClassLoader(classLoader);
        if (isMap) {
            Path localSplit = new Path(new Path(jobFilename.toString()).getParent(), "split.dta");
            FSDataInputStream splitFile = FileSystem.getLocal(conf).open(localSplit);
            String splitClass = Text.readString(splitFile);
            BytesWritable split = new BytesWritable();
            split.readFields(splitFile);
            splitFile.close();
            task = new MapTask(jobFilename.toString(), taskId, partition, splitClass, split);
        } else {
            int numMaps = conf.getNumMapTasks();
            IsolationRunner.fillInMissingMapOutputs(local, taskId, numMaps, conf);
            task = new ReduceTask(jobFilename.toString(), taskId, partition, numMaps);
        }
        task.setConf(conf);
        ((Task)task).run(conf, new FakeUmbilical());
    }

    private static class FakeUmbilical
    implements TaskUmbilicalProtocol {
        private FakeUmbilical() {
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 15L;
        }

        @Override
        public void done(TaskAttemptID taskid) throws IOException {
            LOG.info((Object)("Task " + taskid + " reporting done."));
        }

        @Override
        public void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting file system error: " + message));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting shuffle error: " + message));
        }

        @Override
        public JvmTask getTask(JVMId jvmId) throws IOException {
            return null;
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskId, taskStatus);
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            StringBuffer buf = new StringBuffer("Task ");
            buf.append(taskId);
            buf.append(" making progress to ");
            buf.append(taskStatus.getProgress());
            String state = taskStatus.getStateString();
            if (state != null) {
                buf.append(" and state of ");
                buf.append(state);
            }
            LOG.info((Object)buf.toString());
            return true;
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
            LOG.info((Object)("Task " + taskid + " has problem " + trace));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }
    }
}

