/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;

class ResourceEstimator {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.ResourceEstimator");
    private long completedMapsInputSize;
    private long completedMapsOutputSize;
    private int completedMapsUpdates;
    private final JobInProgress job;
    private final int threshholdToUse;

    public ResourceEstimator(JobInProgress job) {
        this.job = job;
        this.threshholdToUse = job.desiredMaps() / 10;
    }

    protected synchronized void updateWithCompletedTask(TaskStatus ts, TaskInProgress tip) {
        if (tip.isMapTask() && ts.getOutputSize() != -1L) {
            ++this.completedMapsUpdates;
            this.completedMapsInputSize += tip.getMapInputSize() + 1L;
            this.completedMapsOutputSize += ts.getOutputSize();
            LOG.info((Object)("completedMapsUpdates:" + this.completedMapsUpdates + "  " + "completedMapsInputSize:" + this.completedMapsInputSize + "  " + "completedMapsOutputSize:" + this.completedMapsOutputSize));
        }
    }

    protected synchronized long getEstimatedTotalMapOutputSize() {
        if (this.completedMapsUpdates < this.threshholdToUse) {
            return 0L;
        }
        long inputSize = this.job.getInputLength() + (long)this.job.desiredMaps();
        long estimate = Math.round((double)(inputSize * this.completedMapsOutputSize) * 2.0 / (double)this.completedMapsInputSize);
        LOG.debug((Object)("estimate total map output will be " + estimate));
        return estimate;
    }

    long getEstimatedMapOutputSize() {
        long estimate = this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredMaps();
        return estimate;
    }

    long getEstimatedReduceInputSize() {
        if (this.job.desiredReduces() == 0) {
            return 0L;
        }
        return this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredReduces();
    }
}

