/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

abstract class Task
implements Writable,
Configurable {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskRunner");
    protected static final String FILESYSTEM_COUNTER_GROUP = "FileSystemCounters";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private String jobFile;
    private TaskAttemptID taskId;
    private int partition;
    TaskStatus taskStatus;
    protected boolean jobCleanup = false;
    protected boolean jobSetup = false;
    protected boolean taskCleanup = false;
    private SortedRanges skipRanges = new SortedRanges();
    private boolean skipping = false;
    private boolean writeSkipRecs = true;
    private volatile long currentRecStartIndex;
    private Iterator<Long> currentRecIndexIterator = this.skipRanges.skipRangeIterator();
    protected JobConf conf;
    protected MapOutputFile mapOutputFile = new MapOutputFile();
    protected LocalDirAllocator lDirAlloc;
    private static final int MAX_RETRIES = 10;
    protected JobContext jobContext;
    protected org.apache.hadoop.mapred.TaskAttemptContext taskContext;
    protected OutputFormat<?, ?> outputFormat;
    protected OutputCommitter committer;
    protected final Counters.Counter spilledRecordsCounter;
    private String pidFile = "";
    public static final int PROGRESS_INTERVAL = 3000;
    private transient Progress taskProgress = new Progress();
    private transient Counters counters = new Counters();
    private AtomicBoolean taskDone = new AtomicBoolean(false);
    private Map<String, FileSystemStatisticUpdater> statisticUpdaters = new HashMap<String, FileSystemStatisticUpdater>();
    private static final Constructor<Reducer.Context> contextConstructor;

    protected static String[] getFileSystemCounterNames(String uriScheme) {
        String scheme = uriScheme.toUpperCase();
        return new String[]{scheme + "_BYTES_READ", scheme + "_BYTES_WRITTEN"};
    }

    static synchronized String getOutputName(int partition) {
        return "part-" + NUMBER_FORMAT.format(partition);
    }

    public Task() {
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask());
        this.taskId = new TaskAttemptID();
        this.spilledRecordsCounter = this.counters.findCounter(Counter.SPILLED_RECORDS);
    }

    public Task(String jobFile, TaskAttemptID taskId, int partition) {
        this.jobFile = jobFile;
        this.taskId = taskId;
        this.partition = partition;
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask(), this.taskId, 0.0f, TaskStatus.State.UNASSIGNED, "", "", "", this.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE, this.counters);
        this.mapOutputFile.setJobId(taskId.getJobID());
        this.spilledRecordsCounter = this.counters.findCounter(Counter.SPILLED_RECORDS);
    }

    public void setJobFile(String jobFile) {
        this.jobFile = jobFile;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public TaskAttemptID getTaskID() {
        return this.taskId;
    }

    Counters getCounters() {
        return this.counters;
    }

    public void setPidFile(String pidFile) {
        this.pidFile = pidFile;
    }

    public String getPidFile() {
        return this.pidFile;
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public int getPartition() {
        return this.partition;
    }

    public synchronized TaskStatus.Phase getPhase() {
        return this.taskStatus.getPhase();
    }

    protected synchronized void setPhase(TaskStatus.Phase phase) {
        this.taskStatus.setPhase(phase);
    }

    protected boolean toWriteSkipRecs() {
        return this.writeSkipRecs;
    }

    protected void setWriteSkipRecs(boolean writeSkipRecs) {
        this.writeSkipRecs = writeSkipRecs;
    }

    public SortedRanges getSkipRanges() {
        return this.skipRanges;
    }

    public void setSkipRanges(SortedRanges skipRanges) {
        this.skipRanges = skipRanges;
    }

    public boolean isSkipping() {
        return this.skipping;
    }

    public void setSkipping(boolean skipping) {
        this.skipping = skipping;
    }

    synchronized TaskStatus.State getState() {
        return this.taskStatus.getRunState();
    }

    synchronized void setState(TaskStatus.State state) {
        this.taskStatus.setRunState(state);
    }

    void setTaskCleanupTask() {
        this.taskCleanup = true;
    }

    boolean isTaskCleanupTask() {
        return this.taskCleanup;
    }

    boolean isJobCleanupTask() {
        return this.jobCleanup;
    }

    boolean isJobSetupTask() {
        return this.jobSetup;
    }

    void setJobSetupTask() {
        this.jobSetup = true;
    }

    void setJobCleanupTask() {
        this.jobCleanup = true;
    }

    boolean isMapOrReduce() {
        return !this.jobSetup && !this.jobCleanup && !this.taskCleanup;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.jobFile);
        this.taskId.write(out);
        out.writeInt(this.partition);
        this.taskStatus.write(out);
        this.skipRanges.write(out);
        out.writeBoolean(this.skipping);
        out.writeBoolean(this.jobCleanup);
        out.writeBoolean(this.jobSetup);
        out.writeBoolean(this.writeSkipRecs);
        out.writeBoolean(this.taskCleanup);
        Text.writeString(out, this.pidFile);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.jobFile = Text.readString(in);
        this.taskId = TaskAttemptID.read(in);
        this.partition = in.readInt();
        this.taskStatus.readFields(in);
        this.mapOutputFile.setJobId(this.taskId.getJobID());
        this.skipRanges.readFields(in);
        this.currentRecIndexIterator = this.skipRanges.skipRangeIterator();
        this.currentRecStartIndex = this.currentRecIndexIterator.next();
        this.skipping = in.readBoolean();
        this.jobCleanup = in.readBoolean();
        this.jobSetup = in.readBoolean();
        this.writeSkipRecs = in.readBoolean();
        this.taskCleanup = in.readBoolean();
        if (this.taskCleanup) {
            this.setPhase(TaskStatus.Phase.CLEANUP);
        }
        this.pidFile = Text.readString(in);
    }

    public String toString() {
        return this.taskId.toString();
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        conf.set("mapred.tip.id", this.taskId.getTaskID().toString());
        conf.set("mapred.task.id", this.taskId.toString());
        conf.setBoolean("mapred.task.is.map", this.isMapTask());
        conf.setInt("mapred.task.partition", this.partition);
        conf.set("mapred.job.id", this.taskId.getJobID().toString());
    }

    public abstract void run(JobConf var1, TaskUmbilicalProtocol var2) throws IOException, ClassNotFoundException, InterruptedException;

    public abstract TaskRunner createRunner(TaskTracker var1, TaskTracker.TaskInProgress var2) throws IOException;

    public abstract boolean isMapTask();

    public Progress getProgress() {
        return this.taskProgress;
    }

    public void initialize(JobConf job, JobID id, Reporter reporter, boolean useNewApi) throws IOException, ClassNotFoundException, InterruptedException {
        this.jobContext = new JobContext(job, id, reporter);
        this.taskContext = new org.apache.hadoop.mapred.TaskAttemptContext(job, this.taskId, reporter);
        if (this.getState() == TaskStatus.State.UNASSIGNED) {
            this.setState(TaskStatus.State.RUNNING);
        }
        if (useNewApi) {
            LOG.debug((Object)"using new api for output committer");
            this.outputFormat = ReflectionUtils.newInstance(this.taskContext.getOutputFormatClass(), job);
            this.committer = this.outputFormat.getOutputCommitter(this.taskContext);
        } else {
            this.committer = this.conf.getOutputCommitter();
        }
        Path outputPath = FileOutputFormat.getOutputPath(this.conf);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                FileOutputFormat.setWorkOutputPath(this.conf, ((FileOutputCommitter)this.committer).getTempTaskOutputPath(this.taskContext));
            } else {
                FileOutputFormat.setWorkOutputPath(this.conf, outputPath);
            }
        }
        this.committer.setupTask(this.taskContext);
    }

    protected void reportNextRecordRange(TaskUmbilicalProtocol umbilical, long nextRecIndex) throws IOException {
        long len = nextRecIndex - this.currentRecStartIndex + 1L;
        SortedRanges.Range range = new SortedRanges.Range(this.currentRecStartIndex, len);
        this.taskStatus.setNextRecordRange(range);
        LOG.debug((Object)("sending reportNextRecordRange " + range));
        umbilical.reportNextRecordRange(this.taskId, range);
    }

    private synchronized void updateCounters() {
        for (FileSystem.Statistics stat : FileSystem.getAllStatistics()) {
            String uriScheme = stat.getScheme();
            FileSystemStatisticUpdater updater = this.statisticUpdaters.get(uriScheme);
            if (updater == null) {
                updater = new FileSystemStatisticUpdater(uriScheme, stat);
                this.statisticUpdaters.put(uriScheme, updater);
            }
            updater.updateCounters();
        }
    }

    public void done(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        LOG.info((Object)("Task:" + this.taskId + " is done." + " And is in the process of commiting"));
        this.updateCounters();
        boolean commitRequired = this.committer.needsTaskCommit(this.taskContext);
        if (commitRequired) {
            int retries = 10;
            this.setState(TaskStatus.State.COMMIT_PENDING);
            while (true) {
                try {
                    umbilical.commitPending(this.taskId, this.taskStatus);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Failure sending commit pending: " + StringUtils.stringifyException(ie)));
                    if (--retries != 0) continue;
                    System.exit(67);
                    continue;
                }
                break;
            }
            this.commit(umbilical, reporter, this.committer);
        }
        this.taskDone.set(true);
        reporter.stopCommunicationThread();
        this.sendLastUpdate(umbilical);
        this.sendDone(umbilical);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void statusUpdate(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        while (true) {
            try {
                if (!umbilical.statusUpdate(this.getTaskID(), this.taskStatus)) {
                    LOG.warn((Object)("Parent died.  Exiting " + this.taskId));
                    System.exit(66);
                }
                this.taskStatus.clearStatus();
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure sending status update: " + StringUtils.stringifyException(ie)));
                if (--retries == 0) throw ie;
                continue;
            }
            break;
        }
    }

    private void sendLastUpdate(TaskUmbilicalProtocol umbilical) throws IOException {
        this.taskStatus.statusUpdate(this.taskProgress.get(), this.taskProgress.toString(), this.counters);
        this.statusUpdate(umbilical);
    }

    private void sendDone(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        while (true) {
            try {
                umbilical.done(this.getTaskID());
                LOG.info((Object)("Task '" + this.taskId + "' done."));
                return;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure signalling completion: " + StringUtils.stringifyException(ie)));
                if (--retries != 0) continue;
                throw ie;
            }
            break;
        }
    }

    private void commit(TaskUmbilicalProtocol umbilical, TaskReporter reporter, OutputCommitter committer) throws IOException {
        int retries = 10;
        while (true) {
            try {
                while (!umbilical.canCommit(this.taskId)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    reporter.setProgressFlag();
                }
                try {
                    LOG.info((Object)("Task " + this.taskId + " is allowed to commit now"));
                    committer.commitTask(this.taskContext);
                    return;
                }
                catch (IOException iee) {
                    LOG.warn((Object)("Failure committing: " + StringUtils.stringifyException(iee)));
                    this.discardOutput(this.taskContext);
                    throw iee;
                }
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure asking whether task can commit: " + StringUtils.stringifyException(ie)));
                if (--retries != 0) continue;
                this.discardOutput(this.taskContext);
                System.exit(68);
                continue;
            }
            break;
        }
    }

    private void discardOutput(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        try {
            this.committer.abortTask(taskContext);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Failure cleaning up: " + StringUtils.stringifyException(ioe)));
        }
    }

    protected void runTaskCleanupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.taskCleanup(umbilical);
        this.done(umbilical, reporter);
    }

    void taskCleanup(TaskUmbilicalProtocol umbilical) throws IOException {
        this.setPhase(TaskStatus.Phase.CLEANUP);
        this.getProgress().setStatus("cleanup");
        this.statusUpdate(umbilical);
        LOG.info((Object)"Runnning cleanup for the task");
        this.discardOutput(this.taskContext);
    }

    protected void runJobCleanupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.setPhase(TaskStatus.Phase.CLEANUP);
        this.getProgress().setStatus("cleanup");
        this.statusUpdate(umbilical);
        this.committer.cleanupJob(this.jobContext);
        this.done(umbilical, reporter);
    }

    protected void runJobSetupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.getProgress().setStatus("setup");
        this.committer.setupJob(this.jobContext);
        this.done(umbilical, reporter);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.mapOutputFile.setConf(this.conf);
        this.lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        String[] hostToResolved = conf.getStrings("hadoop.net.static.resolutions");
        if (hostToResolved != null) {
            for (String str : hostToResolved) {
                String name = str.substring(0, str.indexOf(61));
                String resolvedName = str.substring(str.indexOf(61) + 1);
                NetUtils.addStaticResolution(name, resolvedName);
            }
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    protected static <INKEY, INVALUE, OUTKEY, OUTVALUE> Reducer.Context createReduceContext(org.apache.hadoop.mapreduce.Reducer<INKEY, INVALUE, OUTKEY, OUTVALUE> reducer, Configuration job, org.apache.hadoop.mapreduce.TaskAttemptID taskId, RawKeyValueIterator rIter, org.apache.hadoop.mapreduce.Counter inputCounter, RecordWriter<OUTKEY, OUTVALUE> output, OutputCommitter committer, StatusReporter reporter, RawComparator<INKEY> comparator, Class<INKEY> keyClass, Class<INVALUE> valueClass) throws IOException, ClassNotFoundException {
        try {
            return contextConstructor.newInstance(reducer, job, taskId, rIter, inputCounter, output, committer, reporter, comparator, keyClass, valueClass);
        }
        catch (InstantiationException e) {
            throw new IOException("Can't create Context", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Can't invoke Context constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Can't invoke Context constructor", e);
        }
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
        try {
            contextConstructor = Reducer.Context.class.getConstructor(org.apache.hadoop.mapreduce.Reducer.class, Configuration.class, org.apache.hadoop.mapreduce.TaskAttemptID.class, RawKeyValueIterator.class, org.apache.hadoop.mapreduce.Counter.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, RawComparator.class, Class.class, Class.class);
        }
        catch (NoSuchMethodException nme) {
            throw new IllegalArgumentException("Can't find constructor");
        }
    }

    protected static class NewCombinerRunner<K, V>
    extends CombinerRunner<K, V> {
        private final Class<? extends org.apache.hadoop.mapreduce.Reducer<K, V, K, V>> reducerClass;
        private final org.apache.hadoop.mapreduce.TaskAttemptID taskId;
        private final RawComparator<K> comparator;
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final OutputCommitter committer;

        NewCombinerRunner(Class reducerClass, JobConf job, org.apache.hadoop.mapreduce.TaskAttemptID taskId, TaskAttemptContext context, Counters.Counter inputCounter, TaskReporter reporter, OutputCommitter committer) {
            super(inputCounter, job, reporter);
            this.reducerClass = reducerClass;
            this.taskId = taskId;
            this.keyClass = context.getMapOutputKeyClass();
            this.valueClass = context.getMapOutputValueClass();
            this.comparator = context.getSortComparator();
            this.committer = committer;
        }

        @Override
        void combine(RawKeyValueIterator iterator, OutputCollector<K, V> collector) throws IOException, InterruptedException, ClassNotFoundException {
            org.apache.hadoop.mapreduce.Reducer<K, V, K, V> reducer = ReflectionUtils.newInstance(this.reducerClass, this.job);
            Reducer.Context reducerContext = Task.createReduceContext(reducer, this.job, this.taskId, iterator, this.inputCounter, new OutputConverter<K, V>(collector), this.committer, this.reporter, this.comparator, this.keyClass, this.valueClass);
            reducer.run(reducerContext);
        }

        private static class OutputConverter<K, V>
        extends RecordWriter<K, V> {
            OutputCollector<K, V> output;

            OutputConverter(OutputCollector<K, V> output) {
                this.output = output;
            }

            @Override
            public void close(TaskAttemptContext context) {
            }

            @Override
            public void write(K key, V value) throws IOException, InterruptedException {
                this.output.collect(key, value);
            }
        }
    }

    protected static class OldCombinerRunner<K, V>
    extends CombinerRunner<K, V> {
        private final Class<? extends Reducer<K, V, K, V>> combinerClass;
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final RawComparator<K> comparator;

        protected OldCombinerRunner(Class<? extends Reducer<K, V, K, V>> cls, JobConf conf, Counters.Counter inputCounter, TaskReporter reporter) {
            super(inputCounter, conf, reporter);
            this.combinerClass = cls;
            this.keyClass = this.job.getMapOutputKeyClass();
            this.valueClass = this.job.getMapOutputValueClass();
            this.comparator = this.job.getOutputKeyComparator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void combine(RawKeyValueIterator kvIter, OutputCollector<K, V> combineCollector) throws IOException {
            Reducer<K, V, K, V> combiner = ReflectionUtils.newInstance(this.combinerClass, this.job);
            try {
                CombineValuesIterator<K, V> values = new CombineValuesIterator<K, V>(kvIter, this.comparator, this.keyClass, this.valueClass, this.job, Reporter.NULL, this.inputCounter);
                while (values.more()) {
                    combiner.reduce(values.getKey(), values, combineCollector, Reporter.NULL);
                    values.nextKey();
                }
            }
            finally {
                combiner.close();
            }
        }
    }

    protected static abstract class CombinerRunner<K, V> {
        protected final Counters.Counter inputCounter;
        protected final JobConf job;
        protected final TaskReporter reporter;

        CombinerRunner(Counters.Counter inputCounter, JobConf job, TaskReporter reporter) {
            this.inputCounter = inputCounter;
            this.job = job;
            this.reporter = reporter;
        }

        abstract void combine(RawKeyValueIterator var1, OutputCollector<K, V> var2) throws IOException, InterruptedException, ClassNotFoundException;

        static <K, V> CombinerRunner<K, V> create(JobConf job, TaskAttemptID taskId, Counters.Counter inputCounter, TaskReporter reporter, OutputCommitter committer) throws ClassNotFoundException {
            Class<? extends Reducer> cls = job.getCombinerClass();
            if (cls != null) {
                return new OldCombinerRunner(cls, job, inputCounter, reporter);
            }
            TaskAttemptContext taskContext = new TaskAttemptContext((Configuration)job, taskId);
            Class<? extends org.apache.hadoop.mapreduce.Reducer<?, ?, ?, ?>> newcls = taskContext.getCombinerClass();
            if (newcls != null) {
                return new NewCombinerRunner(newcls, job, taskId, taskContext, inputCounter, reporter, committer);
            }
            return null;
        }
    }

    protected static class CombineValuesIterator<KEY, VALUE>
    extends ValuesIterator<KEY, VALUE> {
        private final Counters.Counter combineInputCounter;

        public CombineValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Reporter reporter, Counters.Counter combineInputCounter) throws IOException {
            super(in, comparator, keyClass, valClass, conf, reporter);
            this.combineInputCounter = combineInputCounter;
        }

        @Override
        public VALUE next() {
            this.combineInputCounter.increment(1L);
            return super.next();
        }
    }

    static class ValuesIterator<KEY, VALUE>
    implements Iterator<VALUE> {
        protected RawKeyValueIterator in;
        private KEY key;
        private KEY nextKey;
        private VALUE value;
        private boolean hasNext;
        private boolean more;
        private RawComparator<KEY> comparator;
        protected Progressable reporter;
        private Deserializer<KEY> keyDeserializer;
        private Deserializer<VALUE> valDeserializer;
        private DataInputBuffer keyIn = new DataInputBuffer();
        private DataInputBuffer valueIn = new DataInputBuffer();
        private int ctr = 0;

        public ValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Progressable reporter) throws IOException {
            this.in = in;
            this.comparator = comparator;
            this.reporter = reporter;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
            this.keyDeserializer.open(this.keyIn);
            this.valDeserializer = serializationFactory.getDeserializer(valClass);
            this.valDeserializer.open(this.valueIn);
            this.readNextKey();
            this.key = this.nextKey;
            this.nextKey = null;
            this.hasNext = this.more;
        }

        RawKeyValueIterator getRawIterator() {
            return this.in;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public VALUE next() {
            if (!this.hasNext) {
                throw new NoSuchElementException("iterate past last value");
            }
            try {
                this.readNextValue();
                this.readNextKey();
            }
            catch (IOException ie) {
                throw new RuntimeException("problem advancing post rec#" + this.ctr, ie);
            }
            this.reporter.progress();
            return this.value;
        }

        @Override
        public void remove() {
            throw new RuntimeException("not implemented");
        }

        void nextKey() throws IOException {
            while (this.hasNext) {
                this.readNextKey();
            }
            ++this.ctr;
            KEY tmpKey = this.key;
            this.key = this.nextKey;
            this.nextKey = tmpKey;
            this.hasNext = this.more;
        }

        boolean more() {
            return this.more;
        }

        KEY getKey() {
            return this.key;
        }

        private void readNextKey() throws IOException {
            this.more = this.in.next();
            if (this.more) {
                DataInputBuffer nextKeyBytes = this.in.getKey();
                this.keyIn.reset(nextKeyBytes.getData(), nextKeyBytes.getPosition(), nextKeyBytes.getLength());
                this.nextKey = this.keyDeserializer.deserialize(this.nextKey);
                this.hasNext = this.key != null && this.comparator.compare(this.key, this.nextKey) == 0;
            } else {
                this.hasNext = false;
            }
        }

        private void readNextValue() throws IOException {
            DataInputBuffer nextValueBytes = this.in.getValue();
            this.valueIn.reset(nextValueBytes.getData(), nextValueBytes.getPosition(), nextValueBytes.getLength());
            this.value = this.valDeserializer.deserialize(this.value);
        }
    }

    protected static class CombineOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private IFile.Writer<K, V> writer;
        private Counters.Counter outCounter;

        public CombineOutputCollector(Counters.Counter outCounter) {
            this.outCounter = outCounter;
        }

        public synchronized void setWriter(IFile.Writer<K, V> writer) {
            this.writer = writer;
        }

        @Override
        public synchronized void collect(K key, V value) throws IOException {
            this.outCounter.increment(1L);
            this.writer.append(key, value);
        }
    }

    class FileSystemStatisticUpdater {
        private long prevReadBytes = 0L;
        private long prevWriteBytes = 0L;
        private FileSystem.Statistics stats;
        private Counters.Counter readCounter = null;
        private Counters.Counter writeCounter = null;
        private String[] counterNames;

        FileSystemStatisticUpdater(String uriScheme, FileSystem.Statistics stats) {
            this.stats = stats;
            this.counterNames = Task.getFileSystemCounterNames(uriScheme);
        }

        void updateCounters() {
            long newReadBytes = this.stats.getBytesRead();
            long newWriteBytes = this.stats.getBytesWritten();
            if (this.prevReadBytes != newReadBytes) {
                if (this.readCounter == null) {
                    this.readCounter = Task.this.counters.findCounter(Task.FILESYSTEM_COUNTER_GROUP, this.counterNames[0]);
                }
                this.readCounter.increment(newReadBytes - this.prevReadBytes);
                this.prevReadBytes = newReadBytes;
            }
            if (this.prevWriteBytes != newWriteBytes) {
                if (this.writeCounter == null) {
                    this.writeCounter = Task.this.counters.findCounter(Task.FILESYSTEM_COUNTER_GROUP, this.counterNames[1]);
                }
                this.writeCounter.increment(newWriteBytes - this.prevWriteBytes);
                this.prevWriteBytes = newWriteBytes;
            }
        }
    }

    protected class TaskReporter
    extends StatusReporter
    implements Runnable,
    Reporter {
        private TaskUmbilicalProtocol umbilical;
        private InputSplit split = null;
        private Progress taskProgress;
        private Thread pingThread = null;
        private AtomicBoolean progressFlag = new AtomicBoolean(false);

        TaskReporter(Progress taskProgress, TaskUmbilicalProtocol umbilical) {
            this.umbilical = umbilical;
            this.taskProgress = taskProgress;
        }

        void setProgressFlag() {
            this.progressFlag.set(true);
        }

        boolean resetProgressFlag() {
            return this.progressFlag.getAndSet(false);
        }

        @Override
        public void setStatus(String status) {
            this.taskProgress.setStatus(status);
            this.setProgressFlag();
        }

        public void setProgress(float progress) {
            this.taskProgress.set(progress);
            this.setProgressFlag();
        }

        @Override
        public void progress() {
            this.setProgressFlag();
        }

        @Override
        public Counters.Counter getCounter(String group, String name) {
            Counters.Counter counter = null;
            if (Task.this.counters != null) {
                counter = Task.this.counters.findCounter(group, name);
            }
            return counter;
        }

        @Override
        public Counters.Counter getCounter(Enum<?> name) {
            return Task.this.counters == null ? null : Task.this.counters.findCounter(name);
        }

        public void incrCounter(Enum key, long amount) {
            if (Task.this.counters != null) {
                Task.this.counters.incrCounter(key, amount);
            }
            this.setProgressFlag();
        }

        @Override
        public void incrCounter(String group, String counter, long amount) {
            if (Task.this.counters != null) {
                Task.this.counters.incrCounter(group, counter, amount);
            }
            if (Task.this.skipping && "SkippingTaskCounters".equals(group) && ("MapProcessedRecords".equals(counter) || "ReduceProcessedGroups".equals(counter))) {
                int i = 0;
                while ((long)i < amount) {
                    Task.this.currentRecStartIndex = (Long)Task.this.currentRecIndexIterator.next();
                    ++i;
                }
            }
            this.setProgressFlag();
        }

        public void setInputSplit(InputSplit split) {
            this.split = split;
        }

        @Override
        public InputSplit getInputSplit() throws UnsupportedOperationException {
            if (this.split == null) {
                throw new UnsupportedOperationException("Input only available on map");
            }
            return this.split;
        }

        @Override
        public void run() {
            int MAX_RETRIES = 3;
            int remainingRetries = 3;
            boolean sendProgress = this.resetProgressFlag();
            while (!Task.this.taskDone.get()) {
                try {
                    boolean taskFound = true;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)(Task.this.getTaskID() + " Progress/ping thread exiting " + "since it got interrupted"));
                        break;
                    }
                    if (sendProgress) {
                        Task.this.updateCounters();
                        Task.this.taskStatus.statusUpdate(this.taskProgress.get(), this.taskProgress.toString(), Task.this.counters);
                        taskFound = this.umbilical.statusUpdate(Task.this.taskId, Task.this.taskStatus);
                        Task.this.taskStatus.clearStatus();
                    } else {
                        taskFound = this.umbilical.ping(Task.this.taskId);
                    }
                    if (!taskFound) {
                        LOG.warn((Object)("Parent died.  Exiting " + Task.this.taskId));
                        System.exit(66);
                    }
                    sendProgress = this.resetProgressFlag();
                    remainingRetries = 3;
                }
                catch (Throwable t) {
                    LOG.info((Object)("Communication exception: " + StringUtils.stringifyException(t)));
                    if (--remainingRetries != 0) continue;
                    ReflectionUtils.logThreadInfo(LOG, "Communication exception", 0L);
                    LOG.warn((Object)("Last retry, killing " + Task.this.taskId));
                    System.exit(65);
                }
            }
        }

        public void startCommunicationThread() {
            if (this.pingThread == null) {
                this.pingThread = new Thread((Runnable)this, "communication thread");
                this.pingThread.setDaemon(true);
                this.pingThread.start();
            }
        }

        public void stopCommunicationThread() throws InterruptedException {
            if (this.pingThread != null) {
                this.pingThread.interrupt();
                this.pingThread.join();
            }
        }
    }

    protected static enum Counter {
        MAP_INPUT_RECORDS,
        MAP_OUTPUT_RECORDS,
        MAP_SKIPPED_RECORDS,
        MAP_INPUT_BYTES,
        MAP_OUTPUT_BYTES,
        COMBINE_INPUT_RECORDS,
        COMBINE_OUTPUT_RECORDS,
        REDUCE_INPUT_GROUPS,
        REDUCE_SHUFFLE_BYTES,
        REDUCE_INPUT_RECORDS,
        REDUCE_OUTPUT_RECORDS,
        REDUCE_SKIPPED_GROUPS,
        REDUCE_SKIPPED_RECORDS,
        SPILLED_RECORDS;

    }
}

