/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskMemoryManagerThread;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import org.apache.hadoop.mapred.TaskTrackerMetricsInst;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authorize.ConfiguredPolicy;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.MemoryCalculatorPlugin;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

public class TaskTracker
implements MRConstants,
TaskUmbilicalProtocol,
Runnable {
    static final long WAIT_FOR_DONE = 3000L;
    private int httpPort;
    public static final Log LOG;
    public static final String MR_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s";
    public static final Log ClientTraceLog;
    volatile boolean running = true;
    private LocalDirAllocator localDirAllocator;
    String taskTrackerName;
    String localHostname;
    InetSocketAddress jobTrackAddr;
    InetSocketAddress taskReportAddress;
    Server taskReportServer = null;
    InterTrackerProtocol jobClient;
    short heartbeatResponseId = (short)-1;
    TaskTrackerStatus status = null;
    Path systemDirectory = null;
    FileSystem systemFS = null;
    private final HttpServer server;
    volatile boolean shuttingDown = false;
    Map<TaskAttemptID, TaskInProgress> tasks = new HashMap<TaskAttemptID, TaskInProgress>();
    Map<TaskAttemptID, TaskInProgress> runningTasks = null;
    Map<JobID, RunningJob> runningJobs = null;
    volatile int mapTotal = 0;
    volatile int reduceTotal = 0;
    boolean justStarted = true;
    boolean justInited = true;
    Set<TaskAttemptID> shouldReset = new HashSet<TaskAttemptID>();
    Map<String, DF> localDirsDf = new HashMap<String, DF>();
    long minSpaceStart = 0L;
    boolean acceptNewTasks = true;
    long minSpaceKill = 0L;
    static Random r;
    private static final String SUBDIR = "taskTracker";
    private static final String CACHEDIR = "archive";
    private static final String JOBCACHE = "jobcache";
    private static final String PID = "pid";
    private static final String OUTPUT = "output";
    private JobConf originalConf;
    private JobConf fConf;
    private int maxCurrentMapTasks;
    private int maxCurrentReduceTasks;
    private int failures;
    private MapEventsFetcherThread mapEventsFetcher;
    int workerThreads;
    private CleanupQueue directoryCleanupThread;
    volatile JvmManager jvmManager;
    private TaskMemoryManagerThread taskMemoryManager;
    private boolean taskMemoryManagerEnabled = true;
    private long totalVirtualMemoryOnTT = -1L;
    private long totalPmemOnTT = -1L;
    private long reservedVirtualMemory = -1L;
    private long reservedPmem = -1L;
    private long defaultMaxVmPerTask = -1L;
    private long limitMaxVmPerTask = -1L;
    static final String MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY = "mapred.tasktracker.vmem.reserved";
    static final String MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY = "mapred.tasktracker.pmem.reserved";
    static final String MAPRED_TASKTRACKER_MEMORY_CALCULATOR_PLUGIN_PROPERTY = "mapred.tasktracker.memory_calculator_plugin";
    private volatile int heartbeatInterval = 3000;
    private int probe_sample_size = 500;
    private IndexCache indexCache;
    private List<TaskAttemptID> commitResponses = Collections.synchronizedList(new ArrayList());
    private ShuffleServerMetrics shuffleServerMetrics;
    private TaskTrackerInstrumentation myInstrumentation = null;
    private BlockingQueue<TaskTrackerAction> tasksToCleanup = new LinkedBlockingQueue<TaskTrackerAction>();
    private Thread taskCleanupThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskTrackerAction action;
                        if ((action = (TaskTrackerAction)TaskTracker.this.tasksToCleanup.take()) instanceof KillJobAction) {
                            TaskTracker.this.purgeJob((KillJobAction)action);
                            continue;
                        }
                        if (action instanceof KillTaskAction) {
                            TaskInProgress tip;
                            KillTaskAction killAction = (KillTaskAction)action;
                            TaskTracker taskTracker = TaskTracker.this;
                            synchronized (taskTracker) {
                                tip = TaskTracker.this.tasks.get(killAction.getTaskID());
                            }
                            LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskID()));
                            TaskTracker.this.purgeTask(tip, false);
                            continue;
                        }
                        LOG.error((Object)("Non-delete action given to cleanup thread: " + action));
                    }
                }
                catch (Throwable except) {
                    LOG.warn((Object)StringUtils.stringifyException(except));
                    continue;
                }
                break;
            }
        }
    }, "taskCleanup");
    private Object waitingOn = new Object();
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
    private long previousUpdate = 0L;
    private TaskLauncher mapLauncher;
    private TaskLauncher reduceLauncher;

    public TaskTrackerInstrumentation getTaskTrackerInstrumentation() {
        return this.myInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningJob addTaskToJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rJob = null;
            if (!this.runningJobs.containsKey(jobId)) {
                rJob = new RunningJob(jobId);
                rJob.localized = false;
                rJob.tasks = new HashSet<TaskInProgress>();
                this.runningJobs.put(jobId, rJob);
            } else {
                rJob = this.runningJobs.get(jobId);
            }
            RunningJob runningJob = rJob;
            synchronized (runningJob) {
                rJob.tasks.add(tip);
            }
            this.runningJobs.notify();
            return rJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskFromJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob == null) {
                LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
            } else {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.tasks.remove(tip);
                }
            }
        }
    }

    static String getCacheSubdir() {
        return "taskTracker/archive";
    }

    static String getJobCacheSubdir() {
        return "taskTracker/jobcache";
    }

    static String getLocalJobDir(String jobid) {
        return TaskTracker.getJobCacheSubdir() + "/" + jobid;
    }

    static String getLocalTaskDir(String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(jobid, taskid, false);
    }

    static String getIntermediateOutputDir(String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(jobid, taskid) + "/" + OUTPUT;
    }

    static String getLocalTaskDir(String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = TaskTracker.getLocalJobDir(jobid) + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + ".cleanup";
        }
        return taskDir;
    }

    static String getPidFile(String jobid, String taskid, boolean isCleanup) {
        return TaskTracker.getLocalTaskDir(jobid, taskid, isCleanup) + "/" + PID;
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(TaskUmbilicalProtocol.class.getName())) {
            return 15L;
        }
        throw new IOException("Unknown protocol for task tracker: " + protocol);
    }

    synchronized void initialize() throws IOException {
        this.fConf = new JobConf(this.originalConf);
        if (this.fConf.get("slave.host.name") != null) {
            this.localHostname = this.fConf.get("slave.host.name");
        }
        if (this.localHostname == null) {
            this.localHostname = DNS.getDefaultHost(this.fConf.get("mapred.tasktracker.dns.interface", "default"), this.fConf.get("mapred.tasktracker.dns.nameserver", "default"));
        }
        TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
        this.fConf.deleteLocalFiles(SUBDIR);
        this.tasks.clear();
        this.runningTasks = new LinkedHashMap<TaskAttemptID, TaskInProgress>();
        this.runningJobs = new TreeMap<JobID, RunningJob>();
        this.mapTotal = 0;
        this.reduceTotal = 0;
        this.acceptNewTasks = true;
        this.status = null;
        this.minSpaceStart = this.fConf.getLong("mapred.local.dir.minspacestart", 0L);
        this.minSpaceKill = this.fConf.getLong("mapred.local.dir.minspacekill", 0L);
        this.probe_sample_size = this.fConf.getInt("mapred.tasktracker.events.batchsize", 500);
        Class<? extends TaskTrackerInstrumentation> metricsInst = TaskTracker.getInstrumentationClass(this.fConf);
        try {
            Constructor<? extends TaskTrackerInstrumentation> c = metricsInst.getConstructor(TaskTracker.class);
            this.myInstrumentation = c.newInstance(this);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize taskTracker metrics", (Throwable)e);
            this.myInstrumentation = new TaskTrackerMetricsInst(this);
        }
        String address = NetUtils.getServerAddress(this.fConf, "mapred.task.tracker.report.bindAddress", "mapred.task.tracker.report.port", "mapred.task.tracker.report.address");
        InetSocketAddress socAddr = NetUtils.createSocketAddr(address);
        String bindAddress = socAddr.getHostName();
        int tmpPort = socAddr.getPort();
        this.jvmManager = new JvmManager(this);
        if (this.fConf.getBoolean("hadoop.security.authorization", false)) {
            PolicyProvider policyProvider = ReflectionUtils.newInstance(this.fConf.getClass("hadoop.security.authorization.policyprovider", MapReducePolicyProvider.class, PolicyProvider.class), this.fConf);
            SecurityUtil.setPolicy(new ConfiguredPolicy(this.fConf, policyProvider));
        }
        int max = this.maxCurrentMapTasks > this.maxCurrentReduceTasks ? this.maxCurrentMapTasks : this.maxCurrentReduceTasks;
        this.taskReportServer = RPC.getServer(this, bindAddress, tmpPort, 2 * max, false, this.fConf);
        this.taskReportServer.start();
        this.taskReportAddress = this.taskReportServer.getListenerAddress();
        this.fConf.set("mapred.task.tracker.report.address", this.taskReportAddress.getHostName() + ":" + this.taskReportAddress.getPort());
        LOG.info((Object)("TaskTracker up at: " + this.taskReportAddress));
        this.taskTrackerName = "tracker_" + this.localHostname + ":" + this.taskReportAddress;
        LOG.info((Object)("Starting tracker " + this.taskTrackerName));
        DistributedCache.purgeCache(this.fConf);
        this.cleanupStorage();
        this.jobClient = (InterTrackerProtocol)RPC.waitForProxy(InterTrackerProtocol.class, 25L, this.jobTrackAddr, this.fConf);
        this.justInited = true;
        this.running = true;
        this.mapEventsFetcher = new MapEventsFetcherThread();
        this.mapEventsFetcher.setDaemon(true);
        this.mapEventsFetcher.setName("Map-events fetcher for all reduce tasks on " + this.taskTrackerName);
        this.mapEventsFetcher.start();
        this.initializeMemoryManagement();
        this.indexCache = new IndexCache(this.fConf);
        this.mapLauncher = new TaskLauncher(this.maxCurrentMapTasks);
        this.reduceLauncher = new TaskLauncher(this.maxCurrentReduceTasks);
        this.mapLauncher.start();
        this.reduceLauncher.start();
    }

    public static Class<? extends TaskTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapred.tasktracker.instrumentation", TaskTrackerMetricsInst.class, TaskTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends TaskTrackerInstrumentation> t) {
        conf.setClass("mapred.tasktracker.instrumentation", t, TaskTrackerInstrumentation.class);
    }

    public void cleanupStorage() throws IOException {
        this.fConf.deleteLocalFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localizeJob(TaskInProgress tip) throws IOException {
        RunningJob rjob;
        Path localJarFile = null;
        Task t = tip.getTask();
        JobID jobId = t.getJobID();
        Path jobFile = new Path(t.getJobFile());
        FileStatus status = null;
        long jobFileSize = -1L;
        try {
            status = this.systemFS.getFileStatus(jobFile);
            jobFileSize = status.getLen();
        }
        catch (FileNotFoundException fe) {
            jobFileSize = -1L;
        }
        Path localJobFile = this.lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobDir(jobId.toString()) + "/" + "job.xml", jobFileSize, this.fConf);
        RunningJob runningJob = rjob = this.addTaskToJob(jobId, tip);
        synchronized (runningJob) {
            if (!rjob.localized) {
                Path jobDir;
                LocalFileSystem localFs = FileSystem.getLocal(this.fConf);
                if (localFs.exists(jobDir = localJobFile.getParent())) {
                    ((FileSystem)localFs).delete(jobDir, true);
                    boolean b = ((FileSystem)localFs).mkdirs(jobDir);
                    if (!b) {
                        throw new IOException("Not able to create job directory " + jobDir.toString());
                    }
                }
                this.systemFS.copyToLocalFile(jobFile, localJobFile);
                JobConf localJobConf = new JobConf(localJobFile);
                Path workDir = this.lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobDir(jobId.toString()) + "/" + "work", this.fConf);
                if (!((FileSystem)localFs).mkdirs(workDir)) {
                    throw new IOException("Mkdirs failed to create " + workDir.toString());
                }
                System.setProperty("job.local.dir", workDir.toString());
                localJobConf.set("job.local.dir", workDir.toString());
                String jarFile = localJobConf.getJar();
                long jarFileSize = -1L;
                if (jarFile != null) {
                    Path jarFilePath = new Path(jarFile);
                    try {
                        status = this.systemFS.getFileStatus(jarFilePath);
                        jarFileSize = status.getLen();
                    }
                    catch (FileNotFoundException fe) {
                        jarFileSize = -1L;
                    }
                    localJarFile = new Path(this.lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobDir(jobId.toString()) + "/" + "jars", 5L * jarFileSize, this.fConf), "job.jar");
                    if (!((FileSystem)localFs).mkdirs(localJarFile.getParent())) {
                        throw new IOException("Mkdirs failed to create jars directory ");
                    }
                    this.systemFS.copyToLocalFile(jarFilePath, localJarFile);
                    localJobConf.setJar(localJarFile.toString());
                    FSDataOutputStream out = localFs.create(localJobFile);
                    try {
                        localJobConf.writeXml(out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                    RunJar.unJar(new File(localJarFile.toString()), new File(localJarFile.getParent().toString()));
                }
                rjob.keepJobFiles = localJobConf.getKeepTaskFilesPattern() != null || localJobConf.getKeepFailedTaskFiles();
                rjob.localized = true;
                rjob.jobConf = localJobConf;
            }
        }
        this.launchTaskForJob(tip, new JobConf(rjob.jobConf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTaskForJob(TaskInProgress tip, JobConf jobConf) throws IOException {
        TaskInProgress taskInProgress = tip;
        synchronized (taskInProgress) {
            tip.setJobConf(jobConf);
            tip.launchTask();
        }
    }

    public synchronized void shutdown() throws IOException {
        this.shuttingDown = true;
        this.close();
        if (this.server != null) {
            try {
                LOG.info((Object)"Shutting down StatusHttpServer");
                this.server.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down TaskTracker", (Throwable)e);
            }
        }
    }

    public synchronized void close() throws IOException {
        TreeMap<TaskAttemptID, TaskInProgress> tasksToClose = new TreeMap<TaskAttemptID, TaskInProgress>();
        tasksToClose.putAll(this.tasks);
        for (TaskInProgress tip : tasksToClose.values()) {
            tip.jobHasFinished(false);
        }
        this.running = false;
        this.cleanupStorage();
        this.mapEventsFetcher.interrupt();
        this.mapLauncher.interrupt();
        this.reduceLauncher.interrupt();
        this.jvmManager.stop();
        RPC.stopProxy(this.jobClient);
        boolean done = false;
        while (!done) {
            try {
                this.mapEventsFetcher.join();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.taskReportServer != null) {
            this.taskReportServer.stop();
            this.taskReportServer = null;
        }
    }

    public TaskTracker(JobConf conf) throws IOException {
        this.originalConf = conf;
        this.maxCurrentMapTasks = conf.getInt("mapred.tasktracker.map.tasks.maximum", 2);
        this.maxCurrentReduceTasks = conf.getInt("mapred.tasktracker.reduce.tasks.maximum", 2);
        this.jobTrackAddr = JobTracker.getAddress(conf);
        String infoAddr = NetUtils.getServerAddress(conf, "tasktracker.http.bindAddress", "tasktracker.http.port", "mapred.task.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String httpBindAddress = infoSocAddr.getHostName();
        int httpPort = infoSocAddr.getPort();
        this.server = new HttpServer("task", httpBindAddress, httpPort, httpPort == 0, conf);
        this.workerThreads = conf.getInt("tasktracker.http.threads", 40);
        this.shuffleServerMetrics = new ShuffleServerMetrics(conf);
        this.server.setThreads(1, this.workerThreads);
        LocalFileSystem local = FileSystem.getLocal(conf);
        this.localDirAllocator = new LocalDirAllocator("mapred.local.dir");
        this.server.setAttribute("task.tracker", this);
        this.server.setAttribute("local.file.system", local);
        this.server.setAttribute("conf", conf);
        this.server.setAttribute("log", LOG);
        this.server.setAttribute("localDirAllocator", this.localDirAllocator);
        this.server.setAttribute("shuffleServerMetrics", this.shuffleServerMetrics);
        this.server.addInternalServlet("mapOutput", "/mapOutput", MapOutputServlet.class);
        this.server.addInternalServlet("taskLog", "/tasklog", TaskLogServlet.class);
        this.server.start();
        this.httpPort = this.server.getPort();
        this.initialize();
    }

    private void startCleanupThreads() throws IOException {
        this.taskCleanupThread.setDaemon(true);
        this.taskCleanupThread.start();
        this.directoryCleanupThread = new CleanupQueue();
    }

    public InterTrackerProtocol getJobClient() {
        return this.jobClient;
    }

    public synchronized InetSocketAddress getTaskTrackerReportAddress() {
        return this.taskReportAddress;
    }

    private List<TaskCompletionEvent> queryJobTracker(IntWritable fromEventId, JobID jobId, InterTrackerProtocol jobClient) throws IOException {
        TaskCompletionEvent[] t = jobClient.getTaskCompletionEvents(jobId, fromEventId.get(), this.probe_sample_size);
        ArrayList<TaskCompletionEvent> recentMapEvents = new ArrayList<TaskCompletionEvent>();
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].isMap) continue;
            recentMapEvents.add(t[i]);
        }
        fromEventId.set(fromEventId.get() + t.length);
        return recentMapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State offerService() throws Exception {
        long lastHeartbeat = 0L;
        while (this.running && !this.shuttingDown) {
            String msg;
            try {
                long now = System.currentTimeMillis();
                long waitTime = (long)this.heartbeatInterval - (now - lastHeartbeat);
                if (waitTime > 0L) {
                    Thread.sleep(waitTime);
                }
                if (this.justInited) {
                    String jobTrackerBV = this.jobClient.getBuildVersion();
                    if (!VersionInfo.getBuildVersion().equals(jobTrackerBV)) {
                        String msg2 = "Shutting down. Incompatible buildVersion.\nJobTracker's: " + jobTrackerBV + "\nTaskTracker's: " + VersionInfo.getBuildVersion();
                        LOG.error((Object)msg2);
                        try {
                            this.jobClient.reportTaskTrackerError(this.taskTrackerName, null, msg2);
                        }
                        catch (Exception e) {
                            LOG.info((Object)("Problem reporting to jobtracker: " + e));
                        }
                        return State.DENIED;
                    }
                    String dir = this.jobClient.getSystemDir();
                    if (dir == null) {
                        throw new IOException("Failed to get system directory");
                    }
                    this.systemDirectory = new Path(dir);
                    this.systemFS = this.systemDirectory.getFileSystem(this.fConf);
                }
                HeartbeatResponse heartbeatResponse = this.transmitHeartBeat(now);
                lastHeartbeat = System.currentTimeMillis();
                Set<JobID> jobs = heartbeatResponse.getRecoveredJobs();
                if (jobs.size() > 0) {
                    TaskTracker e = this;
                    synchronized (e) {
                        for (JobID job : jobs) {
                            Map<JobID, RunningJob> map = this.runningJobs;
                            synchronized (map) {
                                RunningJob rjob = this.runningJobs.get(job);
                                if (rjob != null) {
                                    RunningJob runningJob = rjob;
                                    synchronized (runningJob) {
                                        FetchStatus f = rjob.getFetchStatus();
                                        if (f != null) {
                                            f.reset();
                                        }
                                    }
                                }
                            }
                        }
                        Set<TaskAttemptID> i$ = this.shouldReset;
                        synchronized (i$) {
                            for (Map.Entry<TaskAttemptID, TaskInProgress> entry : this.runningTasks.entrySet()) {
                                if (entry.getValue().getStatus().getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                                this.shouldReset.add(entry.getKey());
                            }
                        }
                    }
                }
                TaskTrackerAction[] actions = heartbeatResponse.getActions();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got heartbeatResponse from JobTracker with responseId: " + heartbeatResponse.getResponseId() + " and " + (actions != null ? actions.length : 0) + " actions"));
                }
                if (this.reinitTaskTracker(actions)) {
                    return State.STALE;
                }
                this.heartbeatInterval = heartbeatResponse.getHeartbeatInterval();
                this.justStarted = false;
                this.justInited = false;
                if (actions != null) {
                    for (TaskTrackerAction action : actions) {
                        if (action instanceof LaunchTaskAction) {
                            this.addToTaskQueue((LaunchTaskAction)action);
                            continue;
                        }
                        if (action instanceof CommitTaskAction) {
                            CommitTaskAction commitAction = (CommitTaskAction)action;
                            if (this.commitResponses.contains(commitAction.getTaskID())) continue;
                            LOG.info((Object)("Received commit task action for " + commitAction.getTaskID()));
                            this.commitResponses.add(commitAction.getTaskID());
                            continue;
                        }
                        this.tasksToCleanup.put(action);
                    }
                }
                this.markUnresponsiveTasks();
                this.killOverflowingTasks();
                if (this.acceptNewTasks || !this.isIdle()) continue;
                this.acceptNewTasks = true;
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted. Closing down.");
                return State.INTERRUPTED;
            }
            catch (DiskChecker.DiskErrorException de) {
                msg = "Exiting task tracker for disk error:\n" + StringUtils.stringifyException(de);
                LOG.error((Object)msg);
                TaskTracker taskTracker = this;
                synchronized (taskTracker) {
                    this.jobClient.reportTaskTrackerError(this.taskTrackerName, "DiskErrorException", msg);
                }
                return State.STALE;
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (!DisallowedTaskTrackerException.class.getName().equals(reClass)) continue;
                LOG.info((Object)"Tasktracker disallowed by JobTracker.");
                return State.DENIED;
            }
            catch (Exception except) {
                msg = "Caught exception: " + StringUtils.stringifyException(except);
                LOG.error((Object)msg);
            }
        }
        return State.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeartbeatResponse transmitHeartBeat(long now) throws IOException {
        long localMinSpaceStart;
        boolean askForNewTask;
        boolean sendCounters;
        if (now > this.previousUpdate + 60000L) {
            sendCounters = true;
            this.previousUpdate = now;
        } else {
            sendCounters = false;
        }
        if (this.status == null) {
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.status = new TaskTrackerStatus(this.taskTrackerName, this.localHostname, this.httpPort, this.cloneAndResetRunningTaskStatuses(sendCounters), this.failures, this.maxCurrentMapTasks, this.maxCurrentReduceTasks);
            }
        } else {
            LOG.info((Object)("Resending 'status' to '" + this.jobTrackAddr.getHostName() + "' with reponseId '" + this.heartbeatResponseId));
        }
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            askForNewTask = (this.status.countMapTasks() < this.maxCurrentMapTasks || this.status.countReduceTasks() < this.maxCurrentReduceTasks) && this.acceptNewTasks;
            localMinSpaceStart = this.minSpaceStart;
        }
        if (askForNewTask) {
            TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
            askForNewTask = this.enoughFreeSpace(localMinSpaceStart);
            long freeDiskSpace = this.getFreeSpace();
            long totVmem = this.getTotalVirtualMemoryOnTT();
            long totPmem = this.getTotalPhysicalMemoryOnTT();
            long rsrvdVmem = this.getReservedVirtualMemory();
            long rsrvdPmem = this.getReservedPhysicalMemory();
            this.status.getResourceStatus().setAvailableSpace(freeDiskSpace);
            this.status.getResourceStatus().setTotalVirtualMemory(totVmem);
            this.status.getResourceStatus().setTotalPhysicalMemory(totPmem);
            this.status.getResourceStatus().setReservedVirtualMemory(rsrvdVmem);
            this.status.getResourceStatus().setReservedPhysicalMemory(rsrvdPmem);
        }
        HeartbeatResponse heartbeatResponse = this.jobClient.heartbeat(this.status, this.justStarted, this.justInited, askForNewTask, this.heartbeatResponseId);
        this.heartbeatResponseId = heartbeatResponse.getResponseId();
        TaskTracker taskTracker2 = this;
        synchronized (taskTracker2) {
            for (TaskStatus taskStatus : this.status.getTaskReports()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.inTaskCleanupPhase()) continue;
                if (taskStatus.getIsMap()) {
                    --this.mapTotal;
                } else {
                    --this.reduceTotal;
                }
                try {
                    this.myInstrumentation.completeTask(taskStatus.getTaskID());
                }
                catch (MetricsException me) {
                    LOG.warn((Object)("Caught: " + StringUtils.stringifyException(me)));
                }
                this.runningTasks.remove(taskStatus.getTaskID());
            }
            for (TaskInProgress tip : this.runningTasks.values()) {
                tip.getStatus().clearStatus();
            }
        }
        this.status = null;
        return heartbeatResponse;
    }

    long getTotalVirtualMemoryOnTT() {
        return this.totalVirtualMemoryOnTT;
    }

    long getTotalPhysicalMemoryOnTT() {
        return this.totalPmemOnTT;
    }

    long getReservedVirtualMemory() {
        return this.reservedVirtualMemory;
    }

    long getReservedPhysicalMemory() {
        return this.reservedPmem;
    }

    long getLimitMaxVMemPerTask() {
        return this.limitMaxVmPerTask;
    }

    long getVirtualMemoryForTask(JobConf conf) {
        long vMemForTask = this.normalizeMemoryConfigValue(conf.getMaxVirtualMemoryForTask());
        if (vMemForTask == -1L) {
            vMemForTask = this.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.default.maxvmem", -1L));
        }
        return vMemForTask;
    }

    private boolean reinitTaskTracker(TaskTrackerAction[] actions) {
        if (actions != null) {
            for (TaskTrackerAction action : actions) {
                if (action.getActionId() != TaskTrackerAction.ActionType.REINIT_TRACKER) continue;
                LOG.info((Object)"Recieved RenitTrackerAction from JobTracker");
                return true;
            }
        }
        return false;
    }

    private synchronized void markUnresponsiveTasks() throws IOException {
        long now = System.currentTimeMillis();
        for (TaskInProgress tip : this.runningTasks.values()) {
            long timeSinceLastReport;
            long jobTaskTimeout;
            if (tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING && !tip.isCleaningup() || (jobTaskTimeout = tip.getTaskTimeout()) == 0L || (timeSinceLastReport = now - tip.getLastProgressReport()) <= jobTaskTimeout || tip.wasKilled) continue;
            String msg = "Task " + tip.getTask().getTaskID() + " failed to report status for " + timeSinceLastReport / 1000L + " seconds. Killing!";
            LOG.info((Object)(tip.getTask().getTaskID() + ": " + msg));
            ReflectionUtils.logThreadInfo(LOG, "lost task", 30L);
            tip.reportDiagnosticInfo(msg);
            this.myInstrumentation.timedoutTask(tip.getTask().getTaskID());
            this.purgeTask(tip, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void purgeJob(KillJobAction action) throws IOException {
        JobID jobId = action.getJobID();
        LOG.info((Object)("Received 'KillJobAction' for job: " + jobId));
        RunningJob rjob = null;
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob == null) {
            LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
        } else {
            map = rjob;
            synchronized (map) {
                for (TaskInProgress tip : rjob.tasks) {
                    tip.jobHasFinished(false);
                    Task t = tip.getTask();
                    if (!t.isMapTask()) continue;
                    this.indexCache.removeMap(tip.getTask().getTaskID().toString());
                }
                if (!rjob.keepJobFiles) {
                    this.directoryCleanupThread.addToQueue(this.fConf, this.getLocalFiles(this.fConf, TaskTracker.getLocalJobDir(rjob.getJobID().toString())));
                }
                rjob.tasks.clear();
            }
        }
        map = this.runningJobs;
        synchronized (map) {
            this.runningJobs.remove(jobId);
        }
    }

    private void purgeTask(TaskInProgress tip, boolean wasFailure) throws IOException {
        if (tip != null) {
            LOG.info((Object)("About to purge task: " + tip.getTask().getTaskID()));
            this.removeTaskFromJob(tip.getTask().getJobID(), tip);
            tip.jobHasFinished(wasFailure);
            if (tip.getTask().isMapTask()) {
                this.indexCache.removeMap(tip.getTask().getTaskID().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOverflowingTasks() throws IOException {
        long localMinSpaceKill;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            localMinSpaceKill = this.minSpaceKill;
        }
        if (!this.enoughFreeSpace(localMinSpaceKill)) {
            this.acceptNewTasks = false;
            taskTracker = this;
            synchronized (taskTracker) {
                TaskInProgress killMe = this.findTaskToKill(null);
                if (killMe != null) {
                    String msg = "Tasktracker running out of space. Killing task.";
                    LOG.info((Object)(killMe.getTask().getTaskID() + ": " + msg));
                    killMe.reportDiagnosticInfo(msg);
                    this.purgeTask(killMe, false);
                }
            }
        }
    }

    synchronized TaskInProgress findTaskToKill(List<TaskAttemptID> tasksToExclude) {
        TaskInProgress killMe = null;
        for (TaskInProgress tip : this.runningTasks.values()) {
            if (tasksToExclude != null && tasksToExclude.contains(tip.getTask().getTaskID()) || tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING || tip.wasKilled) continue;
            if (killMe == null) {
                killMe = tip;
                continue;
            }
            if (!tip.getTask().isMapTask()) {
                if (!killMe.getTask().isMapTask() && !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
                killMe = tip;
                continue;
            }
            if (!killMe.getTask().isMapTask() || !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
            killMe = tip;
        }
        return killMe;
    }

    private boolean enoughFreeSpace(long minSpace) throws IOException {
        if (minSpace == 0L) {
            return true;
        }
        return minSpace < this.getFreeSpace();
    }

    private long getFreeSpace() throws IOException {
        long biggestSeenSoFar = 0L;
        String[] localDirs = this.fConf.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            DF df = null;
            if (this.localDirsDf.containsKey(localDirs[i])) {
                df = this.localDirsDf.get(localDirs[i]);
            } else {
                df = new DF(new File(localDirs[i]), this.fConf);
                this.localDirsDf.put(localDirs[i], df);
            }
            long availOnThisVol = df.getAvailable();
            if (availOnThisVol <= biggestSeenSoFar) continue;
            biggestSeenSoFar = availOnThisVol;
        }
        return biggestSeenSoFar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long tryToGetOutputSize(TaskAttemptID taskId, JobConf conf) {
        try {
            TaskInProgress tip;
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                tip = this.tasks.get(taskId);
            }
            if (tip == null) {
                return -1L;
            }
            if (!tip.getTask().isMapTask() || tip.getRunState() != TaskStatus.State.SUCCEEDED) {
                return -1L;
            }
            MapOutputFile mapOutputFile = new MapOutputFile();
            mapOutputFile.setJobId(taskId.getJobID());
            mapOutputFile.setConf(conf);
            Path tmp_output = mapOutputFile.getOutputFile(taskId);
            if (tmp_output == null) {
                return 0L;
            }
            LocalFileSystem localFS = FileSystem.getLocal(conf);
            FileStatus stat = ((FileSystem)localFS).getFileStatus(tmp_output);
            if (stat == null) {
                return 0L;
            }
            return stat.getLen();
        }
        catch (IOException e) {
            LOG.info((Object)e);
            return -1L;
        }
    }

    public JvmManager getJvmManagerInstance() {
        return this.jvmManager;
    }

    private void addToTaskQueue(LaunchTaskAction action) {
        if (action.getTask().isMapTask()) {
            this.mapLauncher.addToTaskQueue(action);
        } else {
            this.reduceLauncher.addToTaskQueue(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInProgress registerTask(LaunchTaskAction action, TaskLauncher launcher) {
        Task t = action.getTask();
        LOG.info((Object)("LaunchTaskAction (registerTask): " + t.getTaskID() + " task's state:" + (Object)((Object)t.getState())));
        TaskInProgress tip = new TaskInProgress(t, this.fConf, launcher);
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            this.tasks.put(t.getTaskID(), tip);
            this.runningTasks.put(t.getTaskID(), tip);
            boolean isMap = t.isMapTask();
            if (isMap) {
                ++this.mapTotal;
            } else {
                ++this.reduceTotal;
            }
        }
        return tip;
    }

    private void startNewTask(TaskInProgress tip) {
        block4: {
            try {
                this.localizeJob(tip);
            }
            catch (Throwable e) {
                String msg = "Error initializing " + tip.getTask().getTaskID() + ":\n" + StringUtils.stringifyException(e);
                LOG.warn((Object)msg);
                tip.reportDiagnosticInfo(msg);
                try {
                    tip.kill(true);
                    tip.cleanup(true);
                }
                catch (IOException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskID() + ":\n" + StringUtils.stringifyException(ie2)));
                }
                if (!(e instanceof Error)) break block4;
                throw (Error)e;
            }
        }
    }

    void addToMemoryManager(TaskAttemptID attemptId, JobConf conf, String pidFile) {
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager.addTask(attemptId, this.getVirtualMemoryForTask(conf), pidFile);
        }
    }

    void removeFromMemoryManager(TaskAttemptID attemptId) {
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager.removeTask(attemptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.startCleanupThreads();
            boolean denied = false;
            while (true) {
                if (!this.running || this.shuttingDown || denied) {
                    if (!denied) return;
                    this.shutdown();
                    return;
                }
                boolean staleState = false;
                try {
                    while (this.running && !staleState && !this.shuttingDown && !denied) {
                        try {
                            State osState = this.offerService();
                            if (osState == State.STALE) {
                                staleState = true;
                                continue;
                            }
                            if (osState != State.DENIED) continue;
                            denied = true;
                        }
                        catch (Exception ex) {
                            if (this.shuttingDown) continue;
                            LOG.info((Object)("Lost connection to JobTracker [" + this.jobTrackAddr + "].  Retrying..."), (Throwable)ex);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
                finally {
                    this.close();
                }
                if (this.shuttingDown) {
                    return;
                }
                LOG.warn((Object)"Reinitializing local state");
                this.initialize();
            }
        }
        catch (IOException iex) {
            LOG.error((Object)("Got fatal exception while reinitializing TaskTracker: " + StringUtils.stringifyException(iex)));
            return;
        }
    }

    @Override
    public synchronized JvmTask getTask(JVMId jvmId) throws IOException {
        LOG.debug((Object)("JVM with ID : " + jvmId + " asked for a task"));
        if (!this.jvmManager.isJvmKnown(jvmId)) {
            LOG.info((Object)("Killing unknown JVM " + jvmId));
            return new JvmTask(null, true);
        }
        RunningJob rjob = this.runningJobs.get(jvmId.getJobId());
        if (rjob == null) {
            LOG.info((Object)("Killing JVM " + jvmId + " since job " + jvmId.getJobId() + " is dead"));
            this.jvmManager.killJvm(jvmId);
            return new JvmTask(null, true);
        }
        TaskInProgress tip = this.jvmManager.getTaskForJvm(jvmId);
        if (tip == null) {
            return new JvmTask(null, false);
        }
        if (this.tasks.get(tip.getTask().getTaskID()) != null) {
            LOG.info((Object)("JVM with ID: " + jvmId + " given task: " + tip.getTask().getTaskID()));
            return new JvmTask(tip.getTask(), false);
        }
        LOG.info((Object)("Killing JVM with ID: " + jvmId + " since scheduled task: " + tip.getTask().getTaskID() + " is " + (Object)((Object)tip.taskStatus.getRunState())));
        return new JvmTask(null, true);
    }

    @Override
    public synchronized boolean statusUpdate(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportProgress(taskStatus);
            return true;
        }
        LOG.warn((Object)("Progress from unknown child task: " + taskid));
        return false;
    }

    @Override
    public synchronized void reportDiagnosticInfo(TaskAttemptID taskid, String info) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportNextRecordRange(range);
        } else {
            LOG.warn((Object)("reportNextRecordRange from unknown child task: " + taskid + ". " + "Ignored."));
        }
    }

    @Override
    public synchronized boolean ping(TaskAttemptID taskid) throws IOException {
        return this.tasks.get(taskid) != null;
    }

    @Override
    public synchronized void commitPending(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException {
        LOG.info((Object)("Task " + taskid + " is in commit-pending," + "" + " task state:" + (Object)((Object)taskStatus.getRunState())));
        this.statusUpdate(taskid, taskStatus);
        this.reportTaskFinished(taskid, true);
    }

    @Override
    public synchronized boolean canCommit(TaskAttemptID taskid) {
        return this.commitResponses.contains(taskid);
    }

    @Override
    public synchronized void done(TaskAttemptID taskid) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        this.commitResponses.remove(taskid);
        if (tip != null) {
            tip.reportDone();
        } else {
            LOG.warn((Object)("Unknown child task done: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void shuffleError(TaskAttemptID taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to Shuffle Failure: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("Shuffle Error: " + message);
        this.purgeTask(tip, true);
    }

    @Override
    public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("FSError: " + message);
        this.purgeTask(tip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
        TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
        Set<TaskAttemptID> set = this.shouldReset;
        synchronized (set) {
            if (this.shouldReset.remove(id)) {
                return new MapTaskCompletionEventsUpdate(mapEvents, true);
            }
        }
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob != null) {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    if (f != null) {
                        mapEvents = f.getMapEvents(fromEventId, maxLocs);
                    }
                }
            }
        }
        return new MapTaskCompletionEventsUpdate(mapEvents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTaskFinished(TaskAttemptID taskid, boolean commitPending) {
        TaskInProgress tip;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            tip = this.tasks.get(taskid);
        }
        if (tip != null) {
            if (!commitPending) {
                tip.reportTaskFinished();
            }
        } else {
            LOG.warn((Object)("Unknown child task finished: " + taskid + ". Ignored."));
        }
    }

    public synchronized void mapOutputLost(TaskAttemptID taskid, String errorMsg) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.mapOutputLost(errorMsg);
        } else {
            LOG.warn((Object)("Unknown child with bad map output: " + taskid + ". Ignored."));
        }
    }

    String getName() {
        return this.taskTrackerName;
    }

    private synchronized List<TaskStatus> cloneAndResetRunningTaskStatuses(boolean sendCounters) {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            TaskStatus status = tip.getStatus();
            status.setIncludeCounters(sendCounters);
            status.setOutputSize(this.tryToGetOutputSize(status.getTaskID(), this.fConf));
            if (status.getRunState() != TaskStatus.State.RUNNING) {
                status.setIncludeCounters(true);
            }
            result.add((TaskStatus)status.clone());
            status.clearStatus();
        }
        return result;
    }

    synchronized List<TaskStatus> getRunningTaskStatuses() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            result.add(tip.getStatus());
        }
        return result;
    }

    synchronized List<TaskStatus> getNonRunningTasks() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<TaskAttemptID, TaskInProgress> task : this.tasks.entrySet()) {
            if (this.runningTasks.containsKey(task.getKey())) continue;
            result.add(task.getValue().getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<TaskStatus> getTasksFromRunningJobs() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<JobID, RunningJob> item : this.runningJobs.entrySet()) {
            RunningJob rjob;
            RunningJob runningJob = rjob = item.getValue();
            synchronized (runningJob) {
                for (TaskInProgress tip : rjob.tasks) {
                    result.add(tip.getStatus());
                }
            }
        }
        return result;
    }

    JobConf getJobConf() {
        return this.fConf;
    }

    private static void checkLocalDirs(String[] localDirs) throws DiskChecker.DiskErrorException {
        boolean writable = false;
        if (localDirs != null) {
            for (int i = 0; i < localDirs.length; ++i) {
                try {
                    DiskChecker.checkDir(new File(localDirs[i]));
                    writable = true;
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    LOG.warn((Object)("Task Tracker local " + e.getMessage()));
                }
            }
        }
        if (!writable) {
            throw new DiskChecker.DiskErrorException("all local directories are not writable");
        }
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty() && this.tasksToCleanup.isEmpty();
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(TaskTracker.class, argv, LOG);
        if (argv.length != 0) {
            System.out.println("usage: TaskTracker");
            System.exit(-1);
        }
        try {
            JobConf conf = new JobConf();
            ReflectionUtils.setContentionTracing(conf.getBoolean("tasktracker.contention.tracking", false));
            new TaskTracker(conf).run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can not start task tracker because " + StringUtils.stringifyException(e)));
            System.exit(-1);
        }
    }

    private Path[] getLocalFiles(JobConf conf, String subdir) throws IOException {
        String[] localDirs = conf.getLocalDirs();
        Path[] paths = new Path[localDirs.length];
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        for (int i = 0; i < localDirs.length; ++i) {
            paths[i] = new Path(localDirs[i], subdir);
            paths[i] = paths[i].makeQualified(localFs);
        }
        return paths;
    }

    int getMaxCurrentMapTasks() {
        return this.maxCurrentMapTasks;
    }

    int getMaxCurrentReduceTasks() {
        return this.maxCurrentReduceTasks;
    }

    public boolean isTaskMemoryManagerEnabled() {
        return this.taskMemoryManagerEnabled;
    }

    public TaskMemoryManagerThread getTaskMemoryManager() {
        return this.taskMemoryManager;
    }

    private long normalizeMemoryConfigValue(long val) {
        if (val < 0L) {
            val = -1L;
        }
        return val;
    }

    private void initializeMemoryManagement() {
        Class<MemoryCalculatorPlugin> clazz = this.fConf.getClass(MAPRED_TASKTRACKER_MEMORY_CALCULATOR_PLUGIN_PROPERTY, null, MemoryCalculatorPlugin.class);
        MemoryCalculatorPlugin memoryCalculatorPlugin = MemoryCalculatorPlugin.getMemoryCalculatorPlugin(clazz, this.fConf);
        LOG.info((Object)(" Using MemoryCalculatorPlugin : " + memoryCalculatorPlugin));
        if (memoryCalculatorPlugin != null) {
            this.totalVirtualMemoryOnTT = memoryCalculatorPlugin.getVirtualMemorySize();
            if (this.totalVirtualMemoryOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalVmem could not be calculated. Setting it to -1");
                this.totalVirtualMemoryOnTT = -1L;
            }
            this.totalPmemOnTT = memoryCalculatorPlugin.getPhysicalMemorySize();
            if (this.totalPmemOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalPmem could not be calculated. Setting it to -1");
                this.totalPmemOnTT = -1L;
            }
        }
        this.reservedVirtualMemory = this.normalizeMemoryConfigValue(this.fConf.getLong(MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY, -1L));
        this.reservedPmem = this.normalizeMemoryConfigValue(this.fConf.getLong(MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY, -1L));
        this.defaultMaxVmPerTask = this.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.default.maxvmem", -1L));
        this.limitMaxVmPerTask = this.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.limit.maxvmem", -1L));
        this.setTaskMemoryManagerEnabledFlag();
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager = new TaskMemoryManagerThread(this);
            this.taskMemoryManager.setDaemon(true);
            this.taskMemoryManager.start();
        }
    }

    private void setTaskMemoryManagerEnabledFlag() {
        long reservedVmem;
        if (!ProcfsBasedProcessTree.isAvailable()) {
            LOG.info((Object)"ProcessTree implementation is missing on this system. TaskMemoryManager is disabled.");
            this.taskMemoryManagerEnabled = false;
            return;
        }
        StringBuilder mesg = new StringBuilder();
        long totalVmemOnTT = this.getTotalVirtualMemoryOnTT();
        if (totalVmemOnTT == -1L) {
            mesg.append("TaskTracker's totalVmem could not be calculated.\n");
            this.taskMemoryManagerEnabled = false;
        }
        if ((reservedVmem = this.getReservedVirtualMemory()) == -1L) {
            mesg.append("TaskTracker's reservedVmem is not configured.\n");
            this.taskMemoryManagerEnabled = false;
        }
        if (this.defaultMaxVmPerTask == -1L) {
            mesg.append("TaskTracker's defaultMaxVmPerTask is not configured.\n");
            this.taskMemoryManagerEnabled = false;
        }
        if (this.limitMaxVmPerTask == -1L) {
            mesg.append("TaskTracker's limitMaxVmPerTask is not configured.\n");
            this.taskMemoryManagerEnabled = false;
        }
        if (!this.taskMemoryManagerEnabled) {
            LOG.warn((Object)(mesg.toString() + "TaskMemoryManager is disabled."));
            return;
        }
        if (this.defaultMaxVmPerTask > this.limitMaxVmPerTask) {
            mesg.append("defaultMaxVmPerTask is mis-configured. It shouldn't be greater than limitMaxVmPerTask. ");
            this.taskMemoryManagerEnabled = false;
        }
        if (reservedVmem > totalVmemOnTT) {
            mesg.append("reservedVmemOnTT is mis-configured. It shouldn't be greater than totalVmemOnTT");
            this.taskMemoryManagerEnabled = false;
        }
        if (!this.taskMemoryManagerEnabled) {
            LOG.warn((Object)(mesg.toString() + "TaskMemoryManager is disabled."));
            return;
        }
        this.taskMemoryManagerEnabled = true;
    }

    synchronized void cleanUpOverMemoryTask(TaskAttemptID tid, boolean wasFailure, String diagnosticMsg) {
        TaskInProgress tip = this.runningTasks.get(tid);
        if (tip != null) {
            tip.reportDiagnosticInfo(diagnosticMsg);
            try {
                this.purgeTask(tip, wasFailure);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Couldn't purge the task of " + tid + ". Error : " + ioe));
            }
        }
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
        LOG = LogFactory.getLog(TaskTracker.class);
        ClientTraceLog = LogFactory.getLog((String)(TaskTracker.class.getName() + ".clienttrace"));
        r = new Random();
    }

    public static class MapOutputServlet
    extends HttpServlet {
        private static final int MAX_BYTES_TO_READ = 65536;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ShuffleServerMetrics shuffleMetrics;
            long totalRead;
            ServletOutputStream outStream;
            String mapId;
            block13: {
                mapId = request.getParameter("map");
                String reduceId = request.getParameter("reduce");
                String jobId = request.getParameter("job");
                if (jobId == null) {
                    throw new IOException("job parameter is required");
                }
                if (mapId == null || reduceId == null) {
                    throw new IOException("map and reduce parameters are required");
                }
                ServletContext context = this.getServletContext();
                int reduce = Integer.parseInt(reduceId);
                byte[] buffer = new byte[65536];
                boolean isInputException = true;
                outStream = null;
                FilterInputStream mapOutputIn = null;
                totalRead = 0L;
                shuffleMetrics = (ShuffleServerMetrics)context.getAttribute("shuffleServerMetrics");
                TaskTracker tracker = (TaskTracker)context.getAttribute("task.tracker");
                try {
                    shuffleMetrics.serverHandlerBusy();
                    outStream = response.getOutputStream();
                    JobConf conf = (JobConf)context.getAttribute("conf");
                    LocalDirAllocator lDirAlloc = (LocalDirAllocator)context.getAttribute("localDirAllocator");
                    FileSystem rfs = ((LocalFileSystem)context.getAttribute("local.file.system")).getRaw();
                    Path indexFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(jobId, mapId) + "/file.out.index", conf);
                    Path mapOutputFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(jobId, mapId) + "/file.out", conf);
                    IndexRecord info = tracker.indexCache.getIndexInformation(mapId, reduce, indexFileName);
                    response.setHeader("Raw-Map-Output-Length", Long.toString(info.rawLength));
                    response.setHeader("Map-Output-Length", Long.toString(info.partLength));
                    response.setBufferSize(65536);
                    mapOutputIn = rfs.open(mapOutputFileName);
                    ((FSDataInputStream)mapOutputIn).seek(info.startOffset);
                    long rem = info.partLength;
                    int len = ((DataInputStream)mapOutputIn).read(buffer, 0, (int)Math.min(rem, 65536L));
                    while (rem > 0L && len >= 0) {
                        rem -= (long)len;
                        try {
                            shuffleMetrics.outputBytes(len);
                            outStream.write(buffer, 0, len);
                            outStream.flush();
                        }
                        catch (IOException ie) {
                            isInputException = false;
                            throw ie;
                        }
                        totalRead += (long)len;
                        len = ((DataInputStream)mapOutputIn).read(buffer, 0, (int)Math.min(rem, 65536L));
                    }
                    LOG.info((Object)("Sent out " + totalRead + " bytes for reduce: " + reduce + " from map: " + mapId + " given " + info.partLength + "/" + info.rawLength));
                    if (null == mapOutputIn) break block13;
                }
                catch (IOException ie) {
                    try {
                        Log log = (Log)context.getAttribute("log");
                        String errorMsg = "getMapOutput(" + mapId + "," + reduceId + ") failed :\n" + StringUtils.stringifyException(ie);
                        log.warn((Object)errorMsg);
                        if (isInputException) {
                            tracker.mapOutputLost(TaskAttemptID.forName(mapId), errorMsg);
                        }
                        response.sendError(410, errorMsg);
                        shuffleMetrics.failedOutput();
                        throw ie;
                    }
                    catch (Throwable throwable) {
                        if (null != mapOutputIn) {
                            mapOutputIn.close();
                        }
                        shuffleMetrics.serverHandlerFree();
                        if (ClientTraceLog.isInfoEnabled()) {
                            ClientTraceLog.info((Object)String.format(TaskTracker.MR_CLIENTTRACE_FORMAT, request.getLocalAddr() + ":" + request.getLocalPort(), request.getRemoteAddr() + ":" + request.getRemotePort(), totalRead, "MAPRED_SHUFFLE", mapId));
                        }
                        throw throwable;
                    }
                }
                mapOutputIn.close();
            }
            shuffleMetrics.serverHandlerFree();
            if (ClientTraceLog.isInfoEnabled()) {
                ClientTraceLog.info((Object)String.format(TaskTracker.MR_CLIENTTRACE_FORMAT, request.getLocalAddr() + ":" + request.getLocalPort(), request.getRemoteAddr() + ":" + request.getRemotePort(), totalRead, "MAPRED_SHUFFLE", mapId));
            }
            outStream.close();
            shuffleMetrics.successOutput();
        }
    }

    static class RunningJob {
        private JobID jobid;
        private JobConf jobConf;
        volatile Set<TaskInProgress> tasks;
        boolean localized;
        boolean keepJobFiles;
        FetchStatus f;

        RunningJob(JobID jobid) {
            this.jobid = jobid;
            this.localized = false;
            this.tasks = new HashSet<TaskInProgress>();
            this.keepJobFiles = false;
        }

        JobID getJobID() {
            return this.jobid;
        }

        void setFetchStatus(FetchStatus f) {
            this.f = f;
        }

        FetchStatus getFetchStatus() {
            return this.f;
        }
    }

    class TaskInProgress {
        Task task;
        long lastProgressReport;
        StringBuffer diagnosticInfo = new StringBuffer();
        private TaskRunner runner;
        volatile boolean done = false;
        volatile boolean wasKilled = false;
        private JobConf defaultJobConf;
        private JobConf localJobConf;
        private boolean keepFailedTaskFiles;
        private boolean alwaysKeepTaskFiles;
        private TaskStatus taskStatus;
        private long taskTimeout;
        private String debugCommand;
        private volatile boolean slotTaken = false;
        private TaskLauncher launcher;

        public TaskInProgress(Task task, JobConf conf) {
            this(task, conf, null);
        }

        public TaskInProgress(Task task, JobConf conf, TaskLauncher launcher) {
            this.task = task;
            this.launcher = launcher;
            this.lastProgressReport = System.currentTimeMillis();
            this.defaultJobConf = conf;
            this.localJobConf = null;
            this.taskStatus = TaskStatus.createTaskStatus(task.isMapTask(), task.getTaskID(), 0.0f, task.getState(), this.diagnosticInfo.toString(), "initializing", TaskTracker.this.getName(), task.isTaskCleanupTask() ? TaskStatus.Phase.CLEANUP : (task.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE), task.getCounters());
            this.taskTimeout = 600000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void localizeTask(Task task) throws IOException {
            Path cwd;
            Path localTaskDir = TaskTracker.this.lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalTaskDir(task.getJobID().toString(), task.getTaskID().toString(), task.isTaskCleanupTask()), this.defaultJobConf);
            LocalFileSystem localFs = FileSystem.getLocal(TaskTracker.this.fConf);
            if (!((FileSystem)localFs).mkdirs(localTaskDir)) {
                throw new IOException("Mkdirs failed to create " + localTaskDir.toString());
            }
            String workDir = TaskTracker.this.lDirAlloc.getLocalPathToRead(TaskTracker.getLocalJobDir(task.getJobID().toString()) + "/" + "work", this.defaultJobConf).toString();
            String link = localTaskDir.getParent().toString() + "/" + "work";
            File flink = new File(link);
            if (!flink.exists()) {
                FileUtil.symLink(workDir, link);
            }
            if (!((FileSystem)localFs).mkdirs(cwd = TaskTracker.this.lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalTaskDir(task.getJobID().toString(), task.getTaskID().toString(), task.isTaskCleanupTask()) + "/" + "work", this.defaultJobConf))) {
                throw new IOException("Mkdirs failed to create " + cwd.toString());
            }
            Path localTaskFile = new Path(localTaskDir, "job.xml");
            task.setJobFile(localTaskFile.toString());
            this.localJobConf.set("mapred.local.dir", TaskTracker.this.fConf.get("mapred.local.dir"));
            if (TaskTracker.this.fConf.get("slave.host.name") != null) {
                this.localJobConf.set("slave.host.name", TaskTracker.this.fConf.get("slave.host.name"));
            }
            this.localJobConf.set("mapred.task.id", task.getTaskID().toString());
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            task.localizeConfiguration(this.localJobConf);
            List<String[]> staticResolutions = NetUtils.getAllStaticResolutions();
            if (staticResolutions != null && staticResolutions.size() > 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < staticResolutions.size(); ++i) {
                    String[] hostToResolved = staticResolutions.get(i);
                    str.append(hostToResolved[0] + "=" + hostToResolved[1]);
                    if (i == staticResolutions.size() - 1) continue;
                    str.append(',');
                }
                this.localJobConf.set("hadoop.net.static.resolutions", str.toString());
            }
            this.debugCommand = task.isMapTask() ? this.localJobConf.getMapDebugScript() : this.localJobConf.getReduceDebugScript();
            String keepPattern = this.localJobConf.getKeepTaskFilesPattern();
            this.alwaysKeepTaskFiles = keepPattern != null ? Pattern.matches(keepPattern, task.getTaskID().toString()) : false;
            if (this.debugCommand != null || this.localJobConf.getProfileEnabled() || this.alwaysKeepTaskFiles || this.keepFailedTaskFiles) {
                this.localJobConf.setNumTasksToExecutePerJvm(1);
            }
            if (TaskTracker.this.isTaskMemoryManagerEnabled()) {
                this.localJobConf.setBoolean("task.memory.mgmt.enabled", true);
            }
            FSDataOutputStream out = localFs.create(localTaskFile);
            try {
                this.localJobConf.writeXml(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            task.setConf(this.localJobConf);
        }

        public Task getTask() {
            return this.task;
        }

        public TaskRunner getTaskRunner() {
            return this.runner;
        }

        public synchronized void setJobConf(JobConf lconf) {
            this.localJobConf = lconf;
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            this.taskTimeout = this.localJobConf.getLong("mapred.task.timeout", 600000L);
        }

        public synchronized JobConf getJobConf() {
            return this.localJobConf;
        }

        public synchronized TaskStatus getStatus() {
            this.taskStatus.setDiagnosticInfo(this.diagnosticInfo.toString());
            if (this.diagnosticInfo.length() > 0) {
                this.diagnosticInfo = new StringBuffer();
            }
            return this.taskStatus;
        }

        public synchronized void launchTask() throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.localizeTask(this.task);
                if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                    this.taskStatus.setRunState(TaskStatus.State.RUNNING);
                }
                this.runner = this.task.createRunner(TaskTracker.this, this);
                this.runner.start();
                this.taskStatus.setStartTime(System.currentTimeMillis());
            } else {
                LOG.info((Object)("Not launching task: " + this.task.getTaskID() + " since it's state is " + (Object)((Object)this.taskStatus.getRunState())));
            }
        }

        boolean isCleaningup() {
            return this.taskStatus.inTaskCleanupPhase();
        }

        public synchronized void reportProgress(TaskStatus taskStatus) {
            LOG.info((Object)(this.task.getTaskID() + " " + taskStatus.getProgress() + "% " + taskStatus.getStateString()));
            if (this.done || this.taskStatus.getRunState() != TaskStatus.State.RUNNING && this.taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING && !this.isCleaningup() || (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) && taskStatus.getRunState() == TaskStatus.State.RUNNING) {
                LOG.info((Object)(this.task.getTaskID() + " Ignoring status-update since " + (this.done ? "task is 'done'" : "runState: " + (Object)((Object)this.taskStatus.getRunState()))));
                return;
            }
            this.taskStatus.statusUpdate(taskStatus);
            this.lastProgressReport = System.currentTimeMillis();
        }

        public long getLastProgressReport() {
            return this.lastProgressReport;
        }

        public TaskStatus.State getRunState() {
            return this.taskStatus.getRunState();
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public synchronized void reportDiagnosticInfo(String info) {
            this.diagnosticInfo.append(info);
        }

        public synchronized void reportNextRecordRange(SortedRanges.Range range) {
            this.taskStatus.setNextRecordRange(range);
        }

        public synchronized void reportDone() {
            if (this.isCleaningup()) {
                if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            } else {
                this.taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
            }
            this.taskStatus.setProgress(1.0f);
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            this.done = true;
            TaskTracker.this.jvmManager.taskFinished(this.runner);
            this.runner.signalDone();
            LOG.info((Object)("Task " + this.task.getTaskID() + " is done."));
            LOG.info((Object)("reported output size for " + this.task.getTaskID() + "  was " + this.taskStatus.getOutputSize()));
        }

        public boolean wasKilled() {
            return this.wasKilled;
        }

        void reportTaskFinished() {
            this.taskFinished();
            this.releaseSlot();
        }

        private void setTaskFailState(boolean wasFailure) {
            if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            } else if (this.task.isMapOrReduce() && this.taskStatus.getPhase() != TaskStatus.Phase.CLEANUP) {
                if (wasFailure) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED_UNCLEAN);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED_UNCLEAN);
                }
            } else if (wasFailure) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished() {
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            boolean needCleanup = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.done || !this.wasKilled) {
                    TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
                }
                if (!this.done) {
                    if (!this.wasKilled) {
                        TaskTracker.this.failures += 1;
                        this.setTaskFailState(true);
                        if (this.debugCommand != null) {
                            String taskStdout = "";
                            String taskStderr = "";
                            String taskSyslog = "";
                            String jobConf = this.task.getJobFile();
                            try {
                                taskStdout = FileUtil.makeShellPath(TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), TaskLog.LogName.STDOUT));
                                taskStderr = FileUtil.makeShellPath(TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), TaskLog.LogName.STDERR));
                                taskSyslog = FileUtil.makeShellPath(TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), TaskLog.LogName.SYSLOG));
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Exception finding task's stdout/err/syslog files");
                            }
                            File workDir = null;
                            try {
                                workDir = new File(TaskTracker.this.lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir(this.task.getJobID().toString(), this.task.getTaskID().toString(), this.task.isTaskCleanupTask()) + "/" + "work", this.localJobConf).toString());
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Working Directory of the task " + this.task.getTaskID() + "doesnt exist. Caught exception " + StringUtils.stringifyException(e)));
                            }
                            File stdout = TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), TaskLog.LogName.DEBUGOUT);
                            String program = "";
                            String executable = Submitter.getExecutable(this.localJobConf);
                            if (executable != null) {
                                try {
                                    program = new URI(executable).getFragment();
                                }
                                catch (URISyntaxException ur) {
                                    LOG.warn((Object)"Problem in the URI fragment for pipes executable");
                                }
                            }
                            String[] debug = this.debugCommand.split(" ");
                            Vector<String> vargs = new Vector<String>();
                            for (String component : debug) {
                                vargs.add(component);
                            }
                            vargs.add(taskStdout);
                            vargs.add(taskStderr);
                            vargs.add(taskSyslog);
                            vargs.add(jobConf);
                            vargs.add(program);
                            try {
                                List<String> wrappedCommand = TaskLog.captureDebugOut(vargs, stdout);
                                try {
                                    this.runScript(wrappedCommand, workDir);
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("runScript failed with: " + StringUtils.stringifyException(ioe)));
                                }
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Error in preparing wrapped debug command");
                            }
                            try {
                                int num = this.localJobConf.getInt("mapred.debug.out.lines", -1);
                                this.addDiagnostics(FileUtil.makeShellPath(stdout), num, "DEBUG OUT");
                            }
                            catch (IOException ioe) {
                                LOG.warn((Object)"Exception in add diagnostics!");
                            }
                        }
                    }
                    this.taskStatus.setProgress(0.0f);
                }
                this.taskStatus.setFinishTime(System.currentTimeMillis());
                needCleanup = this.taskStatus.getRunState() == TaskStatus.State.FAILED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED;
            }
            if (needCleanup) {
                TaskTracker.this.removeTaskFromJob(this.task.getJobID(), this);
            }
            try {
                this.cleanup(needCleanup);
            }
            catch (IOException ie) {
                // empty catch block
            }
        }

        public void runScript(List<String> args, File dir) throws IOException {
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]), dir);
            shexec.execute();
            int exitCode = shexec.getExitCode();
            if (exitCode != 0) {
                throw new IOException("Task debug script exit with nonzero status of " + exitCode + ".");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDiagnostics(String file, int num, String tag) {
            RandomAccessFile rafile = null;
            try {
                int n;
                rafile = new RandomAccessFile(file, "r");
                int no_lines = 0;
                String line = null;
                StringBuffer tail = new StringBuffer();
                tail.append("\n-------------------- " + tag + "---------------------\n");
                String[] lines = null;
                if (num > 0) {
                    lines = new String[num];
                }
                while ((line = rafile.readLine()) != null) {
                    ++no_lines;
                    if (num > 0) {
                        if (no_lines <= num) {
                            lines[no_lines - 1] = line;
                            continue;
                        }
                        for (int i = 0; i < num - 1; ++i) {
                            lines[i] = lines[i + 1];
                        }
                        lines[num - 1] = line;
                        continue;
                    }
                    if (num != -1) continue;
                    tail.append(line);
                    tail.append("\n");
                }
                int n2 = n = no_lines > num ? num : no_lines;
                if (num > 0) {
                    for (int i = 0; i < n; ++i) {
                        tail.append(lines[i]);
                        tail.append("\n");
                    }
                }
                if (n != 0) {
                    this.reportDiagnosticInfo(tail.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                LOG.warn((Object)("File " + file + " not found"));
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error reading file " + file));
            }
            finally {
                try {
                    if (rafile != null) {
                        rafile.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + file));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobHasFinished(boolean wasFailure) throws IOException {
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.getRunState() == TaskStatus.State.RUNNING || this.getRunState() == TaskStatus.State.UNASSIGNED || this.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                    this.kill(wasFailure);
                }
            }
            this.cleanup(true);
        }

        public synchronized void kill(boolean wasFailure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.RUNNING || this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                this.wasKilled = true;
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                }
                if (this.runner != null) {
                    this.runner.kill();
                }
                this.setTaskFailState(wasFailure);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            }
            TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
            this.releaseSlot();
        }

        private synchronized void releaseSlot() {
            if (this.slotTaken) {
                if (this.launcher != null) {
                    this.launcher.addFreeSlot();
                }
                this.slotTaken = false;
            }
        }

        private synchronized void mapOutputLost(String failure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.SUCCEEDED) {
                LOG.info((Object)("Reporting output lost:" + this.task.getTaskID()));
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
                this.taskStatus.setProgress(0.0f);
                this.reportDiagnosticInfo("Map output lost, rescheduling: " + failure);
                TaskTracker.this.runningTasks.put(this.task.getTaskID(), this);
                ++TaskTracker.this.mapTotal;
            } else {
                LOG.warn((Object)("Output already reported lost:" + this.task.getTaskID()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup(boolean needCleanup) throws IOException {
            TaskAttemptID taskId = this.task.getTaskID();
            LOG.debug((Object)("Cleaning up " + taskId));
            Object object = TaskTracker.this;
            synchronized (object) {
                if (needCleanup && TaskTracker.this.tasks.get(taskId) == this) {
                    TaskTracker.this.tasks.remove(taskId);
                }
                TaskInProgress taskInProgress = this;
                synchronized (taskInProgress) {
                    if (this.alwaysKeepTaskFiles || this.taskStatus.getRunState() == TaskStatus.State.FAILED && this.keepFailedTaskFiles) {
                        return;
                    }
                }
            }
            object = this;
            synchronized (object) {
                try {
                    if (this.localJobConf == null) {
                        return;
                    }
                    String taskDir = TaskTracker.getLocalTaskDir(this.task.getJobID().toString(), taskId.toString(), this.task.isTaskCleanupTask());
                    if (needCleanup) {
                        if (this.runner != null) {
                            this.runner.close();
                        }
                        if (this.localJobConf.getNumTasksToExecutePerJvm() == 1) {
                            TaskTracker.this.directoryCleanupThread.addToQueue(this.defaultJobConf, TaskTracker.this.getLocalFiles(this.defaultJobConf, taskDir));
                        } else {
                            TaskTracker.this.directoryCleanupThread.addToQueue(this.defaultJobConf, TaskTracker.this.getLocalFiles(this.defaultJobConf, taskDir + "/job.xml"));
                        }
                    } else if (this.localJobConf.getNumTasksToExecutePerJvm() == 1) {
                        TaskTracker.this.directoryCleanupThread.addToQueue(this.defaultJobConf, TaskTracker.this.getLocalFiles(this.defaultJobConf, taskDir + "/work"));
                    }
                }
                catch (Throwable ie) {
                    LOG.info((Object)("Error cleaning up task runner: " + StringUtils.stringifyException(ie)));
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof TaskInProgress && this.task.getTaskID().equals(((TaskInProgress)obj).getTask().getTaskID());
        }

        public int hashCode() {
            return this.task.getTaskID().hashCode();
        }
    }

    private class TaskLauncher
    extends Thread {
        private IntWritable numFreeSlots;
        private final int maxSlots;
        private List<TaskInProgress> tasksToLaunch;

        public TaskLauncher(int numSlots) {
            this.maxSlots = numSlots;
            this.numFreeSlots = new IntWritable(numSlots);
            this.tasksToLaunch = new LinkedList<TaskInProgress>();
            this.setDaemon(true);
            this.setName("TaskLauncher for task");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToTaskQueue(LaunchTaskAction action) {
            List<TaskInProgress> list = this.tasksToLaunch;
            synchronized (list) {
                TaskInProgress tip = TaskTracker.this.registerTask(action, this);
                this.tasksToLaunch.add(tip);
                this.tasksToLaunch.notifyAll();
            }
        }

        public void cleanTaskQueue() {
            this.tasksToLaunch.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFreeSlot() {
            IntWritable intWritable = this.numFreeSlots;
            synchronized (intWritable) {
                this.numFreeSlots.set(this.numFreeSlots.get() + 1);
                assert (this.numFreeSlots.get() <= this.maxSlots);
                LOG.info((Object)("addFreeSlot : current free slots : " + this.numFreeSlots.get()));
                this.numFreeSlots.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    TaskInProgress tip;
                    Object object = this.tasksToLaunch;
                    synchronized (object) {
                        while (this.tasksToLaunch.isEmpty()) {
                            this.tasksToLaunch.wait();
                        }
                        tip = this.tasksToLaunch.remove(0);
                        LOG.info((Object)("Trying to launch : " + tip.getTask().getTaskID()));
                    }
                    object = this.numFreeSlots;
                    synchronized (object) {
                        while (this.numFreeSlots.get() == 0) {
                            this.numFreeSlots.wait();
                        }
                        LOG.info((Object)("In TaskLauncher, current free slots : " + this.numFreeSlots.get() + " and trying to launch " + tip.getTask().getTaskID()));
                        this.numFreeSlots.set(this.numFreeSlots.get() - 1);
                        assert (this.numFreeSlots.get() >= 0);
                    }
                    object = tip;
                    synchronized (object) {
                        if (tip.getRunState() != TaskStatus.State.UNASSIGNED && tip.getRunState() != TaskStatus.State.FAILED_UNCLEAN && tip.getRunState() != TaskStatus.State.KILLED_UNCLEAN) {
                            this.addFreeSlot();
                            continue;
                        }
                        tip.slotTaken = true;
                    }
                    TaskTracker.this.startNewTask(tip);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable th) {
                    LOG.error((Object)("TaskLauncher error " + StringUtils.stringifyException(th)));
                }
            }
        }
    }

    private class FetchStatus {
        private IntWritable fromEventId = new IntWritable(0);
        private List<TaskCompletionEvent> allMapEvents;
        private JobID jobId;
        private long lastFetchTime;
        private boolean fetchAgain;

        public FetchStatus(JobID jobId, int numMaps) {
            this.jobId = jobId;
            this.allMapEvents = new ArrayList<TaskCompletionEvent>(numMaps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.fromEventId.set(0);
                    this.allMapEvents.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskCompletionEvent[] getMapEvents(int fromId, int max) {
            TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
            boolean notifyFetcher = false;
            Object object = this.allMapEvents;
            synchronized (object) {
                if (this.allMapEvents.size() > fromId) {
                    int actualMax = Math.min(max, this.allMapEvents.size() - fromId);
                    List<TaskCompletionEvent> eventSublist = this.allMapEvents.subList(fromId, actualMax + fromId);
                    mapEvents = eventSublist.toArray(mapEvents);
                } else {
                    notifyFetcher = true;
                }
            }
            if (notifyFetcher) {
                object = TaskTracker.this.waitingOn;
                synchronized (object) {
                    TaskTracker.this.waitingOn.notify();
                }
            }
            return mapEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchMapCompletionEvents(long currTime) throws IOException {
            if (!this.fetchAgain && currTime - this.lastFetchTime < (long)TaskTracker.this.heartbeatInterval) {
                return false;
            }
            int currFromEventId = 0;
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                currFromEventId = this.fromEventId.get();
                List recentMapEvents = TaskTracker.this.queryJobTracker(this.fromEventId, this.jobId, TaskTracker.this.jobClient);
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.allMapEvents.addAll(recentMapEvents);
                }
                this.lastFetchTime = currTime;
                if (this.fromEventId.get() - currFromEventId >= TaskTracker.this.probe_sample_size) {
                    this.fetchAgain = true;
                    return true;
                }
            }
            this.fetchAgain = false;
            return false;
        }
    }

    private class MapEventsFetcherThread
    extends Thread {
        private MapEventsFetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FetchStatus> reducesInShuffle() {
            ArrayList<FetchStatus> fList = new ArrayList<FetchStatus>();
            for (Map.Entry<JobID, RunningJob> item : TaskTracker.this.runningJobs.entrySet()) {
                RunningJob rjob = item.getValue();
                JobID jobId = item.getKey();
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    for (TaskInProgress tip : rjob.tasks) {
                        Task task = tip.getTask();
                        if (task.isMapTask() || ((ReduceTask)task).getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                        if (rjob.getFetchStatus() == null) {
                            f = new FetchStatus(jobId, ((ReduceTask)task).getNumMaps());
                            rjob.setFetchStatus(f);
                        }
                        f = rjob.getFetchStatus();
                        fList.add(f);
                        break;
                    }
                }
            }
            return fList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)("Starting thread: " + this.getName()));
            while (TaskTracker.this.running) {
                try {
                    List<FetchStatus> fList = null;
                    Map<JobID, RunningJob> map = TaskTracker.this.runningJobs;
                    synchronized (map) {
                        while ((fList = this.reducesInShuffle()).size() == 0) {
                            try {
                                TaskTracker.this.runningJobs.wait();
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)("Shutting down: " + this.getName()));
                                return;
                            }
                        }
                    }
                    boolean fetchAgain = false;
                    for (FetchStatus f : fList) {
                        long currentTime = System.currentTimeMillis();
                        try {
                            if (f.fetchMapCompletionEvents(currentTime)) {
                                fetchAgain = true;
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Ignoring exception that fetch for map completion events threw for " + f.jobId + " threw: " + StringUtils.stringifyException(e)));
                        }
                        if (TaskTracker.this.running) continue;
                        break;
                    }
                    Object object = TaskTracker.this.waitingOn;
                    synchronized (object) {
                        try {
                            if (!fetchAgain) {
                                TaskTracker.this.waitingOn.wait(TaskTracker.this.heartbeatInterval);
                            }
                        }
                        catch (InterruptedException ie) {
                            LOG.info((Object)("Shutting down: " + this.getName()));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Ignoring exception " + e.getMessage()));
                }
            }
        }
    }

    private class ShuffleServerMetrics
    implements Updater {
        private MetricsRecord shuffleMetricsRecord = null;
        private int serverHandlerBusy = 0;
        private long outputBytes = 0L;
        private int failedOutputs = 0;
        private int successOutputs = 0;

        ShuffleServerMetrics(JobConf conf) {
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.shuffleMetricsRecord = MetricsUtil.createRecord(context, "shuffleOutput");
            this.shuffleMetricsRecord.setTag("sessionId", conf.getSessionId());
            context.registerUpdater(this);
        }

        synchronized void serverHandlerBusy() {
            ++this.serverHandlerBusy;
        }

        synchronized void serverHandlerFree() {
            --this.serverHandlerBusy;
        }

        synchronized void outputBytes(long bytes) {
            this.outputBytes += bytes;
        }

        synchronized void failedOutput() {
            ++this.failedOutputs;
        }

        synchronized void successOutput() {
            ++this.successOutputs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doUpdates(MetricsContext unused) {
            ShuffleServerMetrics shuffleServerMetrics = this;
            synchronized (shuffleServerMetrics) {
                if (TaskTracker.this.workerThreads != 0) {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 100.0f * ((float)this.serverHandlerBusy / (float)TaskTracker.this.workerThreads));
                } else {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 0);
                }
                this.shuffleMetricsRecord.incrMetric("shuffle_output_bytes", this.outputBytes);
                this.shuffleMetricsRecord.incrMetric("shuffle_failed_outputs", this.failedOutputs);
                this.shuffleMetricsRecord.incrMetric("shuffle_success_outputs", this.successOutputs);
                this.outputBytes = 0L;
                this.failedOutputs = 0;
                this.successOutputs = 0;
            }
            this.shuffleMetricsRecord.update();
        }
    }

    static enum State {
        NORMAL,
        STALE,
        INTERRUPTED,
        DENIED;

    }
}

