/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestCrcCorruption
extends TestCase {
    public TestCrcCorruption(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thistest(Configuration conf, DFSTestUtil util) throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        short replFactor = 2;
        Random random = new Random();
        try {
            cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat", replFactor);
            util.waitReplication(fs, "/srcdat", (short)2);
            File data_dir = new File(System.getProperty("test.build.data"), "dfs/data/data1/current");
            TestCrcCorruption.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            TestCrcCorruption.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            int num = 0;
            for (int idx = 0; idx < blocks.length; ++idx) {
                FileChannel channel;
                RandomAccessFile file;
                if (!blocks[idx].getName().startsWith("blk_") || !blocks[idx].getName().endsWith(".meta")) continue;
                if (++num % 3 == 0) {
                    System.out.println("Deliberately removing file " + blocks[idx].getName());
                    TestCrcCorruption.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                    continue;
                }
                if (num % 3 == 1) {
                    file = new RandomAccessFile(blocks[idx], "rw");
                    channel = file.getChannel();
                    int newsize = random.nextInt((int)channel.size() / 2);
                    System.out.println("Deliberately truncating file " + blocks[idx].getName() + " to size " + newsize + " bytes.");
                    channel.truncate(newsize);
                    file.close();
                    continue;
                }
                file = new RandomAccessFile(blocks[idx], "rw");
                channel = file.getChannel();
                long position = 0L;
                if (num != 2) {
                    position = random.nextInt((int)channel.size());
                }
                int length = random.nextInt((int)(channel.size() - position + 1L));
                byte[] buffer = new byte[length];
                random.nextBytes(buffer);
                channel.write(ByteBuffer.wrap(buffer), position);
                System.out.println("Deliberately corrupting file " + blocks[idx].getName() + " at offset " + position + " length " + length);
                file.close();
            }
            data_dir = new File(System.getProperty("test.build.data"), "dfs/data/data2/current");
            TestCrcCorruption.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            blocks = data_dir.listFiles();
            TestCrcCorruption.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            int count = 0;
            File previous = null;
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_") || !blocks[idx].getName().endsWith(".meta")) continue;
                if (++count % 2 == 0) {
                    System.out.println("Deliberately insertimg bad crc into files " + blocks[idx].getName() + " " + previous.getName());
                    TestCrcCorruption.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                    TestCrcCorruption.assertTrue((String)"Cannot corrupt meta file.", (boolean)previous.renameTo(blocks[idx]));
                    TestCrcCorruption.assertTrue((String)"Cannot recreate empty meta file.", (boolean)previous.createNewFile());
                    previous = null;
                    continue;
                }
                previous = blocks[idx];
            }
            TestCrcCorruption.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles(fs, "/srcdat"));
            System.out.println("All File still have a valid replica");
            util.setReplication(fs, "/srcdat", (short)1);
            System.out.println("The excess-corrupted-replica test is disabled  pending HADOOP-1557");
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCrcCorruption() throws Exception {
        System.out.println("TestCrcCorruption with default parameters");
        Configuration conf1 = new Configuration();
        conf1.setInt("dfs.blockreport.intervalMsec", 3000);
        DFSTestUtil util1 = new DFSTestUtil("TestCrcCorruption", 40, 3, 8192);
        this.thistest(conf1, util1);
        System.out.println("TestCrcCorruption with specific parameters");
        Configuration conf2 = new Configuration();
        conf2.setInt("io.bytes.per.checksum", 17);
        conf2.setInt("dfs.block.size", 34);
        DFSTestUtil util2 = new DFSTestUtil("TestCrcCorruption", 40, 3, 400);
        this.thistest(conf2, util2);
    }
}

