/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;

public class TestDFSClientRetries
extends TestCase {
    private static void writeData(OutputStream out, int len) throws IOException {
        byte[] buf = new byte[65536];
        while (len > 0) {
            int toWrite = Math.min(len, buf.length);
            out.write(buf, 0, toWrite);
            len -= toWrite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteTimeoutAtDataNode() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        int writeTimeout = 100;
        conf.setInt("dfs.datanode.socket.write.timeout", 100);
        int blockSize = 0xA00000;
        conf.setInt("dfs.block.size", 0xA00000);
        conf.setInt("dfs.client.max.block.acquire.failures", 1);
        int bufferSize = 4096;
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteTimeoutAtDataNode");
            FSDataOutputStream out = fs.create(filePath, true, 4096);
            TestDFSClientRetries.writeData((OutputStream)out, 0x1400000);
            out.close();
            byte[] buf = new byte[0x100000];
            FSDataInputStream in = fs.open(filePath, 4096);
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)2048);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(200L);
                IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
            }
            in.close();
        }
        finally {
            cluster.shutdown();
        }
    }
}

