/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;

public class TestDistributedFileSystem
extends TestCase {
    private static final Random RAN = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileSystemCloseAll() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 0, true, null);
        URI address = FileSystem.getDefaultUri((Configuration)conf);
        try {
            FileSystem.closeAll();
            conf = new Configuration();
            FileSystem.setDefaultUri((Configuration)conf, (URI)address);
            FileSystem.get((Configuration)conf);
            FileSystem.get((Configuration)conf);
            FileSystem.closeAll();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSClose() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fileSys = cluster.getFileSystem();
        try {
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.create(new Path("/test/dfsclose/file-1"));
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSClient() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            Path filepath = new Path("/test/LeaseChecker/foo");
            long millis = System.currentTimeMillis();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            TestDistributedFileSystem.assertFalse((boolean)dfs.dfs.isLeaseCheckerStarted());
            FSDataOutputStream out = dfs.create(filepath);
            TestDistributedFileSystem.assertTrue((boolean)dfs.dfs.isLeaseCheckerStarted());
            out.writeLong(millis);
            TestDistributedFileSystem.assertTrue((boolean)dfs.dfs.isLeaseCheckerStarted());
            out.close();
            TestDistributedFileSystem.assertTrue((boolean)dfs.dfs.isLeaseCheckerStarted());
            dfs.close();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            TestDistributedFileSystem.assertFalse((boolean)dfs.dfs.isLeaseCheckerStarted());
            FSDataInputStream in = dfs.open(filepath);
            TestDistributedFileSystem.assertFalse((boolean)dfs.dfs.isLeaseCheckerStarted());
            TestDistributedFileSystem.assertEquals((long)millis, (long)in.readLong());
            TestDistributedFileSystem.assertFalse((boolean)dfs.dfs.isLeaseCheckerStarted());
            in.close();
            TestDistributedFileSystem.assertFalse((boolean)dfs.dfs.isLeaseCheckerStarted());
            dfs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testFileChecksum() throws IOException {
        ((Log4JLogger)HftpFileSystem.LOG).getLogger().setLevel(Level.ALL);
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        Configuration conf = new Configuration();
        conf.set("slave.host.name", "localhost");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem hdfs = cluster.getFileSystem();
        String hftpuri = "hftp://" + conf.get("dfs.http.address");
        System.out.println("hftpuri=" + hftpuri);
        FileSystem hftp = new Path(hftpuri).getFileSystem(conf);
        String dir = "/filechecksum";
        int block_size = 1024;
        int buffer_size = conf.getInt("io.file.buffer.size", 4096);
        conf.setInt("io.bytes.per.checksum", 512);
        for (int n = 0; n < 5; ++n) {
            byte[] data = new byte[RAN.nextInt(511) + n * 1024 + 1];
            RAN.nextBytes(data);
            System.out.println("data.length=" + data.length);
            Path foo = new Path("/filechecksum", "foo" + n);
            FSDataOutputStream out = hdfs.create(foo, false, buffer_size, (short)2, 1024L);
            out.write(data);
            out.close();
            FileChecksum hdfsfoocs = hdfs.getFileChecksum(foo);
            System.out.println("hdfsfoocs=" + hdfsfoocs);
            FileChecksum hftpfoocs = hftp.getFileChecksum(foo);
            System.out.println("hftpfoocs=" + hftpfoocs);
            Path bar = new Path("/filechecksum", "bar" + n);
            FSDataOutputStream out2 = hdfs.create(bar, false, buffer_size, (short)2, 1024L);
            out2.write(data);
            out2.close();
            FileChecksum barcs = hdfs.getFileChecksum(bar);
            int barhashcode = barcs.hashCode();
            TestDistributedFileSystem.assertEquals((int)hdfsfoocs.hashCode(), (int)barhashcode);
            TestDistributedFileSystem.assertEquals((Object)hdfsfoocs, (Object)barcs);
            TestDistributedFileSystem.assertEquals((int)hftpfoocs.hashCode(), (int)barhashcode);
            TestDistributedFileSystem.assertEquals((Object)hftpfoocs, (Object)barcs);
        }
    }
}

