/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestFileStatus
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');

    private void writeFile(FileSystem fileSys, Path name, int repl, int fileSize, int blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, (long)blockSize);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileStatus() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        DFSClient dfsClient = new DFSClient(conf);
        try {
            Path path = new Path("/");
            System.out.println("Path : \"" + path.toString() + "\"");
            System.out.println(fs.isDirectory(path));
            System.out.println(fs.getFileStatus(path).isDir());
            TestFileStatus.assertTrue((String)"/ should be a directory", (fs.getFileStatus(path).isDir() ? 1 : 0) != 0);
            FileStatus fileInfo = dfsClient.getFileInfo("/noSuchFile");
            TestFileStatus.assertTrue((fileInfo == null ? 1 : 0) != 0);
            Path file1 = new Path("filestatus.dat");
            this.writeFile(fs, file1, 1, 16384, 8192);
            System.out.println("Created file filestatus.dat with one  replicas.");
            this.checkFile(fs, file1, 1);
            TestFileStatus.assertTrue((String)(file1 + " should be a file"), (!fs.getFileStatus(file1).isDir() ? 1 : 0) != 0);
            TestFileStatus.assertTrue((fs.getFileStatus(file1).getBlockSize() == 8192L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((fs.getFileStatus(file1).getReplication() == 1 ? 1 : 0) != 0);
            TestFileStatus.assertTrue((fs.getFileStatus(file1).getLen() == 16384L ? 1 : 0) != 0);
            System.out.println("Path : \"" + file1 + "\"");
            Path parentDir = new Path("/test");
            Path dir = new Path("/test/mkdirs");
            TestFileStatus.assertTrue((boolean)fs.mkdirs(dir));
            TestFileStatus.assertTrue((boolean)fs.exists(dir));
            TestFileStatus.assertTrue((String)(dir + " should be a directory"), (fs.getFileStatus(path).isDir() ? 1 : 0) != 0);
            TestFileStatus.assertTrue((String)(dir + " should be zero size "), (fs.getContentSummary(dir).getLength() == 0L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((String)(dir + " should be zero size "), (fs.getFileStatus(dir).getLen() == 0L ? 1 : 0) != 0);
            System.out.println("Dir : \"" + dir + "\"");
            Path file2 = new Path("/test/mkdirs/filestatus2.dat");
            this.writeFile(fs, file2, 1, 2048, 8192);
            System.out.println("Created file filestatus2.dat with one  replicas.");
            this.checkFile(fs, file2, 1);
            System.out.println("Path : \"" + file2 + "\"");
            TestFileStatus.assertTrue((fs.getFileStatus(file2).getBlockSize() == 8192L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((fs.getFileStatus(file2).getReplication() == 1 ? 1 : 0) != 0);
            Path file3 = new Path("/test/mkdirs/filestatus3.dat");
            this.writeFile(fs, file3, 1, 2048, 8192);
            System.out.println("Created file filestatus3.dat with one  replicas.");
            this.checkFile(fs, file3, 1);
            TestFileStatus.assertTrue((String)(dir + " size should be " + 4096), (4096L == fs.getContentSummary(dir).getLength() ? 1 : 0) != 0);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

