/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.net.SocketFactory;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;

public class TestGetBlocks
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBlocks() throws Exception {
        Configuration CONF = new Configuration();
        int REPLICATION_FACTOR = 2;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.block.size", 1024L);
        MiniDFSCluster cluster = new MiniDFSCluster(CONF, 2, true, null);
        try {
            boolean notWritten;
            long fileLen;
            int bytesToWriteNext;
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(new Path("/tmp.txt"), (short)2);
            byte[] data = new byte[1024];
            for (long bytesToWrite = fileLen = 2048L; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                r.nextBytes(data);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(data, 0, bytesToWriteNext);
            }
            out.close();
            DatanodeInfo[] dataNodes = null;
            block6: do {
                DFSClient dfsclient = new DFSClient(CONF);
                List locatedBlocks = dfsclient.namenode.getBlockLocations("/tmp.txt", 0L, fileLen).getLocatedBlocks();
                TestGetBlocks.assertEquals((int)2, (int)locatedBlocks.size());
                notWritten = false;
                for (int i = 0; i < 2; ++i) {
                    dataNodes = ((LocatedBlock)locatedBlocks.get(i)).getLocations();
                    if (dataNodes.length == 2) continue;
                    notWritten = true;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
            } while (notWritten);
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            NamenodeProtocol namenode = (NamenodeProtocol)RPC.getProxy(NamenodeProtocol.class, (long)2L, (InetSocketAddress)addr, (UserGroupInformation)UnixUserGroupInformation.login((Configuration)CONF), (Configuration)CONF, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)CONF));
            BlocksWithLocations.BlockWithLocations[] locs = namenode.getBlocks(dataNodes[0], fileLen).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)2);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            TestGetBlocks.assertEquals((int)locs[1].getDatanodes().length, (int)2);
            locs = namenode.getBlocks(dataNodes[0], 1024L).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)1);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            locs = namenode.getBlocks(dataNodes[0], 1L).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)1);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            this.getBlocksWithException(namenode, dataNodes[0], 0L);
            this.getBlocksWithException(namenode, dataNodes[0], -1L);
            this.getBlocksWithException(namenode, new DatanodeInfo(), 2L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void getBlocksWithException(NamenodeProtocol namenode, DatanodeInfo datanode, long size) throws IOException {
        boolean getException = false;
        try {
            namenode.getBlocks(new DatanodeInfo(), 2L);
        }
        catch (RemoteException e) {
            getException = true;
            TestGetBlocks.assertTrue((boolean)e.getMessage().contains("IllegalArgumentException"));
        }
        TestGetBlocks.assertTrue((boolean)getException);
    }

    public void testGenerationStampWildCard() {
        int i;
        HashMap<Block, Long> map = new HashMap<Block, Long>();
        Random RAN = new Random();
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        long[] blkids = new long[10];
        for (i = 0; i < blkids.length; ++i) {
            blkids[i] = 1000L + (long)RAN.nextInt(100000);
            map.put(new Block(blkids[i], 0L, blkids[i]), blkids[i]);
        }
        System.out.println("map=" + ((Object)map).toString().replace(",", "\n  "));
        for (i = 0; i < blkids.length; ++i) {
            Block b = new Block(blkids[i], 0L, 1L);
            Long v = (Long)map.get(b);
            System.out.println(b + " => " + v);
            TestGetBlocks.assertEquals((long)blkids[i], (long)v);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestGetBlocks().testGetBlocks();
    }
}

