/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ReplicationTargetChooser;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;

public class TestReplicationPolicy
extends TestCase {
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 6;
    private static final Configuration CONF;
    private static final NetworkTopology cluster;
    private static NameNode namenode;
    private static ReplicationTargetChooser replicator;
    private static DatanodeDescriptor[] dataNodes;
    private static final DatanodeDescriptor NODE;

    public void testChooseTarget1() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 4);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        targets = replicator.chooseTarget(2, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(3, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        targets = replicator.chooseTarget(4, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    public void testChooseTarget2() throws Exception {
        ArrayList<DatanodeDescriptor> excludedNodes = new ArrayList<DatanodeDescriptor>();
        excludedNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        excludedNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = replicator.chooseTarget(1, dataNodes[0], excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        excludedNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = replicator.chooseTarget(2, dataNodes[0], excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        excludedNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = replicator.chooseTarget(3, dataNodes[0], excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        excludedNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = replicator.chooseTarget(4, dataNodes[0], excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        for (int i = 1; i < 4; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
    }

    public void testChooseTarget3() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 4096L, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        targets = replicator.chooseTarget(2, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(3, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(4, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        for (int i = 1; i < 4; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    public void testChoooseTarget4() throws Exception {
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            dataNodes[i2].updateHeartbeat(10240L, 0L, 4096L, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        targets = replicator.chooseTarget(2, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(3, dataNodes[0], null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        for (i = 0; i < 3; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[i], (Node)dataNodes[0]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[0], (Node)targets[1]) || cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        for (i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 5120L, 0);
        }
    }

    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, NODE, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, NODE, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        targets = replicator.chooseTarget(2, NODE, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(3, NODE, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
    }

    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(2, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(3, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(2, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[1]));
    }

    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[2]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(0, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(1, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        targets = replicator.chooseTarget(1, dataNodes[2], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(2, dataNodes[0], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(2, dataNodes[2], chosenNodes, null, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
    }

    static {
        int i;
        CONF = new Configuration();
        dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h4:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h5:5020"), "/d2/r3"), new DatanodeDescriptor(new DatanodeID("h6:5020"), "/d2/r3")};
        NODE = new DatanodeDescriptor(new DatanodeID("h7:5020"), "/d2/r4");
        try {
            FileSystem.setDefaultUri((Configuration)CONF, (String)"hdfs://localhost:0");
            NameNode.format((Configuration)CONF);
            namenode = new NameNode(CONF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FSNamesystem fsNamesystem = FSNamesystem.getFSNamesystem();
        replicator = fsNamesystem.replicator;
        cluster = fsNamesystem.clusterMap;
        for (i = 0; i < 6; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
    }
}

