/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

class ControlledMapReduceJob
extends Configured
implements Tool,
Mapper<NullWritable, NullWritable, IntWritable, NullWritable>,
Reducer<IntWritable, NullWritable, NullWritable, NullWritable>,
Partitioner<IntWritable, NullWritable>,
InputFormat<NullWritable, NullWritable> {
    static final Log LOG = LogFactory.getLog(ControlledMapReduceJob.class);
    private FileSystem fs = null;
    private int taskNumber;
    private static ArrayList<Path> signalFileDirCache = new ArrayList();
    private Path signalFileDir;
    private long mapsFinished;
    private long reducesFinished;
    private RunningJob rJob;
    private int numMappers;
    private int numReducers;
    private final String MAP_SIGFILE_PREFIX = "MAPS_";
    private final String REDUCE_SIGFILE_PREFIX = "REDUCES_";

    ControlledMapReduceJob() {
        Random random = new Random();
        this.signalFileDir = new Path("signalFileDir-" + random.nextLong());
        while (signalFileDirCache.contains(this.signalFileDir)) {
            this.signalFileDir = new Path("signalFileDir-" + random.nextLong());
        }
        signalFileDirCache.add(this.signalFileDir);
        this.mapsFinished = 0L;
        this.reducesFinished = 0L;
        this.rJob = null;
        this.MAP_SIGFILE_PREFIX = "MAPS_";
        this.REDUCE_SIGFILE_PREFIX = "REDUCES_";
    }

    private void initialize() throws IOException {
        this.fs = FileSystem.get((Configuration)this.getConf());
        this.fs.mkdirs(this.signalFileDir);
        this.writeFile(new Path(this.signalFileDir, "MAPS_" + this.mapsFinished));
        this.writeFile(new Path(this.signalFileDir, "REDUCES_" + this.reducesFinished));
    }

    public void finishNTasks(boolean isMap, int noOfTasksToFinish) throws IOException {
        if (noOfTasksToFinish < 0) {
            throw new IOException("Negative values for noOfTasksToFinish not acceptable");
        }
        if (noOfTasksToFinish == 0) {
            return;
        }
        LOG.info((Object)("Going to finish off " + noOfTasksToFinish));
        String PREFIX = isMap ? "MAPS_" : "REDUCES_";
        long tasksFinished = isMap ? this.mapsFinished : this.reducesFinished;
        Path oldSignalFile = new Path(this.signalFileDir, PREFIX + String.valueOf(tasksFinished));
        Path newSignalFile = new Path(this.signalFileDir, PREFIX + String.valueOf(tasksFinished + (long)noOfTasksToFinish));
        this.fs.rename(oldSignalFile, newSignalFile);
        if (isMap) {
            this.mapsFinished += (long)noOfTasksToFinish;
        } else {
            this.reducesFinished += (long)noOfTasksToFinish;
        }
        LOG.info((Object)("Successfully sent signal to finish off " + noOfTasksToFinish));
    }

    public void finishAllTasks(boolean isMap) throws IOException {
        this.finishNTasks(isMap, isMap ? this.numMappers : this.numReducers);
    }

    public void finishJob() throws IOException {
        this.finishAllTasks(true);
        this.finishAllTasks(false);
    }

    static void waitTillNTasksStartRunning(JobInProgress jip, boolean isMap, int noOfTasksToBeRunning) throws InterruptedException {
        int numTasks = 0;
        while (numTasks != noOfTasksToBeRunning) {
            Thread.sleep(1000L);
            numTasks = isMap ? jip.runningMaps() : jip.runningReduces();
            LOG.info((Object)("Waiting till " + noOfTasksToBeRunning + (isMap ? " map" : " reduce") + " tasks of the job " + jip.getJobID() + " start running. " + numTasks + " tasks already started running."));
        }
    }

    static void assertNumTasksRunning(JobInProgress jip, boolean isMap, int noOfTasksToBeRunning) throws Exception {
        if ((isMap ? jip.runningMaps() : jip.runningReduces()) != noOfTasksToBeRunning) {
            throw new Exception("Number of tasks running is not " + noOfTasksToBeRunning);
        }
    }

    static void waitTillNTotalTasksFinish(JobInProgress jip, boolean isMap, int noOfTasksToFinish) throws InterruptedException {
        int noOfTasksAlreadyFinished = 0;
        while (noOfTasksAlreadyFinished < noOfTasksToFinish) {
            Thread.sleep(1000L);
            noOfTasksAlreadyFinished = isMap ? jip.finishedMaps() : jip.finishedReduces();
            LOG.info((Object)("Waiting till " + noOfTasksToFinish + (isMap ? " map" : " reduce") + " tasks of the job " + jip.getJobID() + " finish. " + noOfTasksAlreadyFinished + " tasks already got finished."));
        }
    }

    static boolean haveAllTasksFinished(JobInProgress jip, boolean isMap) {
        return (isMap ? jip.runningMaps() : jip.runningReduces()) == 0;
    }

    private void writeFile(Path name) throws IOException {
        Configuration conf = new Configuration(false);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)conf, (Path)name, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        writer.append((Writable)new BytesWritable(), (Writable)new BytesWritable());
        writer.close();
    }

    public void configure(JobConf conf) {
        try {
            this.signalFileDir = new Path(conf.get("signal.dir.path"));
            this.numReducers = conf.getNumReduceTasks();
            this.fs = FileSystem.get((Configuration)conf);
            String taskAttemptId = conf.get("mapred.task.id");
            if (taskAttemptId != null) {
                TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)taskAttemptId);
                this.taskNumber = taskAttemptID.getTaskID().getId();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Caught exception " + ioe));
        }
    }

    private FileStatus[] listSignalFiles(FileSystem fileSys, final boolean isMap) throws IOException {
        return fileSys.globStatus(new Path(this.signalFileDir.toString() + "/*"), new PathFilter(){

            public boolean accept(Path path) {
                if (isMap && path.getName().startsWith("MAPS_")) {
                    LOG.debug((Object)("Found signal file : " + path.getName()));
                    return true;
                }
                if (!isMap && path.getName().startsWith("REDUCES_")) {
                    LOG.debug((Object)("Found signal file : " + path.getName()));
                    return true;
                }
                LOG.info((Object)"Didn't find any relevant signal files.");
                return false;
            }
        });
    }

    public void map(NullWritable key, NullWritable value, OutputCollector<IntWritable, NullWritable> output, Reporter reporter) throws IOException {
        LOG.info((Object)(this.taskNumber + " has started."));
        FileStatus[] files = this.listSignalFiles(this.fs, true);
        String[] sigFileComps = files[0].getPath().getName().split("_");
        String signalType = sigFileComps[0];
        int noOfTasks = Integer.parseInt(sigFileComps[1]);
        while (!signalType.equals("MAPS") || this.taskNumber + 1 > noOfTasks) {
            LOG.info((Object)("Signal type found : " + signalType + " .Number of tasks to be finished by this signal : " + noOfTasks + " . My id : " + this.taskNumber));
            LOG.info((Object)(this.taskNumber + " is still alive."));
            try {
                reporter.progress();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)(this.taskNumber + " is still alive."));
                break;
            }
            files = this.listSignalFiles(this.fs, true);
            sigFileComps = files[0].getPath().getName().split("_");
            signalType = sigFileComps[0];
            noOfTasks = Integer.parseInt(sigFileComps[1]);
        }
        LOG.info((Object)("Signal type found : " + signalType + " .Number of tasks to be finished by this signal : " + noOfTasks + " . My id : " + this.taskNumber));
        for (int i = 0; i < this.numReducers; ++i) {
            output.collect((Object)new IntWritable(i), (Object)NullWritable.get());
        }
        LOG.info((Object)(this.taskNumber + " is finished."));
    }

    public void reduce(IntWritable key, Iterator<NullWritable> values, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
        LOG.info((Object)(this.taskNumber + " has started."));
        FileStatus[] files = this.listSignalFiles(this.fs, false);
        String[] sigFileComps = files[0].getPath().getName().split("_");
        String signalType = sigFileComps[0];
        int noOfTasks = Integer.parseInt(sigFileComps[1]);
        while (!signalType.equals("REDUCES") || this.taskNumber + 1 > noOfTasks) {
            LOG.info((Object)("Signal type found : " + signalType + " .Number of tasks to be finished by this signal : " + noOfTasks + " . My id : " + this.taskNumber));
            LOG.info((Object)(this.taskNumber + " is still alive."));
            try {
                reporter.progress();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)(this.taskNumber + " is still alive."));
                break;
            }
            files = this.listSignalFiles(this.fs, false);
            sigFileComps = files[0].getPath().getName().split("_");
            signalType = sigFileComps[0];
            noOfTasks = Integer.parseInt(sigFileComps[1]);
        }
        LOG.info((Object)("Signal type found : " + signalType + " .Number of tasks to be finished by this signal : " + noOfTasks + " . My id : " + this.taskNumber));
        LOG.info((Object)(this.taskNumber + " is finished."));
    }

    public void close() throws IOException {
    }

    public JobID getJobId() {
        if (this.rJob == null) {
            return null;
        }
        return this.rJob.getID();
    }

    public int run(int numMapper, int numReducer) throws IOException {
        JobConf conf = this.getControlledMapReduceJobConf(this.getConf(), numMapper, numReducer);
        JobClient client = new JobClient(conf);
        this.rJob = client.submitJob(conf);
        while (!this.rJob.isComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        if (this.rJob.isSuccessful()) {
            return 0;
        }
        return 1;
    }

    private JobConf getControlledMapReduceJobConf(Configuration clusterConf, int numMapper, int numReducer) throws IOException {
        this.setConf(clusterConf);
        this.initialize();
        JobConf conf = new JobConf(this.getConf(), ControlledMapReduceJob.class);
        conf.setJobName("ControlledJob");
        conf.set("signal.dir.path", this.signalFileDir.toString());
        conf.setNumMapTasks(numMapper);
        conf.setNumReduceTasks(numReducer);
        conf.setMapperClass(ControlledMapReduceJob.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(NullWritable.class);
        conf.setReducerClass(ControlledMapReduceJob.class);
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(NullWritable.class);
        conf.setInputFormat(ControlledMapReduceJob.class);
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path("ignored"));
        conf.setOutputFormat(NullOutputFormat.class);
        conf.set("mapred.reduce.slowstart.completed.maps", String.valueOf(0));
        return conf;
    }

    public int run(String[] args) throws Exception {
        this.numMappers = Integer.parseInt(args[0]);
        this.numReducers = Integer.parseInt(args[1]);
        return this.run(this.numMappers, this.numReducers);
    }

    public int getPartition(IntWritable k, NullWritable v, int numPartitions) {
        return k.get() % numPartitions;
    }

    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        LOG.debug((Object)"Inside RecordReader.getRecordReader");
        return new RecordReader<NullWritable, NullWritable>(){
            private int pos = 0;

            public void close() {
            }

            public NullWritable createKey() {
                return NullWritable.get();
            }

            public NullWritable createValue() {
                return NullWritable.get();
            }

            public long getPos() {
                return this.pos;
            }

            public float getProgress() {
                return this.pos * 100;
            }

            public boolean next(NullWritable key, NullWritable value) {
                if (this.pos++ == 0) {
                    LOG.debug((Object)"Returning the next record");
                    return true;
                }
                LOG.debug((Object)"No more records. Returning none.");
                return false;
            }
        };
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) {
        LOG.debug((Object)"Inside InputSplit.getSplits");
        InputSplit[] ret = new InputSplit[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            ret[i] = new EmptySplit();
        }
        return ret;
    }

    static class ControlledMapReduceJobRunner
    extends Thread {
        private JobConf conf;
        private ControlledMapReduceJob job;
        private JobID jobID;
        private int numMappers;
        private int numReducers;

        public ControlledMapReduceJobRunner() {
            this(new JobConf(), 5, 5);
        }

        public ControlledMapReduceJobRunner(JobConf cnf, int numMap, int numRed) {
            this.conf = cnf;
            this.numMappers = numMap;
            this.numReducers = numRed;
        }

        public ControlledMapReduceJob getJob() {
            while (this.job == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)(ControlledMapReduceJobRunner.class.getName() + " is interrupted."));
                    break;
                }
            }
            return this.job;
        }

        public JobID getJobID() throws IOException {
            ControlledMapReduceJob job = this.getJob();
            JobID id = job.getJobId();
            while (id == null) {
                id = job.getJobId();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)(ControlledMapReduceJobRunner.class.getName() + " is interrupted."));
                    break;
                }
            }
            return id;
        }

        @Override
        public void run() {
            if (this.job != null) {
                LOG.warn((Object)"Job is already running.");
                return;
            }
            try {
                this.job = new ControlledMapReduceJob();
                int ret = ToolRunner.run((Configuration)this.conf, (Tool)this.job, (String[])new String[]{String.valueOf(this.numMappers), String.valueOf(this.numReducers)});
                LOG.info((Object)("Return value for the job : " + ret));
            }
            catch (Exception e) {
                LOG.warn((Object)("Caught exception : " + StringUtils.stringifyException((Throwable)e)));
            }
        }

        static ControlledMapReduceJobRunner getControlledMapReduceJobRunner(JobConf conf, int numMappers, int numReducers) {
            return new ControlledMapReduceJobRunner(conf, numMappers, numReducers);
        }
    }

    public static class EmptySplit
    implements InputSplit {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }
}

