/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.EmptyInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestEmptyJobWithDFS
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestEmptyJobWithDFS.class.getName());

    public static boolean launchEmptyJob(String fileSys, String jobTracker, JobConf conf, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/empty/input");
        Path outDir = new Path("/testing/empty/output");
        FileSystem fs = FileSystem.getNamed((String)fileSys, (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            LOG.warn((Object)("Can't create " + inDir));
            return false;
        }
        FileSystem.setDefaultUri((Configuration)conf, (String)fileSys);
        conf.set("mapred.job.tracker", jobTracker);
        conf.setJobName("empty");
        conf.setInputFormat(EmptyInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        JobClient jc = new JobClient(conf);
        RunningJob runningJob = jc.submitJob(conf);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!runningJob.isComplete());
        try {
            TestEmptyJobWithDFS.assertTrue((boolean)runningJob.isComplete());
            TestEmptyJobWithDFS.assertTrue((boolean)runningJob.isSuccessful());
        }
        catch (NullPointerException npe) {
            TestEmptyJobWithDFS.fail((String)"A NPE should not have happened.");
        }
        LOG.info((Object)("job is complete: " + runningJob.isSuccessful()));
        return runningJob.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyJobWithDFS() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            int jobTrackerPort = 60050;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getName();
            mr = new MiniMRCluster(4, namenode, 2);
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            JobConf jobConf = new JobConf();
            boolean result = TestEmptyJobWithDFS.launchEmptyJob(namenode, jobTrackerName, jobConf, 3, 1);
            TestEmptyJobWithDFS.assertTrue((boolean)result);
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

