/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputLogFilter;
import org.apache.hadoop.mapred.TextInputFormat;

public class TestMiniMRClasspath
extends TestCase {
    static String launchWordCount(String fileSys, String jobTracker, JobConf conf, String input, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/wc/input");
        Path outDir = new Path("/testing/wc/output");
        FileSystem fs = FileSystem.getNamed((String)fileSys, (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        FileSystem.setDefaultUri((Configuration)conf, (String)fileSys);
        conf.set("mapred.job.tracker", jobTracker);
        conf.setJobName("wordcount");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.set("mapred.mapper.class", "testjar.ClassWordCount$MapClass");
        conf.set("mapred.combine.class", "testjar.ClassWordCount$Reduce");
        conf.set("mapred.reducer.class", "testjar.ClassWordCount$Reduce");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        conf.setJar("build/test/testjar/testjob.jar");
        JobClient.runJob((JobConf)conf);
        StringBuffer result = new StringBuffer();
        Path[] parents = FileUtil.stat2Paths((FileStatus[])fs.listStatus(outDir.getParent()));
        Path[] fileList = FileUtil.stat2Paths((FileStatus[])fs.listStatus(outDir, (PathFilter)new OutputLogFilter()));
        for (int i = 0; i < fileList.length; ++i) {
            BufferedReader file2 = new BufferedReader(new InputStreamReader((InputStream)fs.open(fileList[i])));
            String line = file2.readLine();
            while (line != null) {
                result.append(line);
                result.append("\n");
                line = file2.readLine();
            }
            file2.close();
        }
        return result.toString();
    }

    static String launchExternal(String fileSys, String jobTracker, JobConf conf, String input, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/ext/input");
        Path outDir = new Path("/testing/ext/output");
        FileSystem fs = FileSystem.getNamed((String)fileSys, (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        FileSystem.setDefaultUri((Configuration)conf, (String)fileSys);
        conf.set("mapred.job.tracker", jobTracker);
        conf.setJobName("wordcount");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.set("mapred.output.key.class", "testjar.ExternalWritable");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        conf.set("mapred.mapper.class", "testjar.ExternalMapperReducer");
        conf.set("mapred.reducer.class", "testjar.ExternalMapperReducer");
        conf.setJar("build/test/testjar/testjob.jar");
        JobClient.runJob((JobConf)conf);
        StringBuffer result = new StringBuffer();
        Path[] fileList = FileUtil.stat2Paths((FileStatus[])fs.listStatus(outDir, (PathFilter)new OutputLogFilter()));
        for (int i = 0; i < fileList.length; ++i) {
            BufferedReader file2 = new BufferedReader(new InputStreamReader((InputStream)fs.open(fileList[i])));
            String line = file2.readLine();
            while (line != null) {
                result.append(line);
                line = file2.readLine();
                result.append("\n");
            }
            file2.close();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassPath() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            int jobTrackerPort = 60050;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getName();
            mr = new MiniMRCluster(4, namenode, 3);
            JobConf jobConf = new JobConf();
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            String result = TestMiniMRClasspath.launchWordCount(namenode, jobTrackerName, jobConf, "The quick brown fox\nhas many silly\nred fox sox\n", 3, 1);
            TestMiniMRClasspath.assertEquals((String)"The\t1\nbrown\t1\nfox\t2\nhas\t1\nmany\t1\nquick\t1\nred\t1\nsilly\t1\nsox\t1\n", (String)result);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExternalWritable() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getName();
            mr = new MiniMRCluster(4, namenode, 3);
            JobConf jobConf = new JobConf();
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            String result = TestMiniMRClasspath.launchExternal(namenode, jobTrackerName, jobConf, "Dennis was here!\nDennis again!", 3, 1);
            TestMiniMRClasspath.assertEquals((String)"Dennis again!\t1\nDennis was here!\t1\n", (String)result);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

