/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRWithDFS;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class TestMiniMRWithDFSWithDistinctUsers
extends TestCase {
    static final long now = System.currentTimeMillis();
    static final UnixUserGroupInformation DFS_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("dfs", true);
    static final UnixUserGroupInformation PI_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("pi", false);
    static final UnixUserGroupInformation WC_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("wc", false);

    static UnixUserGroupInformation createUGI(String name, boolean issuper) {
        String username = name + now;
        String group = issuper ? "supergroup" : username;
        return UnixUserGroupInformation.createImmutable((String[])new String[]{username, group});
    }

    static JobConf createJobConf(MiniMRCluster mr, UnixUserGroupInformation ugi) {
        JobConf jobconf = mr.createJobConf();
        UnixUserGroupInformation.saveToConf((Configuration)jobconf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)ugi);
        return jobconf;
    }

    static void mkdir(FileSystem fs, String dir) throws IOException {
        Path p = new Path(dir);
        fs.mkdirs(p);
        fs.setPermission(p, new FsPermission(511));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctUsers() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            UnixUserGroupInformation.saveToConf((Configuration)conf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)DFS_UGI);
            dfs = new MiniDFSCluster(conf, 4, true, null);
            FileSystem fs = dfs.getFileSystem();
            TestMiniMRWithDFSWithDistinctUsers.mkdir(fs, "/user");
            TestMiniMRWithDFSWithDistinctUsers.mkdir(fs, "/mapred");
            UnixUserGroupInformation MR_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI(UnixUserGroupInformation.login().getUserName(), false);
            mr = new MiniMRCluster(0, 0, 4, dfs.getFileSystem().getUri().toString(), 1, null, null, MR_UGI);
            JobConf pi = TestMiniMRWithDFSWithDistinctUsers.createJobConf(mr, PI_UGI);
            TestMiniMRWithDFS.runPI(mr, pi);
            JobConf wc = TestMiniMRWithDFSWithDistinctUsers.createJobConf(mr, WC_UGI);
            TestMiniMRWithDFS.runWordCount(mr, wc);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

