/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;

public class TestParallelInitialization
extends TestCase {
    private static int jobCounter;
    private static final int NUM_JOBS = 3;
    IntWritable numJobsCompleted = new IntWritable();
    protected JobConf jobConf;
    protected TaskScheduler scheduler;
    private FakeTaskTrackerManager taskTrackerManager;

    static void resetCounters() {
        jobCounter = 0;
    }

    protected void setUp() throws Exception {
        TestParallelInitialization.resetCounters();
        this.jobConf = new JobConf();
        this.taskTrackerManager = new FakeTaskTrackerManager();
        this.scheduler = this.createTaskScheduler();
        this.scheduler.setConf((Configuration)this.jobConf);
        this.scheduler.setTaskTrackerManager((TaskTrackerManager)this.taskTrackerManager);
        this.scheduler.start();
    }

    protected void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.terminate();
        }
    }

    protected TaskScheduler createTaskScheduler() {
        return new JobQueueTaskScheduler();
    }

    public void testParallelInitJobs() throws IOException {
        FakeJobInProgress[] jobs = new FakeJobInProgress[3];
        for (int i = 0; i < 3; ++i) {
            jobs[i] = new FakeJobInProgress(this.jobConf, this.taskTrackerManager);
            jobs[i].getStatus().setRunState(4);
            this.taskTrackerManager.submitJob(jobs[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            TestParallelInitialization.assertTrue((jobs[i].getStatus().getRunState() == 2 ? 1 : 0) != 0);
        }
    }

    static class FakeTaskTrackerManager
    implements TaskTrackerManager {
        int maps = 0;
        int reduces = 0;
        int maxMapTasksPerTracker = 2;
        int maxReduceTasksPerTracker = 2;
        List<JobInProgressListener> listeners = new ArrayList<JobInProgressListener>();
        QueueManager queueManager;
        private Map<String, TaskTrackerStatus> trackers = new HashMap<String, TaskTrackerStatus>();

        public FakeTaskTrackerManager() {
            JobConf conf = new JobConf();
            this.queueManager = new QueueManager((Configuration)conf);
            this.trackers.put("tt1", new TaskTrackerStatus("tt1", "tt1.host", 1, new ArrayList(), 0, this.maxMapTasksPerTracker, this.maxReduceTasksPerTracker));
        }

        public ClusterStatus getClusterStatus() {
            int numTrackers = this.trackers.size();
            return new ClusterStatus(numTrackers, 0, JobTracker.TASKTRACKER_EXPIRY_INTERVAL, this.maps, this.reduces, numTrackers * this.maxMapTasksPerTracker, numTrackers * this.maxReduceTasksPerTracker, JobTracker.State.RUNNING);
        }

        public int getNumberOfUniqueHosts() {
            return 0;
        }

        public Collection<TaskTrackerStatus> taskTrackers() {
            return this.trackers.values();
        }

        public void addJobInProgressListener(JobInProgressListener listener) {
            this.listeners.add(listener);
        }

        public void removeJobInProgressListener(JobInProgressListener listener) {
            this.listeners.remove(listener);
        }

        public QueueManager getQueueManager() {
            return this.queueManager;
        }

        public int getNextHeartbeatInterval() {
            return 3000;
        }

        public void killJob(JobID jobid) {
        }

        public JobInProgress getJob(JobID jobid) {
            return null;
        }

        public void submitJob(JobInProgress job) throws IOException {
            for (JobInProgressListener listener : this.listeners) {
                listener.jobAdded(job);
            }
        }
    }

    class FakeJobInProgress
    extends JobInProgress {
        public FakeJobInProgress(JobConf jobConf, FakeTaskTrackerManager taskTrackerManager) throws IOException {
            super(new JobID("test", ++jobCounter), jobConf);
            this.startTime = System.currentTimeMillis();
            this.status = new JobStatus(this.getJobID(), 0.0f, 0.0f, 4);
            this.status.setJobPriority(JobPriority.NORMAL);
            this.status.setStartTime(this.startTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void initTasks() throws IOException {
            try {
                int jobNumber = this.getJobID().getId();
                IntWritable intWritable = TestParallelInitialization.this.numJobsCompleted;
                synchronized (intWritable) {
                    while (TestParallelInitialization.this.numJobsCompleted.get() != 3 - jobNumber) {
                        TestParallelInitialization.this.numJobsCompleted.wait();
                    }
                    TestParallelInitialization.this.numJobsCompleted.set(TestParallelInitialization.this.numJobsCompleted.get() + 1);
                    TestParallelInitialization.this.numJobsCompleted.notifyAll();
                    LOG.info((Object)("JobNumber " + jobNumber + " succeeded"));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.status.setRunState(2);
        }

        synchronized void fail() {
            this.status.setRunState(3);
        }
    }
}

