/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Arrays;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TestMapCollection;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestReduceFetch
extends TestCase {
    private static MiniMRCluster mrCluster = null;
    private static MiniDFSCluster dfsCluster = null;

    public static Test suite() {
        TestSetup setup = new TestSetup((Test)new TestSuite(TestReduceFetch.class)){

            protected void setUp() throws Exception {
                Configuration conf = new Configuration();
                dfsCluster = new MiniDFSCluster(conf, 2, true, null);
                mrCluster = new MiniMRCluster(2, dfsCluster.getFileSystem().getUri().toString(), 1);
            }

            protected void tearDown() throws Exception {
                if (dfsCluster != null) {
                    dfsCluster.shutdown();
                }
                if (mrCluster != null) {
                    mrCluster.shutdown();
                }
            }
        };
        return setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters runJob(JobConf conf) throws Exception {
        conf.setMapperClass(MapMB.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setNumReduceTasks(1);
        conf.setInputFormat(TestMapCollection.FakeIF.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path("/in")});
        Path outp = new Path("/out");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outp);
        RunningJob job = null;
        try {
            job = JobClient.runJob((JobConf)conf);
            TestReduceFetch.assertTrue((boolean)job.isSuccessful());
        }
        finally {
            FileSystem fs = dfsCluster.getFileSystem();
            if (fs.exists(outp)) {
                fs.delete(outp, true);
            }
        }
        return job.getCounters();
    }

    public void testReduceFromDisk() throws Exception {
        JobConf job = mrCluster.createJobConf();
        job.set("mapred.job.reduce.input.buffer.percent", "0.0");
        job.setNumMapTasks(3);
        Counters c = TestReduceFetch.runJob(job);
        long hdfsWritten = c.findCounter("FileSystemCounters", Task.getFileSystemCounterNames((String)"hdfs")[1]).getCounter();
        long localRead = c.findCounter("FileSystemCounters", Task.getFileSystemCounterNames((String)"file")[0]).getCounter();
        TestReduceFetch.assertTrue((String)("Expected more bytes read from local (" + localRead + ") than written to HDFS (" + hdfsWritten + ")"), (hdfsWritten <= localRead ? 1 : 0) != 0);
    }

    public void testReduceFromPartialMem() throws Exception {
        JobConf job = mrCluster.createJobConf();
        job.setNumMapTasks(5);
        job.setInt("mapred.inmem.merge.threshold", 0);
        job.set("mapred.job.reduce.input.buffer.percent", "1.0");
        job.setInt("mapred.reduce.parallel.copies", 1);
        job.setInt("io.sort.mb", 10);
        job.set("mapred.child.java.opts", "-Xmx128m");
        job.set("mapred.job.shuffle.input.buffer.percent", "0.14");
        job.setNumTasksToExecutePerJvm(1);
        job.set("mapred.job.shuffle.merge.percent", "1.0");
        Counters c = TestReduceFetch.runJob(job);
        long hdfsWritten = c.findCounter("FileSystemCounters", Task.getFileSystemCounterNames((String)"hdfs")[1]).getCounter();
        long localRead = c.findCounter("FileSystemCounters", Task.getFileSystemCounterNames((String)"file")[0]).getCounter();
        TestReduceFetch.assertTrue((String)("Expected at least 1MB fewer bytes read from local (" + localRead + ") than written to HDFS (" + hdfsWritten + ")"), (hdfsWritten >= localRead + 0x100000L ? 1 : 0) != 0);
    }

    public void testReduceFromMem() throws Exception {
        JobConf job = mrCluster.createJobConf();
        job.set("mapred.job.reduce.input.buffer.percent", "1.0");
        job.setNumMapTasks(3);
        Counters c = TestReduceFetch.runJob(job);
        long localRead = c.findCounter("FileSystemCounters", Task.getFileSystemCounterNames((String)"file")[0]).getCounter();
        TestReduceFetch.assertTrue((String)("Non-zero read from local: " + localRead), (localRead == 0L ? 1 : 0) != 0);
    }

    public static class MapMB
    implements Mapper<NullWritable, NullWritable, Text, Text> {
        public void map(NullWritable nk, NullWritable nv, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            Text key = new Text();
            Text val = new Text();
            key.set("KEYKEYKEYKEYKEYKEYKEYKEY");
            byte[] b = new byte[1000];
            Arrays.fill(b, (byte)86);
            val.set(b);
            b = null;
            for (int i = 0; i < 4096; ++i) {
                output.collect((Object)key, (Object)val);
            }
        }

        public void configure(JobConf conf) {
        }

        public void close() throws IOException {
        }
    }
}

