/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WordCount;

public class TestSpilledRecordsCounter
extends TestCase {
    private void validateCounters(Counters counter, long spillRecCnt) {
        TestSpilledRecordsCounter.assertEquals((long)counter.findCounter((Enum)Task.Counter.SPILLED_RECORDS).getCounter(), (long)spillRecCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWordsFile(File inpFile) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(inpFile));
        try {
            int REPLICAS = 5;
            int NUMLINES = 500;
            int NUMWORDSPERLINE = 4;
            for (int i = 0; i < REPLICAS; ++i) {
                for (int j = 1; j <= NUMLINES * NUMWORDSPERLINE; j += NUMWORDSPERLINE) {
                    out.write("word" + j + " word" + (j + 1) + " word" + (j + 2) + " word" + (j + 3) + '\n');
                }
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpillCounter() throws Exception {
        JobConf conf = new JobConf(TestSpilledRecordsCounter.class);
        conf.setJobName("wordcountSpilledRecordsCounter");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        conf.setNumMapTasks(3);
        conf.setNumReduceTasks(1);
        conf.setInt("io.sort.mb", 1);
        conf.setInt("io.sort.factor", 2);
        conf.set("io.sort.record.percent", "0.05");
        conf.set("io.sort.spill.percent", "0.80");
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", File.separator + "tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        String IN_DIR = TEST_ROOT_DIR + File.separator + "spilledRecords.countertest" + File.separator + "genins" + File.separator;
        String OUT_DIR = TEST_ROOT_DIR + File.separator + "spilledRecords.countertest" + File.separator;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testdir = new Path(TEST_ROOT_DIR, "spilledRecords.countertest");
        try {
            if (fs.exists(testdir)) {
                fs.delete(testdir, true);
            }
            if (!fs.mkdirs(testdir)) {
                throw new IOException("Mkdirs failed to create " + testdir.toString());
            }
            Path wordsIns = new Path(testdir, "genins");
            if (!fs.mkdirs(wordsIns)) {
                throw new IOException("Mkdirs failed to create " + wordsIns.toString());
            }
            File inpFile = new File(IN_DIR + "input5_2k_1");
            this.createWordsFile(inpFile);
            inpFile = new File(IN_DIR + "input5_2k_2");
            this.createWordsFile(inpFile);
            inpFile = new File(IN_DIR + "input5_2k_3");
            this.createWordsFile(inpFile);
            FileInputFormat.setInputPaths((JobConf)conf, (String)IN_DIR);
            Path outputPath1 = new Path(OUT_DIR, "output5_2k_3");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath1);
            RunningJob myJob = JobClient.runJob((JobConf)conf);
            Counters c1 = myJob.getCounters();
            this.validateCounters(c1, 64000L);
            inpFile = new File(IN_DIR + "input5_2k_4");
            this.createWordsFile(inpFile);
            conf.setNumMapTasks(4);
            Path outputPath2 = new Path(OUT_DIR, "output5_2k_4");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath2);
            myJob = JobClient.runJob((JobConf)conf);
            c1 = myJob.getCounters();
            this.validateCounters(c1, 88000L);
        }
        finally {
            if (fs.exists(testdir)) {
                fs.delete(testdir, true);
            }
        }
    }
}

