/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.mapred.DummyMemoryCalculatorPlugin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.util.MemoryCalculatorPlugin;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestTaskTrackerMemoryManager
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestTaskTrackerMemoryManager.class);
    private MiniDFSCluster miniDFSCluster;
    private MiniMRCluster miniMRCluster;
    private String taskOverLimitPatternString = "TaskTree \\[pid=[0-9]*,tipID=.*\\] is running beyond memory-limits. Current usage : [0-9]*bytes. Limit : %sbytes. Killing task.";

    private void startCluster(JobConf conf) throws Exception {
        this.miniDFSCluster = new MiniDFSCluster((Configuration)conf, 1, true, null);
        FileSystem fileSys = this.miniDFSCluster.getFileSystem();
        String namenode = fileSys.getUri().toString();
        this.miniMRCluster = new MiniMRCluster(1, namenode, 1, null, null, conf);
    }

    protected void tearDown() {
        if (this.miniMRCluster != null) {
            this.miniMRCluster.shutdown();
        }
        if (this.miniDFSCluster != null) {
            this.miniDFSCluster.shutdown();
        }
    }

    private void runSleepJob(JobConf conf) throws Exception {
        String[] args = new String[]{"-m", "3", "-r", "1", "-mt", "3000", "-rt", "1000"};
        ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
    }

    private void runAndCheckSuccessfulJob(JobConf conf) throws IOException {
        TaskCompletionEvent[] taskComplEvents;
        JobTracker jt = this.miniMRCluster.getJobTrackerRunner().getJobTracker();
        conf.set("mapred.job.tracker", jt.getJobTrackerMachine() + ":" + jt.getTrackerPort());
        NameNode nn = this.miniDFSCluster.getNameNode();
        conf.set("fs.default.name", "hdfs://" + nn.getNameNodeAddress().getHostName() + ":" + nn.getNameNodeAddress().getPort());
        Pattern taskOverLimitPattern = Pattern.compile(String.format(this.taskOverLimitPatternString, "[0-9]*"));
        Matcher mat = null;
        boolean success = true;
        try {
            this.runSleepJob(conf);
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        TestTaskTrackerMemoryManager.assertTrue((boolean)success);
        JobClient jClient = new JobClient(conf);
        JobStatus[] jStatus = jClient.getAllJobs();
        JobStatus js = jStatus[0];
        RunningJob rj = jClient.getJob(js.getJobID());
        for (TaskCompletionEvent tce : taskComplEvents = rj.getTaskCompletionEvents(0)) {
            String[] diagnostics = rj.getTaskDiagnostics(tce.getTaskAttemptId());
            if (diagnostics == null) continue;
            for (String str : diagnostics) {
                mat = taskOverLimitPattern.matcher(str);
                TestTaskTrackerMemoryManager.assertFalse((boolean)mat.find());
            }
        }
    }

    private boolean isProcfsBasedTreeAvailable() {
        try {
            if (!ProcfsBasedProcessTree.isAvailable()) {
                LOG.info((Object)"Currently ProcessTree has only one implementation ProcfsBasedProcessTree, which is not available on this system. Not testing");
                return false;
            }
        }
        catch (Exception e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return false;
        }
        return true;
    }

    public void testTTLimitsDisabled() throws Exception {
        if (!this.isProcfsBasedTreeAvailable()) {
            return;
        }
        JobConf conf = new JobConf();
        this.startCluster(conf);
        long PER_TASK_LIMIT = 100L;
        conf.setMaxVirtualMemoryForTask(PER_TASK_LIMIT);
        this.runAndCheckSuccessfulJob(conf);
    }

    public void testTasksWithNoLimits() throws Exception {
        if (!this.isProcfsBasedTreeAvailable()) {
            return;
        }
        long ttLimit = 0x100000000L;
        JobConf fConf = new JobConf();
        fConf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
        fConf.setLong("mapred.tasktracker.maxvmem.testing", ttLimit);
        fConf.setLong("mapred.task.default.maxvmem", ttLimit);
        fConf.setLong("mapred.task.limit.maxvmem", ttLimit);
        fConf.setLong("mapred.tasktracker.vmem.reserved", 0L);
        this.startCluster(fConf);
        JobConf conf = new JobConf();
        this.runAndCheckSuccessfulJob(conf);
    }

    public void testTasksWithinLimits() throws Exception {
        if (!this.isProcfsBasedTreeAvailable()) {
            return;
        }
        long PER_TASK_LIMIT = 0x80000000L;
        long TASK_TRACKER_LIMIT = 0x100000000L;
        JobConf fConf = new JobConf();
        fConf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
        fConf.setLong("mapred.tasktracker.maxvmem.testing", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.default.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.limit.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.tasktracker.vmem.reserved", 0L);
        this.startCluster(fConf);
        JobConf conf = new JobConf();
        conf.setMaxVirtualMemoryForTask(PER_TASK_LIMIT);
        this.runAndCheckSuccessfulJob(conf);
    }

    public void testTasksBeyondLimits() throws Exception {
        TaskCompletionEvent[] taskComplEvents;
        if (!this.isProcfsBasedTreeAvailable()) {
            return;
        }
        long PER_TASK_LIMIT = 444L;
        long TASK_TRACKER_LIMIT = 0x100000000L;
        Pattern taskOverLimitPattern = Pattern.compile(String.format(this.taskOverLimitPatternString, String.valueOf(PER_TASK_LIMIT)));
        Matcher mat = null;
        JobConf fConf = new JobConf();
        fConf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
        fConf.setLong("mapred.tasktracker.maxvmem.testing", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.default.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.limit.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.tasktracker.vmem.reserved", 0L);
        fConf.set("mapred.tasktracker.taskmemorymanager.monitoring-interval", String.valueOf(300));
        this.startCluster(fConf);
        JobConf conf = new JobConf();
        conf.setMaxVirtualMemoryForTask(PER_TASK_LIMIT);
        JobTracker jt = this.miniMRCluster.getJobTrackerRunner().getJobTracker();
        conf.set("mapred.job.tracker", jt.getJobTrackerMachine() + ":" + jt.getTrackerPort());
        NameNode nn = this.miniDFSCluster.getNameNode();
        conf.set("fs.default.name", "hdfs://" + nn.getNameNodeAddress().getHostName() + ":" + nn.getNameNodeAddress().getPort());
        boolean success = true;
        try {
            this.runSleepJob(conf);
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        TestTaskTrackerMemoryManager.assertFalse((boolean)success);
        JobClient jClient = new JobClient(conf);
        JobStatus[] jStatus = jClient.getAllJobs();
        JobStatus js = jStatus[0];
        RunningJob rj = jClient.getJob(js.getJobID());
        for (TaskCompletionEvent tce : taskComplEvents = rj.getTaskCompletionEvents(0)) {
            assert (tce.getTaskStatus() == TaskCompletionEvent.Status.TIPFAILED || tce.getTaskStatus() == TaskCompletionEvent.Status.FAILED);
            String[] diagnostics = rj.getTaskDiagnostics(tce.getTaskAttemptId());
            assert (diagnostics != null);
            for (String str : diagnostics) {
                mat = taskOverLimitPattern.matcher(str);
                TestTaskTrackerMemoryManager.assertTrue((boolean)mat.find());
            }
        }
    }

    public void testTasksCumulativelyExceedingTTLimits() throws Exception {
        if (!this.isProcfsBasedTreeAvailable()) {
            return;
        }
        long PER_TASK_LIMIT = 100000000000L;
        long TASK_TRACKER_LIMIT = 100L;
        Pattern taskOverLimitPattern = Pattern.compile(String.format(this.taskOverLimitPatternString, String.valueOf(PER_TASK_LIMIT)));
        Pattern trackerOverLimitPattern = Pattern.compile("Killing one of the least progress tasks - .*, as the cumulative memory usage of all the tasks on the TaskTracker exceeds virtual memory limit " + TASK_TRACKER_LIMIT + ".");
        Matcher mat = null;
        JobConf fConf = new JobConf();
        fConf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
        fConf.setLong("mapred.tasktracker.maxvmem.testing", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.default.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.task.limit.maxvmem", TASK_TRACKER_LIMIT);
        fConf.setLong("mapred.tasktracker.vmem.reserved", 0L);
        fConf.set("mapred.tasktracker.taskmemorymanager.monitoring-interval", String.valueOf(300));
        this.startCluster(fConf);
        JobConf conf = new JobConf();
        conf.setMaxVirtualMemoryForTask(PER_TASK_LIMIT);
        JobTracker jt = this.miniMRCluster.getJobTrackerRunner().getJobTracker();
        conf.set("mapred.job.tracker", jt.getJobTrackerMachine() + ":" + jt.getTrackerPort());
        NameNode nn = this.miniDFSCluster.getNameNode();
        conf.set("fs.default.name", "hdfs://" + nn.getNameNodeAddress().getHostName() + ":" + nn.getNameNodeAddress().getPort());
        JobClient jClient = new JobClient(conf);
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf((Configuration)conf);
        RunningJob job = jClient.submitJob(sleepJob.setupJobConf(1, 1, 5000L, 1, 1000L, 1));
        boolean TTOverFlowMsgPresent = false;
        while (true) {
            TaskReport[] setUpReports;
            for (TaskReport tr : setUpReports = jt.getSetupTaskReports(job.getID())) {
                String[] diag;
                for (String str : diag = tr.getDiagnostics()) {
                    mat = taskOverLimitPattern.matcher(str);
                    TestTaskTrackerMemoryManager.assertFalse((boolean)mat.find());
                    mat = trackerOverLimitPattern.matcher(str);
                    if (!mat.find()) continue;
                    TTOverFlowMsgPresent = true;
                }
            }
            if (TTOverFlowMsgPresent) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        job.killJob();
    }
}

