/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SecondarySort;
import org.apache.hadoop.examples.WordCount;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TestMapReduceLocal
extends TestCase {
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
    private static Configuration conf = new Configuration();
    private static FileSystem localFs;

    public Path writeFile(String name, String data) throws IOException {
        Path file = new Path(TEST_ROOT_DIR + "/" + name);
        localFs.delete(file, false);
        FSDataOutputStream f = localFs.create(file);
        f.write(data.getBytes());
        f.close();
        return file;
    }

    public String readFile(String name) throws IOException {
        FSDataInputStream f = localFs.open(new Path(TEST_ROOT_DIR + "/" + name));
        BufferedReader b = new BufferedReader(new InputStreamReader((InputStream)f));
        StringBuilder result = new StringBuilder();
        String line = b.readLine();
        while (line != null) {
            result.append(line);
            result.append('\n');
            line = b.readLine();
        }
        b.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithLocal() throws Exception {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            JobConf conf = mr.createJobConf();
            this.runWordCount((Configuration)conf);
            this.runSecondarySort((Configuration)conf);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private void runWordCount(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        String COUNTER_GROUP = "org.apache.hadoop.mapred.Task$Counter";
        localFs.delete(new Path(TEST_ROOT_DIR + "/in"), true);
        localFs.delete(new Path(TEST_ROOT_DIR + "/out"), true);
        this.writeFile("in/part1", "this is a test\nof word count test\ntest\n");
        this.writeFile("in/part2", "more test");
        Job job = new Job(conf, "word count");
        job.setJarByClass(WordCount.class);
        job.setMapperClass(WordCount.TokenizerMapper.class);
        job.setCombinerClass(WordCount.IntSumReducer.class);
        job.setReducerClass(WordCount.IntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/in"));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/out"));
        TestMapReduceLocal.assertTrue((boolean)job.waitForCompletion(false));
        String out = this.readFile("out/part-r-00000");
        System.out.println(out);
        TestMapReduceLocal.assertEquals((String)"a\t1\ncount\t1\nis\t1\nmore\t1\nof\t1\ntest\t4\nthis\t1\nword\t1\n", (String)out);
        Counters ctrs = job.getCounters();
        System.out.println("Counters: " + ctrs);
        long combineIn = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "COMBINE_INPUT_RECORDS").getValue();
        long combineOut = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "COMBINE_OUTPUT_RECORDS").getValue();
        long reduceIn = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "REDUCE_INPUT_RECORDS").getValue();
        long mapOut = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_OUTPUT_RECORDS").getValue();
        TestMapReduceLocal.assertEquals((String)"map out = combine in", (long)mapOut, (long)combineIn);
        TestMapReduceLocal.assertEquals((String)"combine out = reduce in", (long)combineOut, (long)reduceIn);
        TestMapReduceLocal.assertTrue((String)"combine in > combine out", (combineIn > combineOut ? 1 : 0) != 0);
    }

    private void runSecondarySort(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        localFs.delete(new Path(TEST_ROOT_DIR + "/in"), true);
        localFs.delete(new Path(TEST_ROOT_DIR + "/out"), true);
        this.writeFile("in/part1", "-1 -4\n-3 23\n5 10\n-1 -2\n-1 300\n-1 10\n4 1\n4 2\n4 10\n4 -1\n4 -10\n10 20\n10 30\n10 25\n");
        Job job = new Job(conf, "word count");
        job.setJarByClass(WordCount.class);
        job.setMapperClass(SecondarySort.MapClass.class);
        job.setReducerClass(SecondarySort.Reduce.class);
        job.setPartitionerClass(SecondarySort.FirstPartitioner.class);
        job.setGroupingComparatorClass(SecondarySort.FirstGroupingComparator.class);
        job.setMapOutputKeyClass(SecondarySort.IntPair.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/in"));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/out"));
        TestMapReduceLocal.assertTrue((boolean)job.waitForCompletion(true));
        String out = this.readFile("out/part-r-00000");
        TestMapReduceLocal.assertEquals((String)"------------------------------------------------\n-3\t23\n------------------------------------------------\n-1\t-4\n-1\t-2\n-1\t10\n-1\t300\n------------------------------------------------\n4\t-10\n4\t-1\n4\t1\n4\t2\n4\t10\n------------------------------------------------\n5\t10\n------------------------------------------------\n10\t20\n10\t25\n10\t30\n", (String)out);
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
    }
}

