/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class TestProcfsBasedProcessTree
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestProcfsBasedProcessTree.class);
    private Shell.ShellCommandExecutor shexec = null;
    private String pidFile;
    private String shellScript;
    private static final int N = 10;
    private static final int memoryLimit = 0xF00000;
    private static final long PROCESSTREE_RECONSTRUCTION_INTERVAL = 5000L;

    private String getRogueTaskPID() {
        File f = new File(this.pidFile);
        while (!f.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return ProcfsBasedProcessTree.getPidFromPidFile((String)this.pidFile);
    }

    public void testProcessTree() {
        try {
            if (!ProcfsBasedProcessTree.isAvailable()) {
                System.out.println("ProcfsBasedProcessTree is not available on this system. Not testing");
                return;
            }
        }
        catch (Exception e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return;
        }
        Random rm = new Random();
        File tempFile = new File(this.getName() + "_shellScript_" + rm.nextInt() + ".sh");
        tempFile.deleteOnExit();
        this.shellScript = tempFile.getName();
        tempFile = new File(this.getName() + "_pidFile_" + rm.nextInt() + ".pid");
        tempFile.deleteOnExit();
        this.pidFile = tempFile.getName();
        try {
            FileWriter fWriter = new FileWriter(this.shellScript);
            fWriter.write("# rogue task\nsleep 10\necho hello\nif [ $1 -ne 0 ]\nthen\n sh " + this.shellScript + " $(($1-1))\n" + "fi");
            fWriter.close();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Error: " + ioe));
            return;
        }
        RogueTaskThread t = new RogueTaskThread();
        t.start();
        String pid = this.getRogueTaskPID();
        LOG.info((Object)("Root process pid: " + pid));
        ProcfsBasedProcessTree p = new ProcfsBasedProcessTree(pid);
        p = p.getProcessTree();
        try {
            while (true) {
                LOG.info((Object)("ProcessTree: " + p.toString()));
                long mem = p.getCumulativeVmem();
                LOG.info((Object)("Memory usage: " + mem + "bytes."));
                if (mem > 0xF00000L) {
                    p.destroy();
                    break;
                }
                Thread.sleep(5000L);
                p = p.getProcessTree();
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted.");
        }
        TestProcfsBasedProcessTree.assertFalse((String)"ProcessTree must have been gone", (boolean)p.isAlive());
        try {
            t.join(2000L);
            LOG.info((Object)"RogueTaskThread successfully joined.");
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while joining RogueTaskThread.");
        }
        p = p.getProcessTree();
        TestProcfsBasedProcessTree.assertFalse((String)"ProcessTree must have been gone", (boolean)p.isAlive());
        TestProcfsBasedProcessTree.assertTrue((String)("Cumulative vmem for the gone-process is " + p.getCumulativeVmem() + " . It should be zero."), (p.getCumulativeVmem() == 0L ? 1 : 0) != 0);
        TestProcfsBasedProcessTree.assertTrue((boolean)p.toString().equals("[ ]"));
    }

    private class RogueTaskThread
    extends Thread {
        private RogueTaskThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String[] args = new String[]{"bash", "-c", "echo $$ > " + TestProcfsBasedProcessTree.this.pidFile + "; sh " + TestProcfsBasedProcessTree.this.shellScript + " " + 10 + ";"};
                TestProcfsBasedProcessTree.this.shexec = new Shell.ShellCommandExecutor(args);
                TestProcfsBasedProcessTree.this.shexec.execute();
            }
            catch (Shell.ExitCodeException ee) {
                LOG.info((Object)("Shell Command exit with a non-zero exit code. " + (Object)((Object)ee)));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Error executing shell command " + ioe));
            }
            finally {
                LOG.info((Object)("Exit code: " + TestProcfsBasedProcessTree.this.shexec.getExitCode()));
            }
        }
    }
}

