/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nagios;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.nagios.Nsca;
import org.apache.log4j.spi.LoggingEvent;

public class NagiosAppender
extends AppenderSkeleton {
    private static final int TRANSMITTED_IV_SIZE = 128;
    protected static final int ENCRYPT_NONE = 0;
    protected static final int ENCRYPT_XOR = 1;
    private String config_file = null;
    private int encryption_method = 0;
    private String nsca_password = null;
    private String host = null;
    private String port = null;
    private String service_name = "UNKNOWN_SERVICE";
    protected static final int DO_NOT_SEND = -1;
    protected static final int NAGIOS_OK = 0;
    protected static final int NAGIOS_WARN = 1;
    protected static final int NAGIOS_CRITICAL = 2;
    protected static final int NAGIOS_UNKNOWN = 3;
    private int Log4j_Level_DEBUG = -1;
    private int Log4j_Level_INFO = -1;
    private int Log4j_Level_WARN = -1;
    private int Log4j_Level_ERROR = -1;
    private int Log4j_Level_FATAL = -1;
    private static final int LEVEL_DEBUG = 10000;
    private boolean use_MDC_for_hostname = false;
    private boolean use_MDC_for_servicename = false;
    private String MDC_service_name_key = null;
    private boolean short_hostname = true;
    private String MDC_hostname_key = null;
    private int nsca_version = 3;
    private static Properties Nagios_levels = new Properties();
    private String layoutPartsDelimiter = "#";
    private int buffer_size = 1;
    private ArrayList buffer = new ArrayList();
    private boolean ready = false;
    private TreeMap includeFilters = null;
    private TreeMap excludeFilters = null;
    private boolean includeFilterEnabled = false;
    private boolean excludeFilterEnabled = false;
    private String startupMsg = null;
    private String startupMsgLevel = null;
    private TreeMap initialMsgs = new TreeMap();
    private Nsca nagiosClient = new Nsca();

    public NagiosAppender() {
    }

    public NagiosAppender(Layout layout) {
        this.setLayout(layout);
    }

    public void setLayout(Layout layout) {
        super.setLayout(layout);
    }

    public void setConfigFile(String value) {
        try {
            this.nagiosClient.setConfigFile(value);
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::setConfigFile(), error reading config file: " + e.getMessage();
            LogLog.error((String)errorMsg);
            this.errorHandler.error(errorMsg, null, 0);
        }
    }

    public void setIncludeFilterEnabled(String value) {
        this.includeFilterEnabled = Boolean.valueOf(value);
    }

    public void setExcludeFilterEnabled(String value) {
        this.excludeFilterEnabled = Boolean.valueOf(value);
    }

    public void setEncryptionMethod(int value) {
        if (value < 0) {
            return;
        }
        this.encryption_method = value;
    }

    public void setPassword(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.nsca_password = value;
    }

    public void setHost(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.host = value;
    }

    public void setPort(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.port = value;
    }

    public void setServiceNameDefault(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.service_name = value;
    }

    public void setUseMDCHostName(boolean value) {
        this.use_MDC_for_hostname = value;
    }

    public void setUseMDCServiceName(boolean value) {
        this.use_MDC_for_servicename = value;
    }

    public void setMDCServiceNameKey(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.MDC_service_name_key = value;
    }

    public void setMDCHostNameKey(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.MDC_hostname_key = value;
    }

    public void setInitializeMDCHostNameValue(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        if (null != this.MDC_hostname_key) {
            MDC.put((String)this.MDC_hostname_key, (Object)value);
        }
    }

    public void setMDCCanonicalHostNameKey(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            String nagios_canonical_hostname = "nagios_canonical_hostname";
            if (null == MDC.get((String)nagios_canonical_hostname)) {
                MDC.put((String)value, (Object)address.getCanonicalHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPatternFilterFile(String filterFile) {
        try {
            this.includeFilters = new TreeMap();
            this.excludeFilters = new TreeMap();
            BufferedReader in = new BufferedReader(new FileReader(filterFile));
            String nextLine = in.readLine();
            while (null != nextLine) {
                String regex;
                if (nextLine.toLowerCase().startsWith("includefilter=") && null != (regex = nextLine.substring(nextLine.indexOf(61) + 1, nextLine.length())) && regex.trim().length() > 0) {
                    this.includeFilters.put(regex, Pattern.compile(regex));
                }
                if (nextLine.toLowerCase().startsWith("excludefilter=") && null != (regex = nextLine.substring(nextLine.indexOf(61) + 1, nextLine.length())) && regex.trim().length() > 0) {
                    this.excludeFilters.put(regex, Pattern.compile(regex));
                }
                nextLine = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::setPatternFilterFile() - File open error: " + filterFile;
            LogLog.error((String)errorMsg, (Throwable)e);
            this.errorHandler.error(errorMsg, e, 0);
        }
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setUseShortHostName(boolean value) {
        this.short_hostname = value;
    }

    public String getServiceNameDefault() {
        return this.service_name;
    }

    public String getConfigFile() {
        return this.config_file;
    }

    public int getEncryptionMethod() {
        return this.encryption_method;
    }

    public String getPassword() {
        return this.nsca_password;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setLog4j_Level_DEBUG(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        switch (new Integer((String)Nagios_levels.get(value))) {
            case 0: {
                this.Log4j_Level_DEBUG = 0;
                break;
            }
            case 1: {
                this.Log4j_Level_DEBUG = 1;
                break;
            }
            case 2: {
                this.Log4j_Level_DEBUG = 2;
                break;
            }
            case 3: {
                this.Log4j_Level_DEBUG = 3;
                break;
            }
            default: {
                this.Log4j_Level_DEBUG = 3;
            }
        }
    }

    public String getLog4j_Level_DEBUG() {
        return "" + this.Log4j_Level_DEBUG;
    }

    public void setLog4j_Level_INFO(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        switch (new Integer((String)Nagios_levels.get(value))) {
            case 0: {
                this.Log4j_Level_INFO = 0;
                break;
            }
            case 1: {
                this.Log4j_Level_INFO = 1;
                break;
            }
            case 2: {
                this.Log4j_Level_INFO = 2;
                break;
            }
            case 3: {
                this.Log4j_Level_INFO = 3;
                break;
            }
            default: {
                this.Log4j_Level_INFO = 3;
            }
        }
    }

    public String getLog4j_Level_INFO() {
        return "" + this.Log4j_Level_INFO;
    }

    public void setLog4j_Level_WARN(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        switch (new Integer((String)Nagios_levels.get(value))) {
            case 0: {
                this.Log4j_Level_WARN = 0;
                break;
            }
            case 1: {
                this.Log4j_Level_WARN = 1;
                break;
            }
            case 2: {
                this.Log4j_Level_WARN = 2;
                break;
            }
            case 3: {
                this.Log4j_Level_WARN = 3;
                break;
            }
            default: {
                this.Log4j_Level_WARN = 3;
            }
        }
    }

    public String getLog4j_Level_WARN() {
        return "" + this.Log4j_Level_WARN;
    }

    public void setLog4j_Level_ERROR(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        switch (new Integer((String)Nagios_levels.get(value))) {
            case 0: {
                this.Log4j_Level_ERROR = 0;
                break;
            }
            case 1: {
                this.Log4j_Level_ERROR = 1;
                break;
            }
            case 2: {
                this.Log4j_Level_ERROR = 2;
                break;
            }
            case 3: {
                this.Log4j_Level_ERROR = 3;
                break;
            }
            default: {
                this.Log4j_Level_ERROR = 3;
            }
        }
    }

    public String getLog4j_Level_ERROR() {
        return "" + this.Log4j_Level_ERROR;
    }

    public void setLog4j_Level_FATAL(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        switch (new Integer((String)Nagios_levels.get(value))) {
            case 0: {
                this.Log4j_Level_FATAL = 0;
                break;
            }
            case 1: {
                this.Log4j_Level_FATAL = 1;
                break;
            }
            case 2: {
                this.Log4j_Level_FATAL = 2;
                break;
            }
            case 3: {
                this.Log4j_Level_FATAL = 3;
                break;
            }
            default: {
                this.Log4j_Level_FATAL = 3;
            }
        }
    }

    public String getLog4j_Level_FATAL() {
        return "" + this.Log4j_Level_FATAL;
    }

    public void setSendStartupMessageOK(String msg) {
        this.setSendStartupMessage("0", msg);
    }

    public void setSendStartupMessageUNKNOWN(String msg) {
        this.setSendStartupMessage("3", msg);
    }

    public void setSendStartupMessageWARN(String msg) {
        this.setSendStartupMessage("1", msg);
    }

    public void setSendStartupMessageCRITICAL(String msg) {
        this.setSendStartupMessage("2", msg);
    }

    private void setSendStartupMessage(String nagiosLevel, String msg) {
        this.startupMsg = msg;
        this.startupMsgLevel = nagiosLevel;
    }

    private void sendMessage(String nagiosLevel, String msg) {
        String myClassName = ((Object)((Object)this)).getClass().getName();
        LoggingEvent event = new LoggingEvent(myClassName, Logger.getInstance(((Object)((Object)this)).getClass()), Priority.INFO, (Object)msg, null);
        try {
            if (this.nagiosClient.ready()) {
                this.send_nsca(event, this.stringToNagiosLevel(nagiosLevel));
            }
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::sendMessaage(), Not ready to append: " + e.getMessage();
            LogLog.error((String)errorMsg);
            this.errorHandler.error(errorMsg, null, 0);
        }
    }

    private int stringToNagiosLevel(String levelAsString) {
        try {
            int nagiosLevel = new Integer(levelAsString);
            switch (nagiosLevel) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return nagiosLevel;
                }
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void append(LoggingEvent event) {
        if (event.getLevel().equals((Object)Level.DEBUG) && this.Log4j_Level_DEBUG == -1) {
            return;
        }
        if (event.getLevel().equals((Object)Level.INFO) && this.Log4j_Level_INFO == -1) {
            return;
        }
        if (event.getLevel().equals((Object)Level.WARN) && this.Log4j_Level_WARN == -1) {
            return;
        }
        if (event.getLevel().equals((Object)Level.ERROR) && this.Log4j_Level_ERROR == -1) {
            return;
        }
        if (event.getLevel().equals((Object)Level.FATAL) && this.Log4j_Level_FATAL == -1) {
            return;
        }
        switch (event.getLevel().toInt()) {
            case 10000: 
            case 20000: 
            case 30000: 
            case 40000: 
            case 50000: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.includeFilterEnabled && this.failedRegexIncludeFilter(event)) {
            return;
        }
        if (this.excludeFilterEnabled && this.failedRegexExcludeFilter(event)) {
            return;
        }
        try {
            if (!this.nagiosClient.ready() && !this.nagiosClient.ready()) {
                String errorMsg = "NagiosAppender::append(), Not ready to append !";
                LogLog.error((String)errorMsg);
                this.errorHandler.error(errorMsg, null, 0);
                return;
            }
            this.buffer.add(event);
            if (this.buffer_size > 1) {
                event.getNDC();
                event.getThreadName();
                event.getMDCCopy();
                event.getLocationInformation();
            }
            if (this.buffer.size() >= this.buffer_size) {
                this.flush_buffer();
            }
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::append(), ";
            LogLog.error((String)errorMsg, (Throwable)e);
            this.errorHandler.error(errorMsg, e, 0);
        }
    }

    public void send(String event, int return_code) {
        try {
            if (!this.nagiosClient.ready() && !this.nagiosClient.ready()) {
                String errorMsg = "NagiosAppender::append(), Not ready to append !";
                LogLog.error((String)errorMsg);
                this.errorHandler.error(errorMsg, null, 0);
                return;
            }
            this.send_nsca(event, return_code);
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::append(), ";
            LogLog.error((String)errorMsg, (Throwable)e);
            this.errorHandler.error(errorMsg, e, 0);
        }
    }

    public void close() {
    }

    public String getLayoutPartsDelimiter() {
        return this.layoutPartsDelimiter;
    }

    public void setLayoutPartsDelimiter(String c) {
        this.layoutPartsDelimiter = c;
    }

    public void flush_buffer() {
        try {
            int size = this.buffer.size();
            if (size < 1) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                LoggingEvent event = (LoggingEvent)this.buffer.get(i);
                this.send_nsca(event);
            }
            this.buffer.clear();
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::flush_buffer(), : " + e.getMessage();
            LogLog.error((String)errorMsg, (Throwable)e);
            this.errorHandler.error(errorMsg, e, 0);
            this.buffer.clear();
            return;
        }
    }

    public void activateOptions() {
        if (null != this.startupMsgLevel && null != this.startupMsg) {
            this.sendMessage(this.startupMsgLevel, this.startupMsg);
        }
        this.startupMsgLevel = "" + Level.OFF;
        this.startupMsg = null;
    }

    public void encrypt_buffer(byte[] buffer, byte[] server_iv) {
        switch (this.encryption_method) {
            case 0: {
                break;
            }
            case 1: {
                int y = 0;
                int x = 0;
                while (y < buffer.length) {
                    if (x >= 128) {
                        x = 0;
                    }
                    int n = y++;
                    buffer[n] = (byte)(buffer[n] ^ server_iv[x]);
                    ++x;
                }
                if (this.nsca_password == null) break;
                byte[] password = this.nsca_password.getBytes();
                int y2 = 0;
                int x2 = 0;
                while (y2 < buffer.length) {
                    if (x2 >= password.length) {
                        x2 = 0;
                    }
                    int n = y2++;
                    buffer[n] = (byte)(buffer[n] ^ password[x2]);
                    ++x2;
                }
                break;
            }
            default: {
                String errorMsg = "NagiosAppender::encrypt_buffer(): unsupported encryption method: " + this.encryption_method;
                LogLog.error((String)errorMsg);
                this.errorHandler.error(errorMsg, null, 0);
            }
        }
    }

    private void send_nsca(LoggingEvent event) {
        this.send_nsca(event, this.getReturnCode(event));
    }

    private void send_nsca(LoggingEvent event, int return_code) {
        if (null != this.getLayout()) {
            this.send_nsca("" + ((PatternLayout)this.getLayout()).format(event), return_code);
        } else {
            this.send_nsca("" + event.getMessage(), return_code);
        }
    }

    private void send_nsca(String message, int return_code) {
        if (null == message) {
            return;
        }
        try {
            this.nagiosClient.send_nsca(this.getHost(), this.getPort(), this.getHostName(), this.getServiceName(), message, return_code, this.encryption_method);
        }
        catch (Exception e) {
            String errorMsg = "NagiosAppender::send_nsca(), Exception thrown trying to deliver log4j record to Nagios: nagios server= " + this.getHost() + ", nagios port = " + this.getPort() + ": " + e.getMessage();
            LogLog.error((String)errorMsg, (Throwable)e);
            this.errorHandler.error(errorMsg, e, 0);
        }
    }

    private int getReturnCode(LoggingEvent event) {
        int return_code = 3;
        if (event.getLevel().equals((Object)Level.ERROR)) {
            return_code = this.Log4j_Level_ERROR;
        } else if (event.getLevel().equals((Object)Level.WARN)) {
            return_code = this.Log4j_Level_WARN;
        } else if (event.getLevel().equals((Object)Level.FATAL)) {
            return_code = this.Log4j_Level_FATAL;
        } else if (event.getLevel().equals((Object)Level.INFO)) {
            return_code = this.Log4j_Level_INFO;
        } else if (event.getLevel().equals((Object)Level.DEBUG)) {
            return_code = this.Log4j_Level_DEBUG;
        }
        return return_code;
    }

    protected String getMyHostName(boolean short_name_only) {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
        if (short_name_only && hostname.indexOf(".") > 0) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        return hostname;
    }

    private boolean failedRegexIncludeFilter(LoggingEvent event) {
        if (null == this.includeFilters) {
            return false;
        }
        Iterator it = this.includeFilters.keySet().iterator();
        while (it.hasNext()) {
            Matcher m = ((Pattern)this.includeFilters.get((String)it.next())).matcher((String)event.getMessage());
            if (!m.matches()) continue;
            return false;
        }
        return true;
    }

    private boolean failedRegexExcludeFilter(LoggingEvent event) {
        if (null == this.excludeFilters) {
            return false;
        }
        Iterator it = this.excludeFilters.keySet().iterator();
        while (it.hasNext()) {
            Matcher m = ((Pattern)this.excludeFilters.get((String)it.next())).matcher((String)event.getMessage());
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    protected String getHostName() {
        String hostname = null;
        if (this.use_MDC_for_hostname) {
            hostname = (String)MDC.get((String)this.MDC_hostname_key);
            if (null == hostname || hostname.length() == 0) {
                String errorMsg = "MDC lookup for hostname failed ... key = " + this.MDC_hostname_key;
                Exception e = new Exception(errorMsg);
                LogLog.error((String)errorMsg, (Throwable)e);
                this.errorHandler.error(errorMsg, e, 0);
                hostname = "NOT_SET";
            }
        } else {
            hostname = this.getMyHostName(this.short_hostname);
            if (null == hostname || hostname.length() == 0) {
                String errorMsg = "hostname was not set in log4j config file";
                Exception e = new Exception(errorMsg);
                LogLog.error((String)errorMsg, (Throwable)e);
                this.errorHandler.error(errorMsg, e, 0);
                hostname = "NOT_SET";
            }
        }
        return hostname;
    }

    protected String getServiceName() {
        String serviceName = null;
        if (this.use_MDC_for_servicename) {
            serviceName = (String)MDC.get((String)this.MDC_service_name_key);
            if (null == serviceName || serviceName.length() == 0) {
                String errorMsg = "MDC lookup for servicename failed ... key = " + this.MDC_service_name_key;
                Exception e = new Exception(errorMsg);
                LogLog.error((String)errorMsg, (Throwable)e);
                this.errorHandler.error(errorMsg, e, 0);
                serviceName = "NOT_SET";
            }
        } else {
            serviceName = this.getServiceNameDefault();
            if (null == serviceName || serviceName.length() == 0) {
                String errorMsg = "servicename was not set in log4j config file";
                Exception e = new Exception(errorMsg);
                LogLog.error((String)errorMsg, (Throwable)e);
                this.errorHandler.error(errorMsg, e, 0);
                serviceName = "NOT_SET";
            }
        }
        return serviceName;
    }

    static {
        Nagios_levels.setProperty("NAGIOS_OK", "0");
        Nagios_levels.setProperty("NAGIOS_WARN", "1");
        Nagios_levels.setProperty("NAGIOS_CRITICAL", "2");
        Nagios_levels.setProperty("NAGIOS_UNKNOWN", "3");
    }
}

