/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nagios;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Nsca {
    private static final int TRANSMITTED_IV_SIZE = 128;
    protected static final int ENCRYPT_NONE = 0;
    protected static final int ENCRYPT_XOR = 1;
    private String config_file = null;
    private int encryption_method = 0;
    private String nsca_password = null;
    public static final int DO_NOT_SEND = -1;
    public static final int NAGIOS_OK = 0;
    public static final int NAGIOS_WARN = 1;
    public static final int NAGIOS_CRITICAL = 2;
    public static final int NAGIOS_UNKNOWN = 3;
    private int nsca_version = 3;
    private boolean configured = false;
    private boolean ready = false;

    public void setConfigFile(String value) throws Exception {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.config_file = value;
        this.configure();
    }

    public void setEncryptionMethod(int value) {
        if (value < 0) {
            return;
        }
        this.encryption_method = value;
    }

    public void setPassword(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.nsca_password = value;
    }

    public boolean ready() throws Exception {
        if (this.ready) {
            return true;
        }
        if (!this.configured && !this.configure()) {
            return false;
        }
        this.ready = true;
        return this.ready;
    }

    protected boolean configure() throws Exception {
        BufferedReader in;
        try {
            if (this.configured) {
                return true;
            }
            if (this.config_file == null) {
                return true;
            }
            in = new BufferedReader(new FileReader(this.config_file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new Exception("send_nsca.configure() - File open error: " + this.config_file);
        }
        Pattern p = Pattern.compile("^(\\w+)\\s*=\\s*(\\w+)$");
        Matcher m = p.matcher("fred");
        try {
            String input;
            while ((input = in.readLine()) != null) {
                m.reset(input);
                if (!m.find() || m.groupCount() != 2) continue;
                if (m.group(1).compareTo("encryption_method") == 0) {
                    this.encryption_method = Integer.valueOf(m.group(2));
                }
                if (m.group(1).compareTo("password") != 0) continue;
                this.nsca_password = m.group(2);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            throw new Exception("send_nsca.configure() - I/O error: " + this.config_file);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw new Exception("send_nsca.configure() - Cannot close file: " + this.config_file);
        }
        this.configured = true;
        return true;
    }

    public void encrypt_buffer(int encryption_method, byte[] buffer, byte[] server_iv) throws Exception {
        switch (encryption_method) {
            case 0: {
                break;
            }
            case 1: {
                int y = 0;
                int x = 0;
                while (y < buffer.length) {
                    if (x >= 128) {
                        x = 0;
                    }
                    int n = y++;
                    buffer[n] = (byte)(buffer[n] ^ server_iv[x]);
                    ++x;
                }
                if (this.nsca_password == null) break;
                byte[] password = this.nsca_password.getBytes();
                int y2 = 0;
                int x2 = 0;
                while (y2 < buffer.length) {
                    if (x2 >= password.length) {
                        x2 = 0;
                    }
                    int n = y2++;
                    buffer[n] = (byte)(buffer[n] ^ password[x2]);
                    ++x2;
                }
                break;
            }
            default: {
                throw new Exception("NagiosAppender::encrypt_buffer(): unsupported encryption method: " + encryption_method);
            }
        }
    }

    public void send_nsca(String host, String port, String reportingHost, String reportingService, String message, int return_code, int encryption_method) throws Exception {
        if (null == message) {
            return;
        }
        Socket s = null;
        try {
            int portAsInt;
            do {
                portAsInt = 0;
                try {
                    portAsInt = Integer.parseInt(port);
                }
                catch (NumberFormatException ee) {
                    throw new Exception("NscaSend.send_nsca(): port was malformed: " + port);
                }
            } while (null == (s = new Socket(host, portAsInt)));
            OutputStream out = s.getOutputStream();
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte[] received_iv = new byte[128];
            in.readFully(received_iv, 0, 128);
            int time = in.readInt();
            byte[] host_name = new byte[64];
            String temp = null == reportingHost ? "UNKNOWN" : reportingHost;
            System.arraycopy(temp.getBytes(), 0, host_name, 0, temp.getBytes().length);
            byte[] service_name = new byte[128];
            temp = null == reportingService ? "UNKNOWN" : reportingService;
            System.arraycopy(temp.getBytes(), 0, service_name, 0, temp.getBytes().length);
            byte[] plugin_output = new byte[512];
            message.replaceAll("\n", "<linefeed>");
            if (null != message && message.getBytes().length <= 512) {
                System.arraycopy(message.getBytes(), 0, plugin_output, 0, message.getBytes().length);
            } else if (null != message) {
                System.arraycopy(message.getBytes(), 0, plugin_output, 0, plugin_output.length);
            } else {
                System.arraycopy("<null>".getBytes(), 0, plugin_output, 0, plugin_output.length);
            }
            int alert_size = 16 + host_name.length + service_name.length + plugin_output.length;
            byte[] alert = new byte[alert_size];
            alert[0] = (byte)(this.nsca_version >> 8 & 0xFF);
            alert[1] = (byte)(this.nsca_version & 0xFF);
            alert[4] = 0;
            alert[5] = 0;
            alert[6] = 0;
            alert[7] = 0;
            alert[8] = (byte)(time >> 24 & 0xFF);
            alert[9] = (byte)(time >> 16 & 0xFF);
            alert[10] = (byte)(time >> 8 & 0xFF);
            alert[11] = (byte)(time & 0xFF);
            alert[12] = (byte)(return_code >> 8 & 0xFF);
            alert[13] = (byte)(return_code & 0xFF);
            int offset = 14;
            System.arraycopy(host_name, 0, alert, offset, host_name.length);
            System.arraycopy(service_name, 0, alert, offset += host_name.length, service_name.length);
            System.arraycopy(plugin_output, 0, alert, offset += service_name.length, plugin_output.length);
            offset += plugin_output.length;
            CRC32 crc = new CRC32();
            crc.update(alert);
            long crc_value = crc.getValue();
            alert[4] = (byte)(crc_value >> 24 & 0xFFL);
            alert[5] = (byte)(crc_value >> 16 & 0xFFL);
            alert[6] = (byte)(crc_value >> 8 & 0xFFL);
            alert[7] = (byte)(crc_value & 0xFFL);
            this.encrypt_buffer(encryption_method, alert, received_iv);
            out.write(alert, 0, alert.length);
            out.flush();
            out.close();
            in.close();
            s.close();
        }
        catch (Exception e) {
            if (null != s) {
                try {
                    s.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        System.out.println("creating instance of Nsca ...");
        try {
            Nsca nsca = new Nsca();
            nsca.setConfigFile("conf/nsca_send_clear.cfg");
            nsca.send_nsca("localhost", "5667", "production", "MyApplication", "something bad just happened", 1, 0);
            System.out.println("send complete!!");
        }
        catch (Exception e) {
            System.out.println("exception thrown ... " + e.getMessage());
        }
    }
}

