/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.action.distortion.Distortion;

public class BifocalDistortion
extends Distortion {
    private double rx;
    private double ry;
    private double mx;
    private double my;

    public BifocalDistortion() {
        this(0.1, 3.0);
    }

    public BifocalDistortion(double range, double mag) {
        this(range, mag, range, mag);
    }

    public BifocalDistortion(double xrange, double xmag, double yrange, double ymag) {
        this.rx = xrange;
        this.mx = xmag;
        this.ry = yrange;
        this.my = ymag;
        this.m_distortX = this.rx != 0.0 && this.mx != 1.0;
        this.m_distortY = this.ry != 0.0 && this.my != 1.0;
    }

    @Override
    protected double distortX(double x, Point2D a, Rectangle2D b) {
        return this.bifocal(x, a.getX(), this.rx, this.mx, b.getMinX(), b.getMaxX());
    }

    @Override
    protected double distortY(double y, Point2D a, Rectangle2D b) {
        return this.bifocal(y, a.getY(), this.ry, this.my, b.getMinY(), b.getMaxY());
    }

    @Override
    protected double distortSize(Rectangle2D bbox, double x, double y, Point2D anchor, Rectangle2D bounds) {
        double m;
        boolean xmag = false;
        boolean ymag = false;
        if (this.m_distortX) {
            double cx = bbox.getCenterX();
            double ax = anchor.getX();
            double minX = bounds.getMinX();
            double maxX = bounds.getMaxX();
            double d = m = cx < ax ? ax - minX : maxX - ax;
            if (m == 0.0) {
                m = maxX - minX;
            }
            if (Math.abs(cx - ax) <= this.rx * m) {
                xmag = true;
            }
        }
        if (this.m_distortY) {
            double cy = bbox.getCenterY();
            double ay = anchor.getY();
            double minY = bounds.getMinY();
            double maxY = bounds.getMaxY();
            double d = m = cy < ay ? ay - minY : maxY - ay;
            if (m == 0.0) {
                m = maxY - minY;
            }
            if (Math.abs(cy - ay) <= this.ry * m) {
                ymag = true;
            }
        }
        if (xmag && !this.m_distortY) {
            return this.mx;
        }
        if (ymag && !this.m_distortX) {
            return this.my;
        }
        if (xmag && ymag) {
            return Math.min(this.mx, this.my);
        }
        return Math.min((1.0 - this.rx * this.mx) / (1.0 - this.rx), (1.0 - this.ry * this.my) / (1.0 - this.ry));
    }

    private double bifocal(double x, double a, double r, double mag, double min, double max) {
        double m;
        double d = m = x < a ? a - min : max - a;
        if (m == 0.0) {
            m = max - min;
        }
        double v = x - a;
        double s = m * r;
        if (Math.abs(v) <= s) {
            x = v * mag + a;
            return x;
        }
        double bx = r * mag;
        x = (Math.abs(v) - s) / m * ((1.0 - bx) / (1.0 - r));
        return (double)(v < 0.0 ? -1 : 1) * m * (x + bx) + a;
    }

    public double getXMagnification() {
        return this.mx;
    }

    public void setXMagnification(double mx) {
        this.mx = mx;
    }

    public double getYMagnification() {
        return this.my;
    }

    public void setYMagnification(double my) {
        this.my = my;
    }

    public double getXRange() {
        return this.rx;
    }

    public void setXRange(double rx) {
        this.rx = rx;
    }

    public double getYRange() {
        return this.ry;
    }

    public void setYRange(double ry) {
        this.ry = ry;
    }
}

