/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

public class ToolTipControl
extends ControlAdapter {
    private String[] label;
    private StringBuffer sbuf;

    public ToolTipControl(String field) {
        this(new String[]{field});
    }

    public ToolTipControl(String[] fields) {
        this.label = fields;
        if (fields.length > 1) {
            this.sbuf = new StringBuffer();
        }
    }

    @Override
    public void itemEntered(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        if (this.label.length == 1) {
            if (item.canGetString(this.label[0])) {
                d.setToolTipText(item.getString(this.label[0]));
            }
        } else {
            this.sbuf.delete(0, this.sbuf.length());
            for (int i = 0; i < this.label.length; ++i) {
                if (!item.canGetString(this.label[i])) continue;
                if (this.sbuf.length() > 0) {
                    this.sbuf.append("; ");
                }
                this.sbuf.append(item.getString(this.label[i]));
            }
            d.setToolTipText(this.sbuf.toString());
        }
    }

    @Override
    public void itemExited(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        d.setToolTipText(null);
    }
}

