/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class LongColumn
extends AbstractColumn {
    private long[] m_values;
    private int m_size;

    public LongColumn() {
        this(0, 10, 0L);
    }

    public LongColumn(int nrows) {
        this(nrows, nrows, 0L);
    }

    public LongColumn(int nrows, int capacity, long defaultValue) {
        super(Long.TYPE, new Long(defaultValue));
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new long[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nrows;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int nrows) {
        if (nrows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nrows);
            long[] values = new long[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, (Long)this.m_defaultValue);
            this.m_values = values;
        }
        this.m_size = nrows;
    }

    @Override
    public Object get(int row) {
        return new Long(this.getLong(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Number) {
            this.setLong(((Number)val).longValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    @Override
    public long getLong(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    @Override
    public void setLong(long val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        long prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }

    @Override
    public int getInt(int row) throws DataTypeException {
        return (int)this.getLong(row);
    }

    @Override
    public float getFloat(int row) throws DataTypeException {
        return this.getLong(row);
    }

    @Override
    public double getDouble(int row) throws DataTypeException {
        return this.getLong(row);
    }
}

