/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class ObjectColumn
extends AbstractColumn {
    private Object[] m_values;
    private int m_size;

    public ObjectColumn() {
        this(Object.class);
    }

    public ObjectColumn(Class type) {
        this(type, 0, 10, null);
    }

    public ObjectColumn(int nrows) {
        this(Object.class, nrows, nrows, null);
    }

    public ObjectColumn(Class type, int nrows) {
        this(type, nrows, nrows, null);
    }

    public ObjectColumn(Class type, int nrows, int capacity, Object defaultValue) {
        super(type, defaultValue);
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new Object[capacity];
        try {
            Cloneable def = (Cloneable)defaultValue;
            Method m = def.getClass().getMethod("clone", null);
            for (int i = 0; i < capacity; ++i) {
                this.m_values[i] = m.invoke(this.m_defaultValue, (Object[])null);
            }
        }
        catch (Exception e) {
            if (defaultValue != null) {
                Logger.getLogger(this.getClass().getName()).fine("Default value of type \"" + defaultValue.getClass().getName() + "\" is not " + "cloneable. Using Object reference directly.");
            }
            Arrays.fill(this.m_values, defaultValue);
        }
        this.m_size = nrows;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int nrows) {
        if (nrows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nrows);
            Object[] values = new Object[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            try {
                Cloneable def = (Cloneable)this.m_defaultValue;
                Method m = def.getClass().getMethod("clone", null);
                for (int i = this.m_size; i < capacity; ++i) {
                    values[i] = m.invoke(this.m_defaultValue, (Object[])null);
                }
            }
            catch (Exception e) {
                Arrays.fill(values, this.m_size, capacity, this.m_defaultValue);
            }
            this.m_values = values;
        }
        this.m_size = nrows;
    }

    @Override
    public void revertToDefault(int row) {
        try {
            Cloneable def = (Cloneable)this.m_defaultValue;
            Method m = def.getClass().getMethod("clone", null);
            this.set(m.invoke(this.m_defaultValue, (Object[])null), row);
        }
        catch (Exception e) {
            this.set(this.m_defaultValue, row);
        }
    }

    @Override
    public Object get(int row) {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    @Override
    public void set(Object val, int row) {
        Object prev;
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        if (val == null || this.canSet(val.getClass())) {
            prev = this.m_values[row];
            if (prev == val) {
                return;
            }
        } else {
            throw new DataTypeException(val.getClass());
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }
}

