/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Tuple;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractExpression
implements Expression,
ExpressionListener {
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();

    @Override
    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
    }

    @Override
    public final void addExpressionListener(ExpressionListener lstnr) {
        if (!this.m_listeners.contains(lstnr)) {
            this.m_listeners.add(lstnr);
            this.addChildListeners();
        }
    }

    @Override
    public final void removeExpressionListener(ExpressionListener lstnr) {
        this.m_listeners.remove(lstnr);
        if (this.m_listeners.size() == 0) {
            this.removeChildListeners();
        }
    }

    protected final boolean hasListeners() {
        return this.m_listeners != null && this.m_listeners.size() > 0;
    }

    protected final void fireExpressionChange() {
        Object[] lstnrs = this.m_listeners.getArray();
        for (int i = 0; i < lstnrs.length; ++i) {
            ((ExpressionListener)lstnrs[i]).expressionChanged(this);
        }
    }

    protected void addChildListeners() {
    }

    protected void removeChildListeners() {
    }

    @Override
    public void expressionChanged(Expression expr) {
        this.fireExpressionChange();
    }

    @Override
    public Object get(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(Tuple t) {
        throw new UnsupportedOperationException();
    }
}

