/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;

public class IfExpression
extends AbstractExpression {
    private Predicate m_test;
    private Expression m_then;
    private Expression m_else;

    public IfExpression(Predicate test, Expression thenExpr, Expression elseExpr) {
        this.m_test = test;
        this.m_then = thenExpr;
        this.m_else = elseExpr;
    }

    public Predicate getTestPredicate() {
        return this.m_test;
    }

    public Expression getThenExpression() {
        return this.m_then;
    }

    public Expression getElseExpression() {
        return this.m_else;
    }

    public void setTestPredicate(Predicate p) {
        this.m_test.removeExpressionListener(this);
        this.m_test = p;
        if (this.hasListeners()) {
            p.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setThenExpression(Expression e) {
        this.m_then.removeExpressionListener(this);
        this.m_then = e;
        if (this.hasListeners()) {
            e.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setElseExpression(Expression e) {
        this.m_else.removeExpressionListener(this);
        this.m_else = e;
        if (this.hasListeners()) {
            e.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    @Override
    public Class getType(Schema s) {
        Class type1 = this.m_then.getType(s);
        Class type2 = this.m_else.getType(s);
        return TypeLib.getSharedType(type1, type2);
    }

    @Override
    public Object get(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).get(t);
    }

    @Override
    public boolean getBoolean(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).getBoolean(t);
    }

    @Override
    public double getDouble(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).getDouble(t);
    }

    @Override
    public float getFloat(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).getFloat(t);
    }

    @Override
    public int getInt(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).getInt(t);
    }

    @Override
    public long getLong(Tuple t) {
        return (this.m_test.getBoolean(t) ? this.m_then : this.m_else).getLong(t);
    }

    @Override
    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
        v.down();
        this.m_test.visit(v);
        v.up();
        v.down();
        this.m_then.visit(v);
        v.up();
        v.down();
        this.m_else.visit(v);
        v.up();
    }

    @Override
    protected void addChildListeners() {
        this.m_test.addExpressionListener(this);
        this.m_then.addExpressionListener(this);
        this.m_else.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        this.m_test.removeExpressionListener(this);
        this.m_then.removeExpressionListener(this);
        this.m_else.removeExpressionListener(this);
    }

    public String toString() {
        return "IF " + this.m_test.toString() + " THEN " + this.m_then.toString() + " ELSE " + this.m_else.toString();
    }
}

