/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.io.AbstractGraphWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TreeMLReader;
import prefuse.util.io.XMLWriter;

public class TreeMLWriter
extends AbstractGraphWriter {
    private static final HashMap TYPES = new HashMap();

    @Override
    public void writeGraph(Graph graph, OutputStream os) throws DataIOException {
        Schema ns = graph.getNodeTable().getSchema();
        this.checkTreeMLSchema(ns);
        XMLWriter xml = new XMLWriter(new PrintWriter(os));
        xml.begin();
        xml.comment("prefuse TreeML Writer | " + new Date(System.currentTimeMillis()));
        xml.start("tree");
        xml.start("declarations");
        String[] attr = new String[]{"name", "type"};
        String[] vals = new String[2];
        for (int i = 0; i < ns.getColumnCount(); ++i) {
            vals[0] = ns.getColumnName(i);
            vals[1] = (String)TYPES.get(ns.getColumnType(i));
            xml.tag("attributeDecl", attr, vals, 2);
        }
        xml.end();
        xml.println();
        attr[0] = "name";
        attr[1] = "value";
        Node n = graph.getSpanningTree().getRoot();
        while (n != null) {
            boolean leaf;
            boolean bl = leaf = n.getChildCount() == 0;
            if (leaf) {
                xml.start("leaf");
            } else {
                xml.start("branch");
            }
            if (ns.getColumnCount() > 0) {
                for (int i = 0; i < ns.getColumnCount(); ++i) {
                    vals[0] = ns.getColumnName(i);
                    vals[1] = n.getString(vals[0]);
                    if (vals[1] == null) continue;
                    xml.tag("attribute", attr, vals, 2);
                }
            }
            n = this.nextNode(n, xml);
        }
        xml.end();
        xml.finish();
    }

    private Node nextNode(Node x, XMLWriter xml) {
        Node c = x.getChild(0);
        if (c == null) {
            c = x.getNextSibling();
            if (c != null) {
                xml.end();
            } else {
                xml.end();
                for (c = x.getParent(); c != null; c = c.getParent()) {
                    Node n = c.getNextSibling();
                    if (n != null) {
                        c = n;
                        xml.end();
                        break;
                    }
                    xml.end();
                }
            }
        }
        return c;
    }

    private void checkTreeMLSchema(Schema s) throws DataIOException {
        for (int i = 0; i < s.getColumnCount(); ++i) {
            Class type = s.getColumnType(i);
            if (TYPES.get(type) != null) continue;
            throw new DataIOException("Data type unsupported by the TreeML format: " + type.getName());
        }
    }

    static {
        TYPES.put(Integer.TYPE, "Int");
        TYPES.put(Long.TYPE, "Long");
        TYPES.put(Float.TYPE, "Float");
        TYPES.put(Double.TYPE, "Real");
        TYPES.put(Boolean.TYPE, "Boolean");
        TYPES.put(String.class, "String");
        TYPES.put(Date.class, "Date");
    }

    public static interface Tokens
    extends TreeMLReader.Tokens {
    }
}

