/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import prefuse.data.Tuple;
import prefuse.data.search.LuceneSearcher;
import prefuse.data.search.SearchTupleSet;
import prefuse.util.StringLib;
import prefuse.util.collections.IntObjectHashMap;

public class KeywordSearchTupleSet
extends SearchTupleSet {
    private static final Logger s_logger = Logger.getLogger(KeywordSearchTupleSet.class.getName());
    protected IntObjectHashMap m_map = new IntObjectHashMap();
    protected String m_query = "";
    protected LuceneSearcher m_lucene = null;
    protected boolean m_storeTermVectors = false;
    protected int m_id = 1;

    public KeywordSearchTupleSet() {
        this.m_lucene = new LuceneSearcher();
    }

    public KeywordSearchTupleSet(LuceneSearcher searcher) {
        this.m_lucene = searcher;
    }

    @Override
    public String getQuery() {
        return this.m_query;
    }

    @Override
    public void search(String query) {
        if (query == null) {
            query = "";
        }
        if (query.equals(this.m_query)) {
            return;
        }
        Tuple[] rem = this.clearInternal();
        this.m_query = query;
        query.trim();
        if (query.length() == 0) {
            this.fireTupleEvent(null, -1);
            return;
        }
        this.m_lucene.setReadMode(true);
        try {
            Hits hits = this.m_lucene.search(query);
            for (int i = 0; i < hits.length(); ++i) {
                Tuple t = this.getMatchingTuple(hits.doc(i));
                this.addInternal(t);
            }
            Tuple[] add = this.getTupleCount() > 0 ? this.toArray() : null;
            this.fireTupleEvent(add, rem);
        }
        catch (ParseException e) {
            s_logger.warning("Lucene query parse exception.\n" + StringLib.getStackTrace(e));
        }
        catch (IOException e) {
            s_logger.warning("Lucene IO exception.\n" + StringLib.getStackTrace(e));
        }
    }

    protected Tuple getMatchingTuple(Document d) {
        int id = Integer.parseInt(d.get("prefuse-id"));
        return (Tuple)this.m_map.get(id);
    }

    @Override
    public void index(Tuple t, String field) {
        this.m_lucene.setReadMode(false);
        String s = t.getString(field);
        if (s == null) {
            return;
        }
        int id = this.m_id++;
        this.m_lucene.addDocument(this.getDocument(id, s));
        this.m_map.put(id, t);
    }

    @Override
    public boolean isUnindexSupported() {
        return false;
    }

    @Override
    public void unindex(Tuple t, String attrName) {
        throw new UnsupportedOperationException();
    }

    protected Document getDocument(int id, String text) {
        Document d = new Document();
        d.add(Field.Text((String)"prefuse-text", (String)text, (boolean)this.m_storeTermVectors));
        d.add(Field.Keyword((String)"prefuse-id", (String)String.valueOf(id)));
        return d;
    }

    public LuceneSearcher getLuceneSearcher() {
        return this.m_lucene;
    }

    public IntObjectHashMap getTupleMap() {
        return (IntObjectHashMap)this.m_map.clone();
    }

    @Override
    public void clear() {
        this.m_lucene = new LuceneSearcher();
        super.clear();
    }
}

