/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import prefuse.data.Schema;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public class PolygonRenderer
extends AbstractShapeRenderer {
    public static final String POLYGON = "_polygon";
    public static final Schema POLYGON_SCHEMA = new Schema();
    private int m_polyType = 0;
    private float m_slack = 0.08f;
    private float m_epsilon = 0.1f;
    private boolean m_closed = true;
    private String m_polyfield = "_polygon";
    private GeneralPath m_path = new GeneralPath();

    public PolygonRenderer() {
        this(0);
    }

    public PolygonRenderer(int polyType) {
        this.m_polyType = polyType;
    }

    public int getPolyType() {
        return this.m_polyType;
    }

    public void setPolyType(int polyType) {
        if (polyType < 0 || polyType >= 3) {
            throw new IllegalArgumentException("Unknown edge type: " + polyType);
        }
        this.m_polyType = polyType;
    }

    public boolean isClosePath() {
        return this.m_closed;
    }

    public void setClosePath(boolean closePath) {
        this.m_closed = closePath;
    }

    public float getCurveSlack() {
        return this.m_slack;
    }

    public void setCurveSlack(float slack) {
        this.m_slack = slack;
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        float[] poly = (float[])item.get(this.m_polyfield);
        if (poly == null) {
            return null;
        }
        float x = (float)item.getX();
        float y = (float)item.getY();
        this.m_path.reset();
        this.m_path.moveTo(x + poly[0], y + poly[1]);
        if (this.m_polyType == 0) {
            for (int i = 2; i < poly.length && !Float.isNaN(poly[i]); i += 2) {
                this.m_path.lineTo(x + poly[i], y + poly[i + 1]);
            }
        } else {
            if (this.m_polyType == 1) {
                return GraphicsLib.cardinalSpline(this.m_path, poly, this.m_slack, this.m_closed, x, y);
            }
            if (this.m_polyType == 2) {
                return GraphicsLib.stackSpline(this.m_path, poly, this.m_epsilon, this.m_slack, this.m_closed, x, y);
            }
        }
        if (this.m_closed) {
            this.m_path.closePath();
        }
        return this.m_path;
    }

    static {
        POLYGON_SCHEMA.addColumn(POLYGON, float[].class);
    }
}

